/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.io.IOException;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.ddloaders.multiview.EntityHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityMethodController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CmpFieldHelper {
    private EntityHelper entityHelper;
    private CmpField field;
    public static final String PROPERTY_FIELD_ROW_CHANGED = "FIELD_ROW_CHANGED";

    public CmpFieldHelper(EntityHelper entityHelper, CmpField field) {
        this.entityHelper = entityHelper;
        this.field = field;
    }

    private void modelUpdatedFromUI() {
        this.entityHelper.modelUpdatedFromUI();
    }

    public void setLocalGetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), true, true, create);
    }

    public void setLocalSetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), false, true, create);
    }

    public void setRemoteGetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), true, false, create);
    }

    public void setRemoteSetter(boolean create) {
        this.entityHelper.updateFieldAccessor(this.getFieldName(), false, false, create);
    }

    public boolean deleteCmpField() {
        String message = NbBundle.getMessage(CmpFieldHelper.class, (String)"MSG_ConfirmDeleteField", (Object)this.field.getFieldName());
        String title = NbBundle.getMessage(CmpFieldHelper.class, (String)"MSG_ConfirmDeleteFieldTitle");
        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, title, 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)desc))) {
            EntityMethodController entityMethodController = this.entityHelper.getEntityMethodController();
            try {
                entityMethodController.deleteField(this.field, this.entityHelper.ejbJarFile);
                this.modelUpdatedFromUI();
                return true;
            }
            catch (IOException e) {
                Utils.notifyError(e);
            }
        }
        return false;
    }

    public void setFieldName(String newName) {
    }

    public void setDescription(String s) {
        this.field.setDescription(s);
        this.modelUpdatedFromUI();
    }

    public String getDefaultDescription() {
        return this.field.getDefaultDescription();
    }

    public String getFieldName() {
        return this.field.getFieldName();
    }

    public boolean isPrimary() {
        return this.getFieldName().equals(this.entityHelper.getPrimkeyField());
    }

    public boolean edit() {
        return false;
    }
}

