/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.annotations;

import javax.swing.text.Document;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.debugger.ui.annotations.Bundle;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DebuggerAnnotation
extends Annotation
implements Lookup.Provider {
    static final String WATCH_ANNOTATION_TYPE = "PinnedWatch";
    private final Line line;
    private final String type;
    private Watch watch;

    DebuggerAnnotation(String type, Line line) {
        this.type = type;
        this.line = line;
        this.attach((Annotatable)line);
    }

    DebuggerAnnotation(String type, Line.Part linePart) {
        this.type = type;
        this.line = linePart.getLine();
        this.attach((Annotatable)linePart);
    }

    public String getAnnotationType() {
        return this.type;
    }

    void setWatch(Watch watch) {
        this.watch = watch;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type == WATCH_ANNOTATION_TYPE) {
            return Bundle.TOOLTIP_WATCH_PIN();
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown annotation type '" + this.type + "'."));
        return null;
    }

    static synchronized OffsetsBag getHighlightsBag(Document doc) {
        OffsetsBag bag = (OffsetsBag)doc.getProperty(DebuggerAnnotation.class);
        if (bag == null) {
            bag = new OffsetsBag(doc, true);
            doc.putProperty(DebuggerAnnotation.class, bag);
        }
        return bag;
    }

    public Lookup getLookup() {
        if (this.watch == null) {
            return Lookup.EMPTY;
        }
        return Lookups.singleton((Object)this.watch);
    }
}

