/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractGenericContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.util.ObjectUtils;

public class AnnotationConfigContextLoader
extends AbstractGenericContextLoader {
    private static final Log logger = LogFactory.getLog(AnnotationConfigContextLoader.class);

    @Override
    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        if (ObjectUtils.isEmpty((Object[])configAttributes.getClasses()) && this.isGenerateDefaultLocations()) {
            Class<?>[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    @Override
    protected String[] modifyLocations(Class<?> clazz, String ... locations) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the modifyLocations(Class, String...) method");
    }

    @Override
    protected String[] generateDefaultLocations(Class<?> clazz) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the generateDefaultLocations(Class) method");
    }

    @Override
    protected String getResourceSuffix() {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the getResourceSuffix() method");
    }

    @Override
    protected void loadBeanDefinitions(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        Object[] annotatedClasses = mergedConfig.getClasses();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering annotated classes: " + ObjectUtils.nullSafeToString((Object[])annotatedClasses)));
        }
        new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)context).register((Class[])annotatedClasses);
    }

    @Override
    protected BeanDefinitionReader createBeanDefinitionReader(GenericApplicationContext context) {
        throw new UnsupportedOperationException("AnnotationConfigContextLoader does not support the createBeanDefinitionReader(GenericApplicationContext) method");
    }
}

