/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class ArtifactProvider
implements AntArtifactProvider {
    private final FreeformProject project;

    public ArtifactProvider(FreeformProject project) {
        this.project = project;
    }

    public AntArtifact[] getBuildArtifacts() {
        Element data = this.project.getPrimaryConfigurationData();
        ArrayList<FreeformArtifact> artifacts = new ArrayList<FreeformArtifact>();
        HashSet<String> ids = new HashSet<String>();
        HashMap<String, FreeformArtifact> uniqueArtifacts = new HashMap<String, FreeformArtifact>();
        for (Element export : XMLUtil.findSubElements((Element)data)) {
            if (!export.getLocalName().equals("export")) continue;
            FreeformArtifact artifact = new FreeformArtifact(export);
            String artifactKey = artifact.getType() + artifact.getTargetName() + artifact.getScriptLocation().getAbsolutePath();
            FreeformArtifact alreadyHasArtifact = (FreeformArtifact)((Object)uniqueArtifacts.get(artifactKey));
            if (alreadyHasArtifact != null) {
                alreadyHasArtifact.addLocation(ArtifactProvider.readArtifactLocation(export, this.project.evaluator()));
                continue;
            }
            artifact.addLocation(ArtifactProvider.readArtifactLocation(export, this.project.evaluator()));
            uniqueArtifacts.put(artifactKey, artifact);
            String id = artifact.preferredId();
            if (!ids.add(id)) {
                int counter = 2;
                while (true) {
                    String possibleId;
                    if (ids.add(possibleId = id + counter)) {
                        id = possibleId;
                        break;
                    }
                    ++counter;
                }
            }
            artifact.configureId(id);
            artifacts.add(artifact);
        }
        return artifacts.toArray(new AntArtifact[artifacts.size()]);
    }

    public static URI readArtifactLocation(Element export, PropertyEvaluator eval) {
        Element locEl = XMLUtil.findElement((Element)export, (String)"location", (String)"http://www.netbeans.org/ns/freeform-project/2");
        assert (locEl != null);
        String loc = XMLUtil.findText((Node)locEl);
        assert (loc != null);
        String locationResolved = eval.evaluate(loc);
        if (locationResolved == null) {
            return URI.create("file:/UNDEFINED");
        }
        File locF = new File(locationResolved);
        if (locF.isAbsolute()) {
            return Utilities.toURI((File)locF);
        }
        try {
            return new URI(null, null, locationResolved.replace(File.separatorChar, '/'), null);
        }
        catch (URISyntaxException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return URI.create("file:/BROKEN");
        }
    }

    private final class FreeformArtifact
    extends AntArtifact {
        private final Element export;
        private String id = null;
        private final Set<URI> locations = new LinkedHashSet<URI>();

        public FreeformArtifact(Element export) {
            this.export = export;
        }

        public String preferredId() {
            return this.getTargetName();
        }

        public void configureId(String id) {
            assert (this.id == null);
            this.id = id;
        }

        public String getType() {
            Element typeEl = XMLUtil.findElement((Element)this.export, (String)"type", (String)"http://www.netbeans.org/ns/freeform-project/2");
            assert (typeEl != null);
            String type = XMLUtil.findText((Node)typeEl);
            assert (type != null);
            return type;
        }

        public String getTargetName() {
            Element targetEl = XMLUtil.findElement((Element)this.export, (String)"build-target", (String)"http://www.netbeans.org/ns/freeform-project/2");
            assert (targetEl != null);
            String target = XMLUtil.findText((Node)targetEl);
            assert (target != null);
            return target;
        }

        public String getCleanTargetName() {
            Element targetEl = XMLUtil.findElement((Element)this.export, (String)"clean-target", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (targetEl != null) {
                String target = XMLUtil.findText((Node)targetEl);
                assert (target != null);
                return target;
            }
            String target = null;
            Element genldata = ArtifactProvider.this.project.getPrimaryConfigurationData();
            Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (actionsEl != null) {
                block0: for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
                    if (!actionEl.getAttribute("name").equals("clean")) continue;
                    for (Element actionTargetEl : XMLUtil.findSubElements((Element)actionEl)) {
                        if (!actionTargetEl.getLocalName().equals("target")) continue;
                        String possibleTarget = XMLUtil.findText((Node)actionTargetEl);
                        assert (possibleTarget != null);
                        if (target == null) {
                            target = possibleTarget;
                            continue;
                        }
                        target = null;
                        break block0;
                    }
                }
            }
            if (target == null) {
                target = "clean";
            }
            return target;
        }

        public File getScriptLocation() {
            String loc = null;
            Element scriptEl = XMLUtil.findElement((Element)this.export, (String)"script", (String)"http://www.netbeans.org/ns/freeform-project/2");
            if (scriptEl != null) {
                String script = XMLUtil.findText((Node)scriptEl);
                assert (script != null);
                loc = ArtifactProvider.this.project.evaluator().evaluate(script);
            }
            if (loc == null) {
                loc = "build.xml";
            }
            return ArtifactProvider.this.project.helper().resolveFile(loc);
        }

        public Project getProject() {
            return ArtifactProvider.this.project;
        }

        public String getID() {
            assert (this.id != null);
            return this.id;
        }

        public URI[] getArtifactLocations() {
            return this.locations.toArray(new URI[this.locations.size()]);
        }

        private void addLocation(URI u) {
            this.locations.add(u);
        }

        public String toString() {
            return "FreeformArtifact[" + ArtifactProvider.this.project + ":" + this.id + "]";
        }
    }
}

