/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.netbeans.modules.jshell.model.ConsoleModel;
import org.netbeans.modules.jshell.model.ConsoleSection;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.support.ShellSession;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;

public final class ConsoleContents
extends Parser.Result {
    private final ShellSession session;
    private final ConsoleModel consoleSnapshot;
    private final Map<ConsoleSection, List<SnippetHandle>> snippets = new HashMap<ConsoleSection, List<SnippetHandle>>();
    private volatile boolean invalidated;
    private ConsoleSection input;

    ConsoleContents(ShellSession session, ConsoleModel consoleSnapshot, Snapshot _snapshot) {
        super(_snapshot);
        this.session = session;
        this.consoleSnapshot = consoleSnapshot;
    }

    public ShellSession getSession() {
        return this.session;
    }

    public ConsoleModel getSectionModel() {
        return this.consoleSnapshot;
    }

    protected void invalidate() {
        this.invalidated = true;
    }

    void installSnippetHandles(ConsoleSection s, List<SnippetHandle> handles) {
        if (handles != null) {
            this.snippets.put(s, handles);
        }
    }

    public List<SnippetHandle> getHandles(ConsoleSection s) {
        if (!s.getType().java) {
            return Collections.emptyList();
        }
        List<SnippetHandle> res = this.snippets.get(s);
        if (res != null) {
            return res;
        }
        return Collections.emptyList();
    }

    public static ConsoleContents get(ResultIterator iter) throws ParseException {
        Parser.Result r = iter.getParserResult();
        if (!(r instanceof ConsoleContents)) {
            return null;
        }
        return (ConsoleContents)r;
    }

    public ConsoleSection getInputSection() {
        if (this.input == null) {
            this.input = this.consoleSnapshot.parseInputSection(this.getSnapshot().getText());
        }
        return this.input;
    }

    public Optional<SnippetHandle> findSnippetAt(int position) {
        return this.getSectionModel().getSections().stream().filter(s -> s.getStart() <= position && s.getEnd() >= position).findFirst().map(section -> this.getHandles((ConsoleSection)section).stream().filter(h -> h.contains(position)).findFirst().orElse(null));
    }

    public Optional<ConsoleSection> findSectionAt(int position) {
        return this.getSectionModel().getSections().stream().filter(s -> s.getStart() <= position && s.getEnd() >= position).findFirst();
    }
}

