/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ide.ergonomics.fod;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.modules.ide.ergonomics.fod.FeatureInfo;
import org.netbeans.modules.ide.ergonomics.fod.FeatureManager;
import org.netbeans.spi.autoupdate.UpdateItem;
import org.netbeans.spi.autoupdate.UpdateProvider;
import org.openide.modules.Dependency;
import org.openide.modules.ModuleInfo;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FoDUpdateUnitProvider
implements UpdateProvider {
    private static final Logger log = Logger.getLogger(FoDUpdateUnitProvider.class.getName());
    private static final Collection<String> EXCLUDE_EXTRA_MODULES = new HashSet<String>(Arrays.asList("org.netbeans.modules.java.source.nbjavac.test"));

    public String getName() {
        return "fod-provider";
    }

    public String getDisplayName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public UpdateUnitProvider.CATEGORY getCategory() {
        return UpdateUnitProvider.CATEGORY.STANDARD;
    }

    protected boolean acceptsModule(ModuleInfo mi) {
        return !EXCLUDE_EXTRA_MODULES.contains(mi.getCodeNameBase());
    }

    public Map<String, UpdateItem> getUpdateItems() throws IOException {
        HashMap<String, UpdateItem> res = new HashMap<String, UpdateItem>();
        Collection all = Lookup.getDefault().lookupAll(ModuleInfo.class);
        HashSet<ModuleInfo> notYetProcessed = new HashSet<ModuleInfo>(all);
        for (FeatureInfo featureInfo : FeatureManager.features()) {
            if (!featureInfo.isPresent()) continue;
            HashSet<String> cnbs = new HashSet<String>(featureInfo.getCodeNames());
            SpecificationVersion jdk = new SpecificationVersion(System.getProperty("java.specification.version"));
            for (FeatureInfo.ExtraModuleInfo mi : featureInfo.getExtraModules()) {
                String m = mi.explicitCodebase();
                if (m == null) continue;
                boolean required = false;
                if (mi.recMinJDK != null && jdk.compareTo((Object)mi.recMinJDK) < 0) {
                    required = true;
                }
                if (featureInfo.getExtraModulesRequiredText() != null && featureInfo.getExtraModulesRecommendedText() == null) {
                    required = true;
                }
                if (!required) continue;
                cnbs.add(m);
            }
            if (!this.registerFeature(all, cnbs, featureInfo.getFeatureCodeNameBase(), null, res, notYetProcessed)) continue;
        }
        HashSet<String> baseIDE = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        for (ModuleInfo mi : notYetProcessed) {
            if (!FeatureManager.showInAU(mi) || this.isPlatformCluster(mi)) continue;
            if (this.isIDECluster(mi)) {
                baseIDE.add(mi.getCodeNameBase());
                continue;
            }
            if (!this.acceptsModule(mi)) continue;
            hashSet.add(mi.getCodeNameBase());
        }
        this.registerFeature(all, baseIDE, "base.ide", NbBundle.getMessage(FoDUpdateUnitProvider.class, (String)"FeatureBaseIDE"), res, notYetProcessed);
        if (!hashSet.isEmpty()) {
            this.registerFeature(all, hashSet, "user.installed", NbBundle.getMessage(FoDUpdateUnitProvider.class, (String)"FeatureUserInstalled"), res, notYetProcessed);
        }
        return res;
    }

    public boolean refresh(boolean force) throws IOException {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean registerFeature(Collection<? extends ModuleInfo> allModules, Set<String> codeNames, String prefCnb, String displayName, Map<String, UpdateItem> res, Set<ModuleInfo> processed) {
        void var12_15;
        HashSet<String> justKits = new HashSet<String>();
        justKits.addAll(codeNames);
        String name = "fod." + prefCnb;
        ModuleInfo preferred = null;
        StringBuilder description = new StringBuilder();
        for (ModuleInfo moduleInfo : allModules) {
            if (prefCnb != null && prefCnb.equals(moduleInfo.getCodeNameBase())) {
                preferred = moduleInfo;
            }
            if (!codeNames.contains(moduleInfo.getCodeNameBase())) continue;
            processed.remove(moduleInfo);
            if (FeatureManager.showInAU(moduleInfo)) {
                StringBuilder sb = new StringBuilder();
                Object desc = moduleInfo.getLocalizedAttribute("OpenIDE-Module-Long-Description");
                if (!(desc instanceof String)) {
                    desc = moduleInfo.getLocalizedAttribute("OpenIDE-Module-Short-Description");
                }
                if (desc instanceof String) {
                    sb.append("<h5>").append(moduleInfo.getDisplayName()).append("</h5>");
                    sb.append(desc);
                    sb.append("\n");
                }
                if (preferred == moduleInfo) {
                    description.insert(0, sb);
                } else {
                    description.append((CharSequence)sb);
                }
                for (Dependency d : moduleInfo.getDependencies()) {
                    String cnb;
                    FeatureInfo fi;
                    if (d.getType() != 1 || (fi = FeatureManager.findInfo(d.getName())) == null || (cnb = "fod." + fi.getFeatureCodeNameBase()).equals(name)) continue;
                    justKits.add(cnb);
                }
                continue;
            }
            justKits.remove(moduleInfo.getCodeNameBase());
        }
        Object featureName = displayName;
        if (featureName == null) {
            if (preferred == null) {
                return true;
            }
            featureName = preferred.getLocalizedAttribute("OpenIDE-Module-Display-Category");
            if (!(name instanceof String)) {
                featureName = preferred.getDisplayName();
            }
            String string = preferred.getSpecificationVersion().toString();
        } else {
            String string = "1.0";
        }
        UpdateItem feature = UpdateItem.createFeature((String)name, (String)var12_15, justKits, (String)((String)featureName), (String)description.toString(), null);
        res.put(name, feature);
        return false;
    }

    private boolean isIDECluster(ModuleInfo mi) {
        return FeatureManager.isModuleFrom(mi, "ide");
    }

    private boolean isPlatformCluster(ModuleInfo mi) {
        if ("org.netbeans.modules.ide.branding.kit".equals(mi.getCodeName())) {
            return true;
        }
        return FeatureManager.isModuleFrom(mi, "platform");
    }
}

