/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.ui.actions;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.php.symfony.ui.actions.SymfonyGoToViewActionPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class SymfonyGoToViewActionPopup {
    private static final String POPUP_NAME = "goToViewPopup";
    private static final String CLOSE_KEY = "CloseKey";
    private static JDialog popupWindow;
    private HideAWTListener hideListener = new HideAWTListener();
    private int offset;
    private List<FileObject> views;

    public SymfonyGoToViewActionPopup(List<FileObject> views, int offset) {
        this.views = views;
        this.offset = offset;
    }

    public void show() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                SymfonyGoToViewActionPopup.this.showPanel();
            }
        });
    }

    private void showPanel() {
        String a11yDesc;
        if (popupWindow != null) {
            return;
        }
        this.addHideListener();
        popupWindow = new JDialog(this.getMainWindow());
        popupWindow.setName(POPUP_NAME);
        popupWindow.setUndecorated(true);
        popupWindow.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), CLOSE_KEY);
        popupWindow.getRootPane().getActionMap().put(CLOSE_KEY, new CloseAction());
        SymfonyGoToViewActionPanel content = new SymfonyGoToViewActionPanel(this.views, this);
        String a11yName = ((Component)content).getAccessibleContext().getAccessibleName();
        if (a11yName != null && !a11yName.equals("")) {
            popupWindow.getAccessibleContext().setAccessibleName(a11yName);
        }
        if ((a11yDesc = ((Component)content).getAccessibleContext().getAccessibleDescription()) != null && !a11yDesc.equals("")) {
            popupWindow.getAccessibleContext().setAccessibleDescription(a11yDesc);
        }
        popupWindow.getContentPane().add(content);
        this.moveToCorrectLocation();
        popupWindow.setVisible(true);
        content.requestFocus();
        content.requestFocusInWindow();
    }

    private void addHideListener() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this.hideListener, 16L);
        this.getMainWindow().addWindowStateListener(this.hideListener);
        this.getMainWindow().addComponentListener(this.hideListener);
    }

    private Frame getMainWindow() {
        return WindowManager.getDefault().getMainWindow();
    }

    private void moveToCorrectLocation() {
        popupWindow.pack();
        popupWindow.setLocation(this.fetchCorrectLocation());
    }

    private Point fetchCorrectLocation() {
        JTextComponent target = EditorRegistry.lastFocusedComponent();
        Point point = new Point();
        if (target != null) {
            try {
                Rectangle rectangle = target.modelToView(this.offset);
                point = new Point(rectangle.x, rectangle.y + rectangle.height);
                SwingUtilities.convertPointToScreen(point, target);
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return this.fetchAdjustedPosition(point);
    }

    private Point fetchAdjustedPosition(Point p) {
        int INSET = 10;
        Rectangle screen = Utilities.getUsableScreenBounds();
        Point newLocation = p;
        if (p.x + popupWindow.getWidth() > screen.x + screen.width - INSET) {
            newLocation.x = screen.x + screen.width - INSET - popupWindow.getWidth();
        }
        if (p.y + popupWindow.getHeight() > screen.y + screen.height - INSET) {
            newLocation.y = p.y - popupWindow.getHeight();
        }
        return newLocation;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void hide() {
        if (popupWindow != null) {
            this.removeHideListener();
            popupWindow.setVisible(false);
            popupWindow.dispose();
        }
        popupWindow = null;
    }

    private void removeHideListener() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.hideListener);
        this.getMainWindow().removeWindowStateListener(this.hideListener);
        this.getMainWindow().removeComponentListener(this.hideListener);
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SymfonyGoToViewActionPopup.this.hide();
        }
    }

    private class HideAWTListener
    extends ComponentAdapter
    implements AWTEventListener,
    WindowStateListener {
        private HideAWTListener() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            MouseEvent mv;
            if (aWTEvent instanceof MouseEvent && (mv = (MouseEvent)aWTEvent).getID() == 500 && mv.getClickCount() > 0) {
                if (!(aWTEvent.getSource() instanceof Component)) {
                    SymfonyGoToViewActionPopup.this.hide();
                    return;
                }
                Component comp = (Component)aWTEvent.getSource();
                Container par = SwingUtilities.getAncestorNamed(SymfonyGoToViewActionPopup.POPUP_NAME, comp);
                if (par == null) {
                    SymfonyGoToViewActionPopup.this.hide();
                }
            }
        }

        @Override
        public void windowStateChanged(WindowEvent windowEvent) {
            if (popupWindow != null) {
                int oldState = windowEvent.getOldState();
                int newState = windowEvent.getNewState();
                if ((oldState & 1) == 0 && (newState & 1) == 1) {
                    SymfonyGoToViewActionPopup.this.hide();
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent evt) {
            if (popupWindow != null) {
                SymfonyGoToViewActionPopup.this.moveToCorrectLocation();
            }
        }

        @Override
        public void componentMoved(ComponentEvent evt) {
            if (popupWindow != null) {
                SymfonyGoToViewActionPopup.this.moveToCorrectLocation();
            }
        }
    }
}

