/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.platform.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class PlatformSourceForBinaryQuery
implements SourceForBinaryQueryImplementation2 {
    private static final Logger LOG = Logger.getLogger(PlatformSourceForBinaryQuery.class.getName());
    private static final String JAR_FILE = "jar:file:";
    private static final String RTJAR_PATH = "/jre/lib/rt.jar!/";
    private static final String SRC_ZIP = "/src.zip";
    private Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new HashMap<URL, SourceForBinaryQueryImplementation2.Result>();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        SourceForBinaryQueryImplementation2.Result res = this.cache.get(binaryRoot);
        if (res != null) {
            return res;
        }
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        ArrayDeque<JavaPlatform> candidates = new ArrayDeque<JavaPlatform>();
        for (JavaPlatform platform : jpm.getInstalledPlatforms()) {
            if (!PlatformSourceForBinaryQuery.contains(platform, binaryRoot)) continue;
            candidates.add(platform);
        }
        if (!candidates.isEmpty()) {
            res = new Result(jpm, binaryRoot, candidates);
            this.cache.put(binaryRoot, res);
            return res;
        }
        String binaryRootS = binaryRoot.toExternalForm();
        if (binaryRootS.startsWith(JAR_FILE) && binaryRootS.endsWith(RTJAR_PATH)) {
            String srcZipS = binaryRootS.substring(4, binaryRootS.length() - RTJAR_PATH.length()) + SRC_ZIP;
            try {
                URL srcZip = FileUtil.getArchiveRoot((URL)new URL(srcZipS));
                FileObject fo = URLMapper.findFileObject((URL)srcZip);
                if (fo != null) {
                    return new UnregisteredPlatformResult(fo);
                }
            }
            catch (MalformedURLException mue) {
                Exceptions.printStackTrace((Throwable)mue);
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    static boolean contains(@NonNull JavaPlatform platform, @NonNull URL artifact) {
        for (ClassPath.Entry entry : platform.getBootstrapLibraries().entries()) {
            if (!entry.getURL().equals(artifact)) continue;
            return true;
        }
        return false;
    }

    private static class UnregisteredPlatformResult
    implements SourceForBinaryQueryImplementation2.Result {
        private final FileObject srcRoot;

        private UnregisteredPlatformResult(FileObject fo) {
            Parameters.notNull((CharSequence)"fo", (Object)fo);
            this.srcRoot = fo;
        }

        public FileObject[] getRoots() {
            FileObject[] fileObjectArray;
            if (this.srcRoot.isValid()) {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = this.srcRoot;
            } else {
                fileObjectArray = new FileObject[]{};
            }
            return fileObjectArray;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public boolean preferSources() {
            return false;
        }
    }

    private static final class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private static final String J2SE = "j2se";
        private static final SpecificationVersion JAVA_9 = new SpecificationVersion("9");
        private final JavaPlatformManager jpm;
        private final URL artifact;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private Map<JavaPlatform, PropertyChangeListener> platforms;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result(@NonNull JavaPlatformManager jpm, @NonNull URL artifact, @NonNull Collection<? extends JavaPlatform> platforms) {
            Parameters.notNull((CharSequence)"jpm", (Object)jpm);
            Parameters.notNull((CharSequence)"artifact", (Object)artifact);
            Parameters.notNull((CharSequence)"platforms", platforms);
            this.jpm = jpm;
            this.artifact = artifact;
            Result result = this;
            synchronized (result) {
                this.platforms = new LinkedHashMap<JavaPlatform, PropertyChangeListener>();
                for (JavaPlatform javaPlatform : platforms) {
                    PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)javaPlatform);
                    javaPlatform.addPropertyChangeListener(l);
                    this.platforms.put(javaPlatform, l);
                }
                this.jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jpm));
            }
        }

        @NonNull
        public FileObject[] getRoots() {
            for (JavaPlatform platform : this.platforms.keySet()) {
                String moduleName;
                ClassPath sourcePath = platform.getSourceFolders();
                FileObject[] sourceRoots = sourcePath.getRoots();
                if (sourceRoots.length <= 0) continue;
                if (Result.isModular(platform) && (moduleName = this.getModuleName(this.artifact)) != null) {
                    FileObject moduleRoot = null;
                    for (FileObject sourceRoot : sourceRoots) {
                        if (!moduleName.equals(sourceRoot.getNameExt())) continue;
                        moduleRoot = sourceRoot;
                        break;
                    }
                    if (moduleRoot != null) {
                        return new FileObject[]{moduleRoot};
                    }
                }
                return sourceRoots;
            }
            return new FileObject[0];
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.cs.removeChangeListener(listener);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent event) {
            if ("sourceFolders".equals(event.getPropertyName())) {
                this.cs.fireChange();
            } else if ("installedPlatforms".equals(event.getPropertyName()) && this.updateCandidates()) {
                this.cs.fireChange();
            }
        }

        public boolean preferSources() {
            return false;
        }

        private synchronized boolean updateCandidates() {
            boolean affected = false;
            JavaPlatform[] newPlatforms = this.jpm.getInstalledPlatforms();
            HashMap<JavaPlatform, PropertyChangeListener> oldPlatforms = new HashMap<JavaPlatform, PropertyChangeListener>(this.platforms);
            LinkedHashMap<JavaPlatform, PropertyChangeListener> newState = new LinkedHashMap<JavaPlatform, PropertyChangeListener>(newPlatforms.length);
            for (JavaPlatform jp : newPlatforms) {
                PropertyChangeListener l = (PropertyChangeListener)oldPlatforms.remove(jp);
                if (l != null) {
                    newState.put(jp, l);
                    continue;
                }
                if (!PlatformSourceForBinaryQuery.contains(jp, this.artifact)) continue;
                affected = true;
                l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.jpm);
                jp.addPropertyChangeListener(l);
                newState.put(jp, l);
            }
            for (Map.Entry entry : oldPlatforms.entrySet()) {
                affected = true;
                ((JavaPlatform)entry.getKey()).removePropertyChangeListener((PropertyChangeListener)entry.getValue());
            }
            this.platforms = newState;
            return affected;
        }

        private static boolean isModular(@NonNull JavaPlatform platform) {
            Specification spec = platform.getSpecification();
            return J2SE.equals(spec.getName()) && JAVA_9.compareTo((Object)spec.getVersion()) <= 0;
        }

        @CheckForNull
        private String getModuleName(URL root) {
            try {
                String[] nameComponents = root.getPath().split("/");
                if (nameComponents.length > 0) {
                    return URLDecoder.decode(nameComponents[nameComponents.length - 1], "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.warning(e.getMessage());
            }
            return null;
        }
    }
}

