/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.ECMAErrors;
import com.oracle.js.parser.ErrorManager;
import com.oracle.js.parser.JSErrorType;
import com.oracle.js.parser.JSType;
import com.oracle.js.parser.Options;
import com.oracle.js.parser.ParserException;
import com.oracle.js.parser.Scanner;
import com.oracle.js.parser.Source;
import com.oracle.js.parser.Token;
import com.oracle.js.parser.TokenLookup;
import com.oracle.js.parser.TokenStream;
import com.oracle.js.parser.TokenType;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.Deque;

public class Lexer
extends Scanner {
    private static final long MIN_INT_L = Integer.MIN_VALUE;
    private static final long MAX_INT_L = Integer.MAX_VALUE;
    private static final boolean XML_LITERALS = Options.getBooleanProperty("lexer.xmlliterals");
    private final Source source;
    private final TokenStream stream;
    private final boolean scripting;
    private final boolean shebang;
    private final boolean es6;
    private final boolean jsx;
    private final boolean nested;
    int pendingLine;
    private int linePosition;
    private TokenType last;
    private final boolean pauseOnFunctionBody;
    private boolean pauseOnNextLeftBrace;
    private int jsxTagCount;
    private boolean jsxTag;
    private boolean jsxClosing;
    private boolean template;
    private boolean templateExpression;
    private int nextStateChange;
    private int openExpressionBraces;
    private final Deque<InnerState> innerStates = new ArrayDeque<InnerState>();
    private static final String SPACETAB = " \t";
    private static final String LFCR = "\n\r";
    private static final String JSON_WHITESPACE_EOL = "\n\r";
    private static final String JSON_WHITESPACE = " \t\n\r";
    private static final String JAVASCRIPT_WHITESPACE_EOL = "\n\r\u2028\u2029";
    private static final String JAVASCRIPT_WHITESPACE = " \t\n\r\u2028\u2029\u000b\f\u00a0\u1680\u180e\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u202f\u205f\u3000\ufeff";
    private static final String JAVASCRIPT_WHITESPACE_IN_REGEXP = "\\u000a\\u000d\\u2028\\u2029\\u0009\\u0020\\u000b\\u000c\\u00a0\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\ufeff";

    public static String unicodeEscape(char c) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\u");
        String string = Integer.toHexString(c);
        for (int i = string.length(); i < 4; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public Lexer(Source source, TokenStream tokenStream) {
        this(source, tokenStream, false, false, false, false);
    }

    public Lexer(Source source, TokenStream tokenStream, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(source, 0, source.getLength(), tokenStream, bl, bl2, bl3, false, bl4);
    }

    public Lexer(Source source, int n, int n2, TokenStream tokenStream, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(source.getContent(), 1, n, n2);
        this.source = source;
        this.stream = tokenStream;
        this.scripting = bl;
        this.es6 = bl2;
        this.jsx = bl5;
        this.shebang = bl3;
        this.nested = false;
        this.pendingLine = 1;
        this.last = TokenType.EOL;
        this.pauseOnFunctionBody = bl4;
    }

    private Lexer(Lexer lexer, State state) {
        super(lexer, state);
        this.source = lexer.source;
        this.stream = lexer.stream;
        this.scripting = lexer.scripting;
        this.es6 = lexer.es6;
        this.jsx = lexer.jsx;
        this.shebang = lexer.shebang;
        this.nested = true;
        this.pendingLine = state.pendingLine;
        this.linePosition = state.linePosition;
        this.last = TokenType.EOL;
        this.pauseOnFunctionBody = false;
    }

    @Override
    State saveState() {
        return new State(this.position, this.limit, this.line, this.pendingLine, this.linePosition, this.last);
    }

    void restoreState(State state) {
        super.restoreState(state);
        this.pendingLine = state.pendingLine;
        this.linePosition = state.linePosition;
        this.last = state.last;
    }

    protected void add(TokenType tokenType, int n, int n2) {
        this.last = tokenType;
        if (tokenType == TokenType.EOL) {
            this.pendingLine = n2;
            this.linePosition = n;
        } else {
            if (this.pendingLine != -1) {
                this.stream.put(Token.toDesc(TokenType.EOL, this.linePosition, this.pendingLine));
                this.pendingLine = -1;
            }
            this.stream.put(Token.toDesc(tokenType, n, n2 - n));
        }
    }

    protected void add(TokenType tokenType, int n) {
        this.add(tokenType, n, this.position);
    }

    public static String getWhitespaceRegExp() {
        return JAVASCRIPT_WHITESPACE_IN_REGEXP;
    }

    private void skipEOL(boolean bl) {
        if (this.ch0 == '\r') {
            this.skip(1);
            if (this.ch0 == '\n') {
                this.skip(1);
            }
        } else {
            this.skip(1);
        }
        ++this.line;
        if (bl) {
            this.add(TokenType.EOL, this.position, this.line);
        }
    }

    private void skipLine(boolean bl) {
        while (!this.isEOL(this.ch0) && !this.atEOF()) {
            this.skip(1);
        }
        this.skipEOL(bl);
    }

    public static boolean isJSWhitespace(char c) {
        return JAVASCRIPT_WHITESPACE.indexOf(c) != -1;
    }

    public static boolean isJSEOL(char c) {
        return JAVASCRIPT_WHITESPACE_EOL.indexOf(c) != -1;
    }

    public static boolean isJsonWhitespace(char c) {
        return JSON_WHITESPACE.indexOf(c) != -1;
    }

    public static boolean isJsonEOL(char c) {
        return "\n\r".indexOf(c) != -1;
    }

    protected boolean isStringDelimiter(char c) {
        return c == '\'' || c == '\"';
    }

    private static boolean isTemplateDelimiter(char c) {
        return c == '`';
    }

    protected boolean isWhitespace(char c) {
        return Lexer.isJSWhitespace(c);
    }

    protected boolean isEOL(char c) {
        return Lexer.isJSEOL(c);
    }

    private void skipWhitespace(boolean bl) {
        while (this.isWhitespace(this.ch0)) {
            if (this.isEOL(this.ch0)) {
                this.skipEOL(bl);
                continue;
            }
            this.skip(1);
        }
    }

    protected boolean skipComments() {
        int n = this.position;
        if (this.ch0 == '/') {
            if (this.ch1 == '/') {
                this.skip(2);
                boolean bl = false;
                if ((this.ch0 == '#' || this.ch0 == '@') && this.ch1 == ' ') {
                    bl = true;
                }
                while (!this.atEOF() && !this.isEOL(this.ch0)) {
                    this.skip(1);
                }
                this.add(bl ? TokenType.DIRECTIVE_COMMENT : TokenType.COMMENT, n);
                return true;
            }
            if (this.ch1 == '*') {
                this.skip(2);
                while (!(this.atEOF() || this.ch0 == '*' && this.ch1 == '/')) {
                    if (this.isEOL(this.ch0)) {
                        this.skipEOL(true);
                        continue;
                    }
                    this.skip(1);
                }
                if (this.atEOF()) {
                    this.add(TokenType.ERROR, n);
                } else {
                    this.skip(2);
                }
                this.add(TokenType.COMMENT, n);
                return true;
            }
        } else if (this.ch0 == '#') {
            assert (this.scripting);
            this.skip(1);
            while (!this.atEOF() && !this.isEOL(this.ch0)) {
                this.skip(1);
            }
            this.add(TokenType.COMMENT, n);
            return true;
        }
        return false;
    }

    public RegexToken valueOfPattern(int n, int n2) {
        int n3 = this.position;
        this.reset(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        this.skip(1);
        boolean bl = false;
        while (!this.atEOF() && this.ch0 != '/' && !this.isEOL(this.ch0) || bl) {
            if (this.ch0 == '\\') {
                stringBuilder.append(this.ch0);
                stringBuilder.append(this.ch1);
                this.skip(2);
                continue;
            }
            if (this.ch0 == '[') {
                bl = true;
            } else if (this.ch0 == ']') {
                bl = false;
            }
            stringBuilder.append(this.ch0);
            this.skip(1);
        }
        String string = stringBuilder.toString();
        this.skip(1);
        String string2 = this.source.getString(this.position, this.scanIdentifier());
        this.reset(n3);
        return new RegexToken(string, string2);
    }

    public boolean canStartLiteral(TokenType tokenType) {
        return tokenType.startsWith('/') || (this.scripting || XML_LITERALS) && tokenType.startsWith('<') || this.jsx && tokenType.startsWith('<');
    }

    protected boolean scanLiteral(long l, TokenType tokenType, LineInfoReceiver lineInfoReceiver) {
        if (!this.canStartLiteral(tokenType)) {
            return false;
        }
        if (this.stream.get(this.stream.last()) != l) {
            return false;
        }
        this.reset(Token.descPosition(l));
        if (this.ch0 == '/') {
            return this.scanRegEx();
        }
        if (this.ch0 == '<') {
            if (this.ch1 == '<') {
                return this.scanHereString(lineInfoReceiver);
            }
            if (Character.isJavaIdentifierStart(this.ch1)) {
                return this.scanXMLLiteral();
            }
        }
        return false;
    }

    protected boolean scanJsx(long l, TokenType tokenType) {
        if (!tokenType.startsWith('<')) {
            return false;
        }
        if (this.stream.get(this.stream.last()) != l) {
            return false;
        }
        this.reset(Token.descPosition(l));
        if (this.ch0 == '<' && this.ch1 != '<') {
            this.jsxTagCount = 1;
            this.jsxTag = true;
            this.skip(1);
            return true;
        }
        return false;
    }

    private boolean scanRegEx() {
        assert (this.ch0 == '/');
        if (this.ch1 != '/' && this.ch1 != '*') {
            int n = this.position;
            this.skip(1);
            boolean bl = false;
            while (!(this.atEOF() || this.ch0 == '/' && !bl || this.isEOL(this.ch0))) {
                if (this.ch0 == '\\') {
                    this.skip(1);
                    if (this.isEOL(this.ch0)) {
                        this.reset(n);
                        return false;
                    }
                    this.skip(1);
                    continue;
                }
                if (this.ch0 == '[') {
                    bl = true;
                } else if (this.ch0 == ']') {
                    bl = false;
                }
                this.skip(1);
            }
            if (this.ch0 == '/') {
                this.skip(1);
                while (!this.atEOF() && Character.isJavaIdentifierPart(this.ch0) || this.ch0 == '\\' && this.ch1 == 'u') {
                    this.skip(1);
                }
                this.add(TokenType.REGEX, n);
                return true;
            }
            this.reset(n);
        }
        return false;
    }

    protected static int convertDigit(char c, int n) {
        int n2;
        if ('0' <= c && c <= '9') {
            n2 = c - 48;
        } else if ('A' <= c && c <= 'Z') {
            n2 = c - 65 + 10;
        } else if ('a' <= c && c <= 'z') {
            n2 = c - 97 + 10;
        } else {
            return -1;
        }
        return n2 < n ? n2 : -1;
    }

    private int hexSequence(int n, TokenType tokenType) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = Lexer.convertDigit(this.ch0, 16);
            if (n3 == -1) {
                this.error(Lexer.message("invalid.hex", new String[0]), tokenType, this.position, this.limit);
                return i == 0 ? -1 : n2;
            }
            n2 = n3 | n2 << 4;
            this.skip(1);
        }
        return n2;
    }

    private int varlenHexSequence(TokenType tokenType) {
        assert (this.ch0 == '{');
        this.skip(1);
        int n = 0;
        int n2 = 0;
        while (!this.atEOF()) {
            if (this.ch0 == '}') {
                if (n2 != 0) {
                    this.skip(1);
                    return n;
                }
                this.error(Lexer.message("invalid.hex", new String[0]), tokenType, this.position, this.limit);
                this.skip(1);
                return -1;
            }
            int n3 = Lexer.convertDigit(this.ch0, 16);
            if (n3 == -1) {
                this.error(Lexer.message("invalid.hex", new String[0]), tokenType, this.position, this.limit);
                return n2 == 0 ? -1 : n;
            }
            if ((n = n3 | n << 4) > 0x10FFFF) {
                this.error(Lexer.message("invalid.hex", new String[0]), tokenType, this.position, this.limit);
                return -1;
            }
            this.skip(1);
            ++n2;
        }
        return n;
    }

    private int unicodeEscapeSequence(TokenType tokenType) {
        if (this.ch0 == '{' && this.es6) {
            return this.varlenHexSequence(tokenType);
        }
        return this.hexSequence(4, tokenType);
    }

    private int octalSequence() {
        int n;
        int n2 = 0;
        for (int i = 0; i < 3 && (n = Lexer.convertDigit(this.ch0, 8)) != -1; ++i) {
            n2 = n | n2 << 3;
            this.skip(1);
            if (i == 1 && n2 >= 32) break;
        }
        return n2;
    }

    private String valueOfIdent(int n, int n2) throws RuntimeException {
        int n3 = this.position;
        int n4 = n + n2;
        this.reset(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        while (!this.atEOF() && this.position < n4 && !this.isEOL(this.ch0)) {
            if (this.ch0 == '\\' && this.ch1 == 'u') {
                this.skip(2);
                int n5 = this.unicodeEscapeSequence(TokenType.IDENT);
                if (Character.isBmpCodePoint(n5) && this.isWhitespace((char)n5)) {
                    return null;
                }
                if (n5 < 0) {
                    stringBuilder.append('\\');
                    stringBuilder.append('u');
                    continue;
                }
                stringBuilder.appendCodePoint(n5);
                continue;
            }
            stringBuilder.append(this.ch0);
            this.skip(1);
        }
        this.reset(n3);
        return stringBuilder.toString();
    }

    private void scanIdentifierOrKeyword() {
        int n = this.position;
        int n2 = this.scanIdentifier();
        TokenType tokenType = TokenLookup.lookupKeyword(this.content, n, n2);
        if (tokenType == TokenType.FUNCTION && this.pauseOnFunctionBody) {
            this.pauseOnNextLeftBrace = true;
        }
        this.add(tokenType, n);
    }

    private String valueOfString(int n, int n2, boolean bl) {
        int n3 = this.position;
        int n4 = n + n2;
        this.reset(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        block16: while (this.position < n4) {
            if (this.ch0 == '\\') {
                this.skip(1);
                char c = this.ch0;
                int n5 = this.position;
                this.skip(1);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        if (bl && (c != '0' || this.ch0 >= '0' && this.ch0 <= '9')) {
                            this.error(Lexer.message("strict.no.octal", new String[0]), TokenType.STRING, this.position, this.limit);
                        }
                        this.reset(n5);
                        int n6 = this.octalSequence();
                        if (n6 < 0) {
                            stringBuilder.append('\\');
                            stringBuilder.append('x');
                            continue block16;
                        }
                        stringBuilder.append((char)n6);
                        continue block16;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block16;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        continue block16;
                    }
                    case 'b': {
                        stringBuilder.append('\b');
                        continue block16;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block16;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block16;
                    }
                    case '\'': {
                        stringBuilder.append('\'');
                        continue block16;
                    }
                    case '\"': {
                        stringBuilder.append('\"');
                        continue block16;
                    }
                    case '\\': {
                        stringBuilder.append('\\');
                        continue block16;
                    }
                    case '\r': {
                        if (this.ch0 == '\n') {
                            this.skip(1);
                        }
                    }
                    case '\n': 
                    case '\u2028': 
                    case '\u2029': {
                        continue block16;
                    }
                    case 'x': {
                        int n6 = this.hexSequence(2, TokenType.STRING);
                        if (n6 < 0) {
                            stringBuilder.append('\\');
                            stringBuilder.append('x');
                            continue block16;
                        }
                        stringBuilder.append((char)n6);
                        continue block16;
                    }
                    case 'u': {
                        int n6 = this.unicodeEscapeSequence(TokenType.STRING);
                        if (n6 < 0) {
                            stringBuilder.append('\\');
                            stringBuilder.append('u');
                            continue block16;
                        }
                        stringBuilder.appendCodePoint(n6);
                        continue block16;
                    }
                    case 'v': {
                        stringBuilder.append('\u000b');
                        continue block16;
                    }
                }
                stringBuilder.append(c);
                continue;
            }
            if (this.ch0 == '\r') {
                stringBuilder.append('\n');
                this.skip(this.ch1 == '\n' ? 2 : 1);
                continue;
            }
            stringBuilder.append(this.ch0);
            this.skip(1);
        }
        this.reset(n3);
        return stringBuilder.toString();
    }

    protected void scanString(boolean bl) {
        TokenType tokenType = TokenType.STRING;
        char c = this.ch0;
        this.skip(1);
        State state = this.saveState();
        while (!this.atEOF() && this.ch0 != c && !this.isEOL(this.ch0)) {
            if (this.ch0 == '\\') {
                tokenType = TokenType.ESCSTRING;
                this.skip(1);
                if (!this.isEscapeCharacter(this.ch0)) {
                    this.error(Lexer.message("invalid.escape.char", new String[0]), TokenType.STRING, this.position, this.limit);
                }
                if (this.isEOL(this.ch0)) {
                    this.skipEOL(false);
                    continue;
                }
            }
            this.skip(1);
        }
        if (this.ch0 == c) {
            this.skip(1);
        } else {
            this.error(Lexer.message("missing.close.quote", new String[0]), TokenType.STRING, this.position, this.limit);
        }
        if (bl) {
            state.setLimit(this.position - 1);
            if (this.scripting && !state.isEmpty()) {
                switch (c) {
                    case '`': {
                        this.add(TokenType.EXECSTRING, state.position, state.limit);
                        this.add(TokenType.LBRACE, state.position, state.position);
                        this.editString(tokenType, state);
                        this.add(TokenType.RBRACE, state.limit, state.limit);
                        break;
                    }
                    case '\"': {
                        this.editString(tokenType, state);
                        break;
                    }
                    case '\'': {
                        this.add(tokenType, state.position, state.limit);
                        break;
                    }
                }
            } else {
                this.add(tokenType, state.position, state.limit);
            }
        }
    }

    protected boolean isEscapeCharacter(char c) {
        return true;
    }

    private static Number valueOf(String string, int n) throws NumberFormatException {
        try {
            long l = Long.parseLong(string, n);
            if (l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE) {
                return (int)l;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            if (n == 10) {
                return Double.valueOf(string);
            }
            if (n == 16 && string.length() >= 15) {
                return new BigInteger(string, 16).doubleValue();
            }
            double d = 0.0;
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                int n2 = Lexer.convertDigit(c, n);
                d *= (double)n;
                d += (double)n2;
            }
            return d;
        }
    }

    protected void scanNumber() {
        int n = this.position;
        TokenType tokenType = TokenType.DECIMAL;
        int n2 = Lexer.convertDigit(this.ch0, 10);
        if (n2 == 0 && (this.ch1 == 'x' || this.ch1 == 'X') && Lexer.convertDigit(this.ch2, 16) != -1) {
            this.skip(3);
            while (Lexer.convertDigit(this.ch0, 16) != -1) {
                this.skip(1);
            }
            tokenType = TokenType.HEXADECIMAL;
        } else if (n2 == 0 && this.es6 && (this.ch1 == 'o' || this.ch1 == 'O') && Lexer.convertDigit(this.ch2, 8) != -1) {
            this.skip(3);
            while (Lexer.convertDigit(this.ch0, 8) != -1) {
                this.skip(1);
            }
            tokenType = TokenType.OCTAL;
        } else if (n2 == 0 && this.es6 && (this.ch1 == 'b' || this.ch1 == 'B') && Lexer.convertDigit(this.ch2, 2) != -1) {
            this.skip(3);
            while (Lexer.convertDigit(this.ch0, 2) != -1) {
                this.skip(1);
            }
            tokenType = TokenType.BINARY_NUMBER;
        } else {
            boolean bl;
            boolean bl2 = bl = n2 == 0;
            if (n2 != -1) {
                this.skip(1);
            }
            while ((n2 = Lexer.convertDigit(this.ch0, 10)) != -1) {
                bl = bl && n2 < 8;
                this.skip(1);
            }
            if (bl && this.position - n > 1) {
                tokenType = TokenType.OCTAL_LEGACY;
            } else if (this.ch0 == '.' || this.ch0 == 'E' || this.ch0 == 'e') {
                if (this.ch0 == '.') {
                    this.skip(1);
                    while (Lexer.convertDigit(this.ch0, 10) != -1) {
                        this.skip(1);
                    }
                }
                if (this.ch0 == 'E' || this.ch0 == 'e') {
                    this.skip(1);
                    if (this.ch0 == '+' || this.ch0 == '-') {
                        this.skip(1);
                    }
                    while (Lexer.convertDigit(this.ch0, 10) != -1) {
                        this.skip(1);
                    }
                }
                tokenType = TokenType.FLOATING;
            }
        }
        if (Character.isJavaIdentifierStart(this.ch0)) {
            this.error(Lexer.message("missing.space.after.number", new String[0]), tokenType, this.position, 1);
        }
        this.add(tokenType, n);
    }

    XMLToken valueOfXML(int n, int n2) {
        return new XMLToken(this.source.getString(n, n2));
    }

    private boolean scanXMLLiteral() {
        assert (this.ch0 == '<' && Character.isJavaIdentifierStart(this.ch1));
        if (XML_LITERALS) {
            int n = this.position;
            int n2 = 0;
            do {
                if (this.ch0 == '<') {
                    if (this.ch1 == '/' && Character.isJavaIdentifierStart(this.ch2)) {
                        this.skip(3);
                        --n2;
                    } else if (Character.isJavaIdentifierStart(this.ch1)) {
                        this.skip(2);
                        ++n2;
                    } else if (this.ch1 == '?') {
                        this.skip(2);
                    } else if (this.ch1 == '!' && this.ch2 == '-' && this.ch3 == '-') {
                        this.skip(4);
                    } else {
                        this.reset(n);
                        return false;
                    }
                    while (!this.atEOF() && this.ch0 != '>') {
                        if (this.ch0 == '/' && this.ch1 == '>') {
                            --n2;
                            this.skip(1);
                            break;
                        }
                        if (this.ch0 == '\"' || this.ch0 == '\'') {
                            this.scanString(false);
                            continue;
                        }
                        this.skip(1);
                    }
                    if (this.ch0 != '>') {
                        this.reset(n);
                        return false;
                    }
                    this.skip(1);
                    continue;
                }
                if (this.atEOF()) {
                    this.reset(n);
                    return false;
                }
                this.skip(1);
            } while (n2 > 0);
            this.add(TokenType.XML, n);
            return true;
        }
        return false;
    }

    private void scanJsxIdentifier() {
        int n = this.position;
        int n2 = this.scanIdentifier();
        if (n2 > 0 && this.ch0 == '-') {
            ++n2;
            this.skip(1);
        }
        this.add(TokenType.JSX_IDENTIFIER, n);
    }

    private void scanJsxText() {
        int n = this.position;
        while (!this.atEOF() && this.ch0 != '{' && this.ch0 != '}' && this.ch0 != '<' && this.ch0 != '>') {
            this.skip(1);
        }
        this.add(TokenType.JSX_TEXT, n);
    }

    private void scanJsxString() {
        assert (this.ch0 == '\"' || this.ch0 == '\'');
        char c = this.ch0;
        this.skip(1);
        int n = this.position;
        while (!this.atEOF()) {
            if (this.ch0 == c) {
                this.skip(1);
                break;
            }
            this.skip(1);
        }
        this.add(TokenType.JSX_STRING, n, this.position - 1);
    }

    private int scanIdentifier() {
        int n;
        int n2 = this.position;
        if (this.ch0 == '\\' && this.ch1 == 'u') {
            this.skip(2);
            n = this.unicodeEscapeSequence(TokenType.IDENT);
            if (!Character.isJavaIdentifierStart(n)) {
                this.error(Lexer.message("illegal.identifier.character", new String[0]), TokenType.IDENT, n2, this.position);
            }
        } else if (!Character.isJavaIdentifierStart(this.ch0)) {
            return 0;
        }
        while (!this.atEOF()) {
            if (this.ch0 == '\\' && this.ch1 == 'u') {
                this.skip(2);
                n = this.unicodeEscapeSequence(TokenType.IDENT);
                if (Character.isJavaIdentifierPart(n)) continue;
                this.error(Lexer.message("illegal.identifier.character", new String[0]), TokenType.IDENT, n2, this.position);
                continue;
            }
            if (!Character.isJavaIdentifierPart(this.ch0)) break;
            this.skip(1);
        }
        return this.position - n2;
    }

    private boolean identifierEqual(int n, int n2, int n3, int n4) {
        if (n2 == n4) {
            for (int i = 0; i < n2; ++i) {
                if (this.content.charAt(n + i) == this.content.charAt(n3 + i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean hasHereMarker(int n, int n2) {
        this.skipWhitespace(false);
        return this.identifierEqual(n, n2, this.position, this.scanIdentifier());
    }

    private void editString(TokenType tokenType, State state) {
        EditStringLexer editStringLexer = new EditStringLexer(this, tokenType, state);
        editStringLexer.lexify();
        this.last = tokenType;
    }

    private boolean scanHereString(LineInfoReceiver lineInfoReceiver) {
        assert (this.ch0 == '<' && this.ch1 == '<');
        if (this.scripting) {
            boolean bl;
            boolean bl2;
            State state = this.saveState();
            boolean bl3 = bl2 = this.ch2 != '<';
            if (bl2) {
                this.skip(2);
            } else {
                this.skip(3);
            }
            char c = this.ch0;
            boolean bl4 = bl = c == '\"' || c == '\'';
            if (bl) {
                this.skip(1);
            }
            int n = this.position;
            int n2 = this.scanIdentifier();
            if (bl) {
                if (this.ch0 != c) {
                    this.error(Lexer.message("here.non.matching.delimiter", new String[0]), this.last, this.position, this.position);
                    this.restoreState(state);
                    return false;
                }
                this.skip(1);
            }
            if (n2 == 0) {
                this.restoreState(state);
                return false;
            }
            State state2 = this.saveState();
            int n3 = this.line;
            this.skipLine(false);
            ++n3;
            int n4 = this.position;
            state2.setLimit(this.position);
            State state3 = this.saveState();
            int n5 = this.position;
            while (!this.atEOF()) {
                this.skipWhitespace(false);
                if (this.hasHereMarker(n, n2)) break;
                this.skipLine(false);
                ++n3;
                n4 = this.position;
                n5 = this.position;
            }
            lineInfoReceiver.lineInfo(n3, n4);
            state3.setLimit(n5);
            if (state3.isEmpty() || this.atEOF()) {
                this.error(Lexer.message("here.missing.end.marker", this.source.getString(n, n2)), this.last, this.position, this.position);
                this.restoreState(state);
                return false;
            }
            if (bl2) {
                if (this.content.charAt(n5 - 1) == '\n') {
                    --n5;
                }
                if (this.content.charAt(n5 - 1) == '\r') {
                    --n5;
                }
                state3.setLimit(n5);
            }
            if (!bl && !state3.isEmpty()) {
                this.editString(TokenType.STRING, state3);
            } else {
                this.add(TokenType.STRING, state3.position, state3.limit);
            }
            Lexer lexer = new Lexer(this, state2);
            lexer.lexify();
            return true;
        }
        return false;
    }

    private void handleTemplate() {
        int n = this.position;
        while (!this.atEOF()) {
            if (this.ch0 == '`') {
                this.skip(1);
                this.add(this.templateExpression ? TokenType.TEMPLATE_TAIL : TokenType.TEMPLATE, n, this.position - 1);
                this.template = false;
                this.templateExpression = false;
                break;
            }
            if (this.ch0 == '$' && this.ch1 == '{') {
                this.skip(2);
                this.add(this.templateExpression ? TokenType.TEMPLATE_MIDDLE : TokenType.TEMPLATE_HEAD, n, this.position - 2);
                this.templateExpression = true;
                this.innerStates.push(new TemplateState(this.template, this.templateExpression, this.nextStateChange));
                this.template = false;
                this.templateExpression = false;
                this.nextStateChange = this.openExpressionBraces++;
                break;
            }
            if (this.ch0 == '\\') {
                this.skip(1);
                if (!this.isEscapeCharacter(this.ch0)) {
                    this.error(Lexer.message("invalid.escape.char", new String[0]), TokenType.TEMPLATE, this.position, this.limit);
                }
                if (this.isEOL(this.ch0)) {
                    this.skipEOL(false);
                    continue;
                }
            } else if (this.isEOL(this.ch0)) {
                this.skipEOL(false);
                continue;
            }
            this.skip(1);
        }
    }

    private void handleJsx() {
        block16: {
            block14: {
                block17: {
                    block15: {
                        if (!this.jsxTag) break block14;
                        if (!Character.isJavaIdentifierStart(this.ch0) && (this.ch0 != '\\' || this.ch1 != 'u')) break block15;
                        this.scanJsxIdentifier();
                        break block16;
                    }
                    if (!this.isStringDelimiter(this.ch0)) break block17;
                    this.scanJsxString();
                    break block16;
                }
                switch (this.ch0) {
                    case '.': 
                    case ':': 
                    case '=': {
                        this.add(TokenLookup.lookupOperator(this.ch0, this.ch1, this.ch2, this.ch3), this.position, this.position + 1);
                        this.skip(1);
                        break;
                    }
                    case '{': {
                        this.skip(1);
                        this.add(TokenType.LBRACE, this.position - 1);
                        this.innerStates.push(new JsxState(this.jsxTagCount, this.jsxTag, this.jsxClosing, this.nextStateChange));
                        this.jsxTagCount = 0;
                        this.jsxTag = false;
                        this.jsxClosing = false;
                        this.nextStateChange = this.openExpressionBraces++;
                        break;
                    }
                    case '<': {
                        this.skip(1);
                        this.add(TokenType.JSX_ELEM_START, this.position - 1);
                        ++this.jsxTagCount;
                        break;
                    }
                    case '/': {
                        this.skip(1);
                        this.add(TokenType.JSX_ELEM_CLOSE, this.position - 1);
                        this.jsxClosing = true;
                        break;
                    }
                    case '>': {
                        this.skip(1);
                        this.add(TokenType.JSX_ELEM_END, this.position - 1);
                        this.jsxTag = false;
                        if (this.jsxClosing) {
                            this.jsxClosing = false;
                            --this.jsxTagCount;
                            break;
                        }
                        break block16;
                    }
                    default: {
                        this.skip(1);
                        this.add(TokenType.ERROR, this.position - 1);
                        break;
                    }
                }
                break block16;
            }
            switch (this.ch0) {
                case '<': {
                    this.skip(1);
                    this.add(TokenType.JSX_ELEM_START, this.position - 1);
                    if (this.ch0 != '/') {
                        ++this.jsxTagCount;
                    }
                    this.jsxTag = true;
                    break;
                }
                case '{': {
                    this.skip(1);
                    this.add(TokenType.LBRACE, this.position - 1);
                    this.innerStates.push(new JsxState(this.jsxTagCount, this.jsxTag, this.jsxClosing, this.nextStateChange));
                    this.jsxTagCount = 0;
                    this.jsxTag = false;
                    this.jsxClosing = false;
                    this.nextStateChange = this.openExpressionBraces++;
                    break;
                }
                case '>': 
                case '}': {
                    this.skip(1);
                    this.add(TokenType.ERROR, this.position - 1);
                    break;
                }
                default: {
                    this.scanJsxText();
                }
            }
        }
    }

    public void lexify() {
        while (!this.stream.isFull() || this.nested) {
            if (this.atEOF()) {
                if (this.nested) break;
                if (this.template) {
                    this.error(Lexer.message("missing.close.quote", new String[0]), TokenType.TEMPLATE, this.position, this.limit);
                }
                this.add(TokenType.EOF, this.position);
                break;
            }
            if (this.template) {
                this.handleTemplate();
                continue;
            }
            this.skipWhitespace(true);
            if (this.atEOF()) {
                if (this.nested) break;
                this.add(TokenType.EOF, this.position);
                break;
            }
            if (this.ch0 == '/' && this.skipComments() || (this.scripting || this.shebang) && this.ch0 == '#' && this.skipComments()) continue;
            if (this.jsxTagCount > 0) {
                this.handleJsx();
                continue;
            }
            if (this.ch0 == '.' && Lexer.convertDigit(this.ch1, 10) != -1) {
                this.scanNumber();
                continue;
            }
            TokenType tokenType = TokenLookup.lookupOperator(this.ch0, this.ch1, this.ch2, this.ch3);
            if (tokenType != null) {
                if (!this.innerStates.isEmpty()) {
                    if (tokenType == TokenType.LBRACE) {
                        ++this.openExpressionBraces;
                    } else if (tokenType == TokenType.RBRACE && --this.openExpressionBraces == this.nextStateChange) {
                        InnerState innerState = this.innerStates.pop();
                        innerState.restore(this);
                        this.nextStateChange = innerState.nextStateChange();
                        this.skip(1);
                        if (!innerState.emitRightCurly()) break;
                        this.add(TokenType.RBRACE, this.position - 1);
                        break;
                    }
                }
                int n = tokenType.getLength();
                this.skip(n);
                this.add(tokenType, this.position - n);
                if (this.canStartLiteral(tokenType)) break;
                if (tokenType != TokenType.LBRACE || !this.pauseOnNextLeftBrace) continue;
                this.pauseOnNextLeftBrace = false;
                break;
            }
            if (Character.isJavaIdentifierStart(this.ch0) || this.ch0 == '\\' && this.ch1 == 'u') {
                this.scanIdentifierOrKeyword();
                continue;
            }
            if (this.isStringDelimiter(this.ch0)) {
                this.scanString(true);
                continue;
            }
            if (Character.isDigit(this.ch0)) {
                this.scanNumber();
                continue;
            }
            if (Lexer.isTemplateDelimiter(this.ch0) && this.es6) {
                this.template = true;
                this.skip(1);
                continue;
            }
            if (Lexer.isTemplateDelimiter(this.ch0) && this.scripting) {
                this.scanString(true);
                continue;
            }
            this.skip(1);
            this.add(TokenType.ERROR, this.position - 1);
        }
    }

    Object getValueOf(long l, boolean bl) {
        int n = Token.descPosition(l);
        int n2 = Token.descLength(l);
        switch (Token.descType(l)) {
            case DECIMAL: {
                return Lexer.valueOf(this.source.getString(n, n2), 10);
            }
            case HEXADECIMAL: {
                return Lexer.valueOf(this.source.getString(n + 2, n2 - 2), 16);
            }
            case OCTAL_LEGACY: {
                return Lexer.valueOf(this.source.getString(n, n2), 8);
            }
            case OCTAL: {
                return Lexer.valueOf(this.source.getString(n + 2, n2 - 2), 8);
            }
            case BINARY_NUMBER: {
                return Lexer.valueOf(this.source.getString(n + 2, n2 - 2), 2);
            }
            case FLOATING: {
                String string = this.source.getString(n, n2);
                double d = Double.valueOf(string);
                if (string.indexOf(46) != -1) {
                    return d;
                }
                if (JSType.isStrictlyRepresentableAsInt(d)) {
                    return (int)d;
                }
                if (JSType.isStrictlyRepresentableAsLong(d)) {
                    return (long)d;
                }
                return d;
            }
            case JSX_TEXT: 
            case JSX_STRING: 
            case STRING: {
                return this.source.getString(n, n2);
            }
            case ESCSTRING: {
                return this.valueOfString(n, n2, bl);
            }
            case IDENT: {
                return this.valueOfIdent(n, n2);
            }
            case REGEX: {
                return this.valueOfPattern(n, n2);
            }
            case TEMPLATE: 
            case TEMPLATE_HEAD: 
            case TEMPLATE_MIDDLE: 
            case TEMPLATE_TAIL: {
                return this.valueOfString(n, n2, true);
            }
            case XML: {
                return this.valueOfXML(n, n2);
            }
            case DIRECTIVE_COMMENT: {
                return this.source.getString(n, n2);
            }
            case JSX_IDENTIFIER: {
                return this.valueOfIdent(n, n2);
            }
        }
        return null;
    }

    public String valueOfRawString(long l) {
        int n = Token.descPosition(l);
        int n2 = Token.descLength(l);
        int n3 = this.position;
        int n4 = n + n2;
        this.reset(n);
        StringBuilder stringBuilder = new StringBuilder(n2);
        while (this.position < n4) {
            if (this.ch0 == '\r') {
                stringBuilder.append('\n');
                this.skip(this.ch1 == '\n' ? 2 : 1);
                continue;
            }
            stringBuilder.append(this.ch0);
            this.skip(1);
        }
        this.reset(n3);
        return stringBuilder.toString();
    }

    protected static String message(String string, String ... stringArray) {
        return ECMAErrors.getMessage("lexer.error." + string, stringArray);
    }

    protected void error(String string, TokenType tokenType, int n, int n2) throws ParserException {
        long l = Token.toDesc(tokenType, n, n2);
        int n3 = Token.descPosition(l);
        int n4 = this.source.getLine(n3);
        int n5 = this.source.getColumn(n3);
        String string2 = ErrorManager.format(string, this.source, n4, n5, l);
        throw new ParserException(JSErrorType.SyntaxError, string2, this.source, n4, n5, l);
    }

    public static class TemplateState
    implements InnerState {
        private final boolean template;
        private final boolean templateExpression;
        private final int expressionBraces;

        public TemplateState(boolean bl, boolean bl2, int n) {
            this.template = bl;
            this.templateExpression = bl2;
            this.expressionBraces = n;
        }

        @Override
        public void restore(Lexer lexer) {
            lexer.template = this.template;
            lexer.templateExpression = this.templateExpression;
        }

        @Override
        public boolean emitRightCurly() {
            return false;
        }

        @Override
        public int nextStateChange() {
            return this.expressionBraces;
        }
    }

    public static class JsxState
    implements InnerState {
        private final int jsxTagCount;
        private final boolean jsxTag;
        private final boolean jsxClosing;
        private final int expressionBraces;

        public JsxState(int n, boolean bl, boolean bl2, int n2) {
            this.jsxTagCount = n;
            this.jsxTag = bl;
            this.jsxClosing = bl2;
            this.expressionBraces = n2;
        }

        @Override
        public void restore(Lexer lexer) {
            lexer.jsxTagCount = this.jsxTagCount;
            lexer.jsxTag = this.jsxTag;
            lexer.jsxClosing = this.jsxClosing;
        }

        @Override
        public boolean emitRightCurly() {
            return true;
        }

        @Override
        public int nextStateChange() {
            return this.expressionBraces;
        }
    }

    public static interface InnerState {
        public void restore(Lexer var1);

        public boolean emitRightCurly();

        public int nextStateChange();
    }

    public static class XMLToken
    extends LexerToken {
        public XMLToken(String string) {
            super(string);
        }
    }

    public static class RegexToken
    extends LexerToken {
        private final String options;

        public RegexToken(String string, String string2) {
            super(string);
            this.options = string2;
        }

        public String getOptions() {
            return this.options;
        }

        public String toString() {
            return '/' + this.getExpression() + '/' + this.options;
        }
    }

    public static abstract class LexerToken {
        private final String expression;

        protected LexerToken(String string) {
            this.expression = string;
        }

        public String getExpression() {
            return this.expression;
        }
    }

    private static class EditStringLexer
    extends Lexer {
        final TokenType stringType;

        EditStringLexer(Lexer lexer, TokenType tokenType, State state) {
            super(lexer, state);
            this.stringType = tokenType;
        }

        @Override
        public void lexify() {
            int n = this.position;
            boolean bl = false;
            while (!this.atEOF()) {
                if (this.ch0 == '\\' && this.stringType == TokenType.ESCSTRING) {
                    this.skip(2);
                    continue;
                }
                if (this.ch0 == '$' && this.ch1 == '{') {
                    if (!bl || n != this.position) {
                        if (bl) {
                            this.add(TokenType.ADD, n, n + 1);
                        }
                        this.add(this.stringType, n, this.position);
                        bl = true;
                    }
                    this.skip(2);
                    Scanner.State state = this.saveState();
                    int n2 = 1;
                    while (!this.atEOF()) {
                        if (this.ch0 == '}') {
                            if (--n2 == 0) {
                                break;
                            }
                        } else if (this.ch0 == '{') {
                            ++n2;
                        }
                        this.skip(1);
                    }
                    if (n2 != 0) {
                        this.error(Lexer.message("edit.string.missing.brace", new String[0]), TokenType.LBRACE, ((State)state).position - 1, 1);
                    }
                    state.setLimit(this.position);
                    this.skip(1);
                    n = this.position;
                    this.add(TokenType.ADD, ((State)state).position, ((State)state).position + 1);
                    this.add(TokenType.LPAREN, ((State)state).position, ((State)state).position + 1);
                    Lexer lexer = new Lexer(this, (State)state);
                    lexer.lexify();
                    this.add(TokenType.RPAREN, this.position - 1, this.position);
                    continue;
                }
                this.skip(1);
            }
            if (n != this.limit) {
                if (bl) {
                    this.add(TokenType.ADD, n, 1);
                }
                this.add(this.stringType, n, this.limit);
            }
        }
    }

    protected static interface LineInfoReceiver {
        public void lineInfo(int var1, int var2);
    }

    static class State
    extends Scanner.State {
        public final int pendingLine;
        public final int linePosition;
        public final TokenType last;

        State(int n, int n2, int n3, int n4, int n5, TokenType tokenType) {
            super(n, n2, n3);
            this.pendingLine = n4;
            this.linePosition = n5;
            this.last = tokenType;
        }
    }
}

