/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.nbbuild.ParseProjectXml;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SortSuiteModules
extends Task {
    private boolean sortTests;
    private Path unsortedModules;
    private String sortedModulesProperty;

    public void setUnsortedModules(Path unsortedModules) {
        this.unsortedModules = unsortedModules;
    }

    public void setSortedModulesProperty(String sortedModulesProperty) {
        this.sortedModulesProperty = sortedModulesProperty;
    }

    public boolean isSortTests() {
        return this.sortTests;
    }

    public void setSortTests(boolean sortTests) {
        this.sortTests = sortTests;
    }

    public void execute() throws BuildException {
        List<String> cnbs;
        if (this.unsortedModules == null) {
            throw new BuildException("Must set unsortedModules");
        }
        if (this.sortedModulesProperty == null) {
            throw new BuildException("Must set sortedModulesProperty");
        }
        TreeMap<String, File> basedirsByCNB = new TreeMap<String, File>();
        HashMap buildDeps = new HashMap();
        for (String piece : this.unsortedModules.list()) {
            Element testDepsEl;
            Document doc;
            File d = new File(piece);
            File projectXml = new File(d, "nbproject" + File.separatorChar + "project.xml");
            if (!projectXml.isFile()) {
                throw new BuildException("Cannot open " + projectXml, this.getLocation());
            }
            try {
                doc = XMLUtil.parse(new InputSource(projectXml.toURI().toString()), false, true, null, null);
            }
            catch (IOException | SAXException e) {
                throw new BuildException("Error parsing " + projectXml + ": " + e, (Throwable)e, this.getLocation());
            }
            Element config = XMLUtil.findElement(doc.getDocumentElement(), "configuration", "http://www.netbeans.org/ns/project/1");
            if (config == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            Element data = ParseProjectXml.findNBMElement(config, "data");
            if (data == null) {
                this.log("Skipping " + projectXml + " as it does not look like a module project", 1);
                continue;
            }
            Element cnbEl = ParseProjectXml.findNBMElement(data, "code-name-base");
            if (cnbEl == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            String cnb = XMLUtil.findText(cnbEl);
            basedirsByCNB.put(cnb, d);
            LinkedList<String> deps = new LinkedList<String>();
            Element depsEl = ParseProjectXml.findNBMElement(data, "module-dependencies");
            if (depsEl == null) {
                throw new BuildException("Malformed project file " + projectXml, this.getLocation());
            }
            for (Element dep : XMLUtil.findSubElements(depsEl)) {
                if (ParseProjectXml.findNBMElement(dep, "build-prerequisite") == null && ParseProjectXml.findNBMElement(dep, "run-dependency") == null) continue;
                Element cnbEl2 = ParseProjectXml.findNBMElement(dep, "code-name-base");
                if (cnbEl2 == null) {
                    throw new BuildException("Malformed project file " + projectXml, this.getLocation());
                }
                String cnb2 = XMLUtil.findText(cnbEl2);
                deps.add(cnb2);
            }
            buildDeps.put(cnb, deps);
            if (!this.isSortTests() || (testDepsEl = ParseProjectXml.findNBMElement(data, "test-dependencies")) == null) continue;
            for (Element testDep : XMLUtil.findSubElements(testDepsEl)) {
                for (Element dep : XMLUtil.findSubElements(testDep)) {
                    if (ParseProjectXml.findNBMElement(dep, "test") == null) continue;
                    Element cnbEl2 = ParseProjectXml.findNBMElement(dep, "code-name-base");
                    if (cnbEl2 == null) {
                        throw new BuildException("No cobase found for test-dependency");
                    }
                    String cnb2 = XMLUtil.findText(cnbEl2);
                    deps.add(cnb2);
                }
            }
        }
        for (List deps : buildDeps.values()) {
            deps.retainAll(basedirsByCNB.keySet());
        }
        HashMap<String, ArrayList<String>> reversedDeps = new HashMap<String, ArrayList<String>>();
        for (Map.Entry entry : buildDeps.entrySet()) {
            for (String from : (List)entry.getValue()) {
                String to = (String)entry.getKey();
                ArrayList<String> tos = (ArrayList<String>)reversedDeps.get(from);
                if (tos == null) {
                    tos = new ArrayList<String>();
                    reversedDeps.put(from, tos);
                }
                tos.add(to);
            }
        }
        try {
            cnbs = SortSuiteModules.topologicalSort(basedirsByCNB.keySet(), reversedDeps);
        }
        catch (TopologicalSortException x) {
            throw new BuildException(x.getMessage(), (Throwable)x, this.getLocation());
        }
        StringBuilder path = new StringBuilder();
        for (String cnb : cnbs) {
            assert (basedirsByCNB.containsKey(cnb));
            if (path.length() > 0) {
                path.append(File.pathSeparatorChar);
            }
            path.append(((File)basedirsByCNB.get(cnb)).getAbsolutePath());
        }
        this.getProject().setNewProperty(this.sortedModulesProperty, path.toString());
    }

    private static <T> List<T> topologicalSort(Collection<T> c, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r = new ArrayList(Math.max(c.size(), 1));
        ArrayList<T> cRev = new ArrayList<T>(c);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List<T> cycle = SortSuiteModules.visit(it.next(), edges, finished, r);
            if (cycle == null) continue;
            throw new TopologicalSortException("Cycle detected: " + cycle.toString());
        }
        Collections.reverse(r);
        if (r.size() != c.size()) {
            r.retainAll(c);
        }
        return r;
    }

    private static <T> List<T> visit(T node, Map<? super T, ? extends Collection<? extends T>> edges, Map<T, Boolean> finished, List<T> r) {
        Boolean b = finished.get(node);
        if (b != null) {
            if (b.booleanValue()) {
                return null;
            }
            ArrayList<T> cycle = new ArrayList<T>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection<T> e = edges.get(node);
        if (e != null) {
            finished.put(node, Boolean.FALSE);
            Iterator<T> it = e.iterator();
            while (it.hasNext()) {
                List<T> cycle = SortSuiteModules.visit(it.next(), edges, finished, r);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r.add(node);
        return null;
    }

    private static final class TopologicalSortException
    extends Exception {
        public TopologicalSortException() {
        }

        public TopologicalSortException(String message) {
            super(message);
        }

        public TopologicalSortException(String message, Throwable cause) {
            super(message, cause);
        }

        public TopologicalSortException(Throwable cause) {
            super(cause);
        }
    }
}

