/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.net.URL;
import javax.swing.JTable;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;

public class HTMLLabelTableCellRenderer
extends EnhancedTableCellRenderer {
    protected HTMLLabel label;

    public HTMLLabelTableCellRenderer() {
        this(10);
    }

    public HTMLLabelTableCellRenderer(int horizontalAlignment) {
        this(horizontalAlignment, false);
    }

    public HTMLLabelTableCellRenderer(int horizontalAlignment, final boolean persistent) {
        this.setHorizontalAlignment(horizontalAlignment);
        this.label = new HTMLLabel(){

            @Override
            protected void showURL(URL url) {
                HTMLLabelTableCellRenderer.this.handleLink(url);
            }

            @Override
            public void setCursor(Cursor cursor) {
                if (persistent) {
                    super.setCursor(cursor);
                } else {
                    HTMLLabelTableCellRenderer.this.handleCursor(cursor);
                }
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, horizontalAlignment == 10 || horizontalAlignment == 2 ? "West" : "East");
    }

    @Override
    public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return new HTMLLabelTableCellRenderer(this.getHorizontalAlignment(), true).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void setRowBackground(Color c) {
        super.setRowBackground(c);
        this.label.setBackground(c);
    }

    @Override
    protected void setValue(JTable table, Object value, int row, int column) {
        if (table != null) {
            this.setFont(table.getFont());
        }
        this.label.setText(value == null ? "" : value.toString());
    }

    protected void handleCursor(Cursor cursor) {
    }

    protected void handleLink(URL url) {
    }
}

