/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.admin;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.payara.tooling.admin.Command;
import org.netbeans.modules.payara.tooling.admin.CommandException;
import org.netbeans.modules.payara.tooling.admin.Result;
import org.netbeans.modules.payara.tooling.admin.ResultString;
import org.netbeans.modules.payara.tooling.admin.Runner;
import org.netbeans.modules.payara.tooling.admin.response.ResponseContentType;
import org.netbeans.modules.payara.tooling.admin.response.ResponseParserFactory;
import org.netbeans.modules.payara.tooling.admin.response.RestActionReport;
import org.netbeans.modules.payara.tooling.admin.response.RestResponseParser;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.ServerUtils;

public class RunnerRest
extends Runner {
    RestResponseParser parser = ResponseParserFactory.getRestParser(this.getResponseType());
    RestActionReport report;
    protected ResultString result;

    public RunnerRest(PayaraServer server, Command command) {
        this(server, command, null);
    }

    public RunnerRest(PayaraServer server, Command command, String query) {
        this(server, command, "/command/", query);
    }

    public RunnerRest(PayaraServer server, Command command, String path, String query) {
        super(server, command, path, query);
        this.silentFailureAllowed = false;
    }

    protected void appendProperties(StringBuilder sb, Map<String, String> properties, String paramName, boolean separator) {
        if (null != properties && properties.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = properties.entrySet();
            boolean first = true;
            if (separator) {
                sb.append('&');
            }
            sb.append(paramName).append('=');
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (first) {
                    first = false;
                } else {
                    sb.append(':');
                }
                sb.append(key);
                sb.append('=');
                if (val == null) continue;
                sb.append(val);
            }
        }
    }

    protected void appendIfNotEmpty(StringBuilder sb, String paramName, String paramValue) {
        if (paramValue != null && !paramValue.isEmpty()) {
            sb.append(paramName);
            sb.append('=');
            sb.append(paramValue);
        }
    }

    @Override
    protected Result createResult() {
        this.result = new ResultString();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return true;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        URI uri;
        String protocol = "http";
        try {
            uri = new URI(protocol, null, this.server.getHost(), this.server.getAdminPort(), this.path + this.command.getCommand(), this.query, null);
        }
        catch (URISyntaxException use) {
            throw new CommandException("Cannot build HTTP command URL", use);
        }
        return uri.toASCIIString();
    }

    @Override
    protected String getRequestMethod() {
        return "POST";
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        this.report = this.parser.parse(in);
        return this.isSuccess();
    }

    @Override
    protected boolean processResponse() {
        this.result.value = this.report.getMessage();
        return this.isSuccess();
    }

    protected boolean isSuccess() {
        return this.report.isSuccess();
    }

    @Override
    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        super.prepareHttpConnection(conn);
        String adminUser = this.server.getAdminUser();
        String adminPassword = this.server.getAdminPassword();
        if (adminUser != null && adminUser.length() > 0) {
            adminPassword = adminPassword != null && adminPassword.length() > 0 ? adminPassword : "";
            String authCredentials = ServerUtils.basicAuthCredentials(adminUser, adminPassword);
            conn.setRequestProperty("Authorization", "Basic " + authCredentials);
        }
        conn.setRequestProperty("Accept", this.getResponseType().toString());
        conn.addRequestProperty("X-Requested-By", "Payara REST HTML interface");
    }

    protected ResponseContentType getResponseType() {
        return ResponseContentType.APPLICATION_JSON;
    }
}

