/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.algorithms;

import com.sun.enterprise.web.connector.grizzly.AsyncReadTask;
import com.sun.enterprise.web.connector.grizzly.ByteBufferFactory;
import com.sun.enterprise.web.connector.grizzly.DefaultReadTask;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class StreamAlgorithmBase
implements StreamAlgorithm {
    protected static boolean embeddedInGlassFish = false;
    private int port = 8080;
    protected int contentLength = -1;
    protected int curLimit = -1;
    protected int curPosition = -1;
    protected int headerLength = -1;
    protected int lastStatePosition = -1;
    protected int state = 0;
    protected ByteBuffer primaryByteBuffer = null;
    protected boolean useByteBufferView = false;
    protected boolean useDirectByteBuffer;
    protected SocketChannel socketChannel;
    protected Handler handler = new DummyHandler();

    public abstract boolean parse(ByteBuffer var1);

    public int contentLength() {
        return this.contentLength;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public ByteBuffer preParse(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == byteBuffer.capacity()) {
            int bufferSize = this.contentLength > 0 ? this.contentLength + this.headerLength + 5 : byteBuffer.capacity() * 2;
            byteBuffer = this.swapBuffer(byteBuffer, bufferSize);
        }
        return byteBuffer;
    }

    public ByteBuffer postParse(ByteBuffer byteBuffer) {
        if (this.primaryByteBuffer != null) {
            this.primaryByteBuffer.clear();
            byteBuffer = this.primaryByteBuffer;
            this.primaryByteBuffer = null;
        }
        return byteBuffer;
    }

    public void recycle() {
        this.contentLength = -1;
        this.lastStatePosition = -1;
        this.headerLength = -1;
        this.curLimit = -1;
        this.curPosition = -1;
        this.state = 0;
    }

    public ByteBuffer allocate(boolean useDirectByteBuffer, boolean useByteBufferView, int size) {
        ByteBuffer byteBuffer = useByteBufferView ? ByteBufferFactory.allocateView(size, useDirectByteBuffer) : (useDirectByteBuffer ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size));
        return byteBuffer;
    }

    private ByteBuffer swapBuffer(ByteBuffer byteBuffer, int size) {
        ByteBuffer tmp = this.allocate(this.useDirectByteBuffer, this.useByteBufferView, size);
        byteBuffer.flip();
        tmp.put(byteBuffer);
        if (this.primaryByteBuffer == null) {
            this.primaryByteBuffer = byteBuffer;
        }
        byteBuffer = tmp;
        return byteBuffer;
    }

    public ByteBuffer rollbackParseState(ByteBuffer byteBuffer) {
        if (this.curLimit != -1 && this.curPosition != -1) {
            byteBuffer.limit(this.curLimit);
            byteBuffer.position(this.curPosition);
            this.contentLength = -1;
            this.headerLength = -1;
        }
        return byteBuffer;
    }

    protected String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump) + "\n----------------------------" + dd + "\ncontentLength: " + this.contentLength + "\nheaderLength: " + this.headerLength;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        if (socketChannel != null) {
            this.handler.attachChannel(socketChannel);
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public Class getReadTask(SelectorThread selectorThread) {
        if (selectorThread.getMaxReadWorkerThreads() <= 0 && !selectorThread.getEnableAsyncExecution()) {
            return DefaultReadTask.class;
        }
        return AsyncReadTask.class;
    }

    static {
        try {
            embeddedInGlassFish = Class.forName("org.apache.coyote.tomcat5.Constants") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class DummyHandler
    implements Handler {
        public int handle(Object e, int handlerCode) throws IOException {
            return 0;
        }

        public void attachChannel(SocketChannel sc) {
        }
    }
}

