/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

class RunProcess
implements Callable<Process> {
    private static final Logger LOG = Logger.getLogger(RunProcess.class.getName());
    private final String dirPath;
    private final List<String> commandsList;
    private InputStream is;
    private Process p;

    public RunProcess(String command, String dirPath) {
        this.dirPath = dirPath;
        this.commandsList = new ArrayList<String>();
        this.commandsList.add(command);
        this.setupProcess();
    }

    public RunProcess(String command) {
        this.commandsList = new ArrayList<String>();
        this.commandsList.add(command);
        this.dirPath = System.getProperty("user.home");
        this.setupProcess();
    }

    public RunProcess(List<String> commandsList) {
        this.commandsList = commandsList;
        this.dirPath = System.getProperty("user.home");
        this.setupProcess();
    }

    public void setupProcess() {
        try {
            ProcessBuilder runFileProcessBuilder = new ProcessBuilder(this.commandsList);
            runFileProcessBuilder.directory(new File(this.dirPath));
            runFileProcessBuilder.redirectErrorStream(true);
            this.p = runFileProcessBuilder.start();
            this.is = this.p.getInputStream();
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Could not get InputStream of Run Process");
        }
    }

    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public Process call() throws Exception {
        return this.p;
    }
}

