/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.windows8;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.AffineTransform;
import javax.swing.border.Border;

final class DPISafeBorder
implements Border {
    private final Insets insets;
    private final Color color;

    public static Border matte(int top, int left, int bottom, int right, Color color) {
        return new DPISafeBorder(new Insets(top, left, bottom, right), color);
    }

    private DPISafeBorder(Insets insets, Color color) {
        if (insets == null) {
            throw new NullPointerException();
        }
        if (color == null) {
            throw new NullPointerException();
        }
        this.insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.color = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g0, int x, int y, int width, int height) {
        int deviceHeight;
        int deviceWidth;
        double scale;
        Graphics2D g = (Graphics2D)g0;
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g.getTransform();
        g.translate(x, y);
        AffineTransform tx = g.getTransform();
        int txType = tx.getType();
        if (txType == 2 || txType == 3) {
            scale = tx.getScaleX();
            int deviceX = (int)Math.ceil(tx.getTranslateX());
            int deviceY = (int)Math.ceil(tx.getTranslateY());
            int deviceXend = (int)(tx.getTranslateX() + (double)width * scale);
            int deviceYend = (int)(tx.getTranslateY() + (double)height * scale);
            deviceWidth = deviceXend - deviceX;
            deviceHeight = deviceYend - deviceY;
            g.setTransform(new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, deviceX, deviceY));
        } else {
            scale = 1.0;
            deviceWidth = width;
            deviceHeight = height;
        }
        int deviceLeft = this.deviceBorderWidth(scale, this.insets.left);
        int deviceRight = this.deviceBorderWidth(scale, this.insets.right);
        int deviceTop = this.deviceBorderWidth(scale, this.insets.top);
        int deviceBottom = this.deviceBorderWidth(scale, this.insets.bottom);
        g.setColor(this.color);
        g.fillRect(0, 0, deviceWidth - deviceRight, deviceTop);
        g.fillRect(0, deviceTop, deviceLeft, deviceHeight - deviceTop);
        g.fillRect(deviceLeft, deviceHeight - deviceBottom, deviceWidth - deviceLeft, deviceBottom);
        g.fillRect(deviceWidth - deviceRight, 0, deviceRight, deviceHeight - deviceBottom);
        g.setTransform(oldTransform);
        g.setColor(oldColor);
    }

    private int deviceBorderWidth(double scale, int logical) {
        if (logical <= 0) {
            return 0;
        }
        return Math.max(1, (int)(scale * (double)logical));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

