/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;

public abstract class AbstractTableOfContentsBlock
extends Block {
    private String style = "none";
    private String cssClass = "toc";
    protected int maxLevel = Integer.MAX_VALUE;

    protected void emitToc(OutlineItem item) {
        Attributes nullAttributes = new Attributes();
        this.emitToc(item, 0, nullAttributes);
    }

    private void emitToc(OutlineItem item, int level, Attributes nullAttributes) {
        if (item.getChildren().isEmpty()) {
            return;
        }
        if (item.getLevel() + 1 > this.maxLevel) {
            return;
        }
        Attributes listAttributes = new Attributes(null, level == 0 ? this.cssClass : null, "list-style: " + this.style + ";", null);
        this.builder.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, listAttributes);
        for (OutlineItem child : item.getChildren()) {
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, nullAttributes);
            this.builder.link(String.valueOf('#') + child.getId(), child.getLabel());
            this.emitToc(child, level + 1, nullAttributes);
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public void setCssClass(String cssClass) {
        this.cssClass = cssClass;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }
}

