/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.struts.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.struts.ui.StrutsConfigurationPanel;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class StrutsConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private StrutsConfigurationPanel panel;
    private final boolean enableComponents;
    private JCheckBox jCheckBoxTLD;
    private JCheckBox jCheckBoxWAR;
    private JComboBox jComboBoxURLPattern;
    private JLabel jLabelAppResource;
    private JLabel jLabelServletName;
    private JLabel jLabelURLPattern;
    private JTextField jTextFieldAppResource;
    private JTextField jTextFieldServletName;
    private static final char[] INVALID_PATTERN_CHARS = new char[]{'<', '\\', '\"', '%', '&', '+', '?', ';'};
    private static final char[] INVALID_RESOURCE_CHARS = new char[]{'<', '>', '*', '\\', ':', '\"', '/', '%', '|', '?'};

    public StrutsConfigurationPanelVisual(StrutsConfigurationPanel panel, boolean customizer) {
        this.panel = panel;
        this.initComponents();
        this.jTextFieldAppResource.getDocument().addDocumentListener(this);
        this.jCheckBoxWAR.setVisible(false);
        if (customizer) {
            this.jCheckBoxTLD.setVisible(false);
            this.enableComponents = false;
        } else {
            this.jCheckBoxTLD.setVisible(true);
            this.enableComponents = true;
        }
        this.enableComponents(this.enableComponents);
        ((JTextComponent)this.jComboBoxURLPattern.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.jLabelServletName = new JLabel();
        this.jTextFieldServletName = new JTextField();
        this.jLabelURLPattern = new JLabel();
        this.jComboBoxURLPattern = new JComboBox();
        this.jLabelAppResource = new JLabel();
        this.jTextFieldAppResource = new JTextField();
        this.jCheckBoxTLD = new JCheckBox();
        this.jCheckBoxWAR = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabelServletName.setDisplayedMnemonic(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MNE_ConfigPanel_ActionServletName_Mnemonic").charAt(0));
        this.jLabelServletName.setLabelFor(this.jTextFieldServletName);
        this.jLabelServletName.setText(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"LBL_ConfigPanel_ActionServletName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        this.add((Component)this.jLabelServletName, gridBagConstraints);
        this.jTextFieldServletName.setEditable(false);
        this.jTextFieldServletName.setText("action");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jTextFieldServletName, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/web/struts/ui/Bundle");
        this.jTextFieldServletName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_jTextFieldServletName"));
        this.jLabelURLPattern.setDisplayedMnemonic(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MNE_ConfigPanel_URLPattern_Mnemonic").charAt(0));
        this.jLabelURLPattern.setLabelFor(this.jComboBoxURLPattern);
        this.jLabelURLPattern.setText(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"LBL_ConfigPanel_URLPattern"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jLabelURLPattern, gridBagConstraints);
        this.jComboBoxURLPattern.setEditable(true);
        this.jComboBoxURLPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"*.do", "/do/*"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jComboBoxURLPattern, gridBagConstraints);
        this.jComboBoxURLPattern.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_jComboBoxURLPattern"));
        this.jLabelAppResource.setDisplayedMnemonic(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MNE_ConfigPanel_ApplicationResource_Mnemonic").charAt(0));
        this.jLabelAppResource.setLabelFor(this.jTextFieldAppResource);
        this.jLabelAppResource.setText(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"LBL_ConfigPanel_ApplicationResource"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 12, 12);
        this.add((Component)this.jLabelAppResource, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jTextFieldAppResource, gridBagConstraints);
        this.jTextFieldAppResource.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_jTextFieldAppResource"));
        this.jCheckBoxTLD.setMnemonic(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MNE_ConfigPanel_InstallStrutsTLDs_Mnemonic").charAt(0));
        this.jCheckBoxTLD.setText(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"LBL_ConfigPanel_InstallStrutsTLDs"));
        this.jCheckBoxTLD.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxTLD.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.jCheckBoxTLD, gridBagConstraints);
        this.jCheckBoxTLD.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_jCheckBoxTLD"));
        this.jCheckBoxWAR.setMnemonic(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MNE_ConfigPanel_PackageStrutsJars_Mnemonic").charAt(0));
        this.jCheckBoxWAR.setSelected(true);
        this.jCheckBoxWAR.setText(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"LBL_ConfigPanel_PackageStrutsJars"));
        this.jCheckBoxWAR.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxWAR.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jCheckBoxWAR, gridBagConstraints);
        this.jCheckBoxWAR.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"ACSD_jCheckBoxWAR"));
    }

    boolean valid() {
        if (!this.enableComponents) {
            return true;
        }
        ExtenderController controller = this.panel.getController();
        String urlPattern = (String)this.jComboBoxURLPattern.getEditor().getItem();
        if (urlPattern == null || urlPattern.trim().length() == 0) {
            controller.setErrorMessage(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(urlPattern)) {
            controller.setErrorMessage(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        String appResource = this.getAppResource();
        if (appResource == null || appResource.trim().length() == 0) {
            controller.setErrorMessage(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MSG_ApplicationResourceIsEmpty"));
            return false;
        }
        if (!this.isResourceValid(appResource)) {
            controller.setErrorMessage(NbBundle.getMessage(StrutsConfigurationPanelVisual.class, (String)"MSG_ApplicationResourceNotValid"));
            return false;
        }
        controller.setErrorMessage(null);
        return true;
    }

    private boolean isPatternValid(String pattern) {
        String p;
        for (char c : INVALID_PATTERN_CHARS) {
            if (pattern.indexOf(c) == -1) continue;
            return false;
        }
        if (pattern.startsWith("*.") && (p = pattern.substring(2)).indexOf(46) == -1 && p.indexOf(42) == -1 && p.indexOf(47) == -1 && !p.trim().equals("")) {
            return true;
        }
        return pattern.length() > 3 && pattern.endsWith("/*") && pattern.startsWith("/");
    }

    private boolean isResourceValid(String resource) {
        for (char c : INVALID_RESOURCE_CHARS) {
            if (resource.indexOf(c) == -1) continue;
            return false;
        }
        return true;
    }

    void enableComponents(boolean enable) {
        this.jComboBoxURLPattern.setEnabled(enable);
        this.jTextFieldAppResource.setEnabled(enable);
        this.jTextFieldServletName.setEnabled(enable);
        this.jCheckBoxTLD.setEnabled(enable);
        this.jCheckBoxWAR.setEnabled(enable);
        this.jLabelAppResource.setEnabled(enable);
        this.jLabelServletName.setEnabled(enable);
        this.jLabelURLPattern.setEnabled(enable);
    }

    public String getURLPattern() {
        return (String)this.jComboBoxURLPattern.getSelectedItem();
    }

    public void setURLPattern(String pattern) {
        this.jComboBoxURLPattern.setSelectedItem(pattern);
    }

    public String getServletName() {
        return this.jTextFieldServletName.getText();
    }

    public void setServletName(String name) {
        this.jTextFieldServletName.setText(name);
    }

    public String getAppResource() {
        return this.jTextFieldAppResource.getText();
    }

    public void setAppResource(String resource) {
        this.jTextFieldAppResource.setText(resource);
    }

    public boolean addTLDs() {
        return this.jCheckBoxTLD.isSelected();
    }

    public boolean packageWars() {
        return this.jCheckBoxWAR.isSelected();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(StrutsConfigurationPanelVisual.class);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.panel.fireChangeEvent();
    }
}

