/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.RepeatedPatternRuleTransformer;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RuleIdValidator {
    private final Language lang;

    public RuleIdValidator(Language lang) {
        this.lang = lang;
    }

    public void validateUniqueness() {
        System.out.println("Check rule id uniqueness for " + this.lang + "...");
        List fileNames = this.lang.getRuleFileNames();
        HashMap<String, String> idsToFile = new HashMap<String, String>();
        List allRules = new JLanguageTool(this.lang).getAllRules();
        System.out.println("Loaded " + allRules.size() + " rules...");
        for (Rule rule : allRules) {
            if (rule instanceof AbstractPatternRule || rule instanceof RepeatedPatternRuleTransformer.RepeatedPatternRule) continue;
            idsToFile.put(rule.getId(), "Java (" + rule.getClass().getName() + ")");
        }
        for (String fileName : fileNames) {
            try {
                InputStream is = JLanguageTool.getDataBroker().getAsStream(fileName);
                Throwable throwable = null;
                try {
                    if (is == null) {
                        System.out.println("Skipping " + fileName + " - not found");
                        continue;
                    }
                    XmlIdHandler handler = new XmlIdHandler();
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    saxParser.parse(is, (DefaultHandler)handler);
                    for (String id : handler.ids) {
                        if (idsToFile.containsKey(id)) {
                            throw new RuntimeException("id '" + id + "' found at least twice. Found in " + fileName + " and " + (String)idsToFile.get(id));
                        }
                        idsToFile.put(id, fileName);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class XmlIdHandler
    extends DefaultHandler {
        private final Set<String> ids = new HashSet<String>();
        private String idPrefix = "";

        private XmlIdHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
            String id;
            if (qName.equals("rules") && attrs.getValue("idprefix") != null) {
                this.idPrefix = attrs.getValue("idprefix");
            }
            if ((qName.equals("rule") || qName.equals("rulegroup")) && (id = attrs.getValue("id")) != null) {
                this.ids.add(this.idPrefix + id);
            }
        }

        @Override
        public void endElement(String namespaceURI, String lName, String qName) {
            if (qName.equals("rules")) {
                this.idPrefix = "";
            }
        }
    }
}

