/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

public class Probability<T> {
    protected T label;
    protected double probability = 1.0;

    public Probability(T label) {
        this.label = label;
    }

    public void set(double probability) {
        this.probability = probability;
    }

    public void set(Probability probability) {
        this.probability = probability.get();
    }

    public void setIfLarger(double probability) {
        if (this.probability < probability) {
            this.probability = probability;
        }
    }

    public void setIfLarger(Probability probability) {
        if (this.probability < probability.get()) {
            this.probability = probability.get();
        }
    }

    public boolean isLarger(Probability probability) {
        return this.probability < probability.get();
    }

    public void setLog(double probability) {
        this.set(StrictMath.exp(probability));
    }

    public void addIn(double probability) {
        this.set(this.probability * probability);
    }

    public Double get() {
        return this.probability;
    }

    public Double getLog() {
        return StrictMath.log(this.get());
    }

    public T getLabel() {
        return this.label;
    }

    public String toString() {
        return this.label == null ? "" + this.probability : this.label + ":" + this.probability;
    }
}

