/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SourceProducer;
import reactor.util.context.Context;

final class MonoDeferWithContext<T>
extends Mono<T>
implements SourceProducer<T> {
    final Function<Context, ? extends Mono<? extends T>> supplier;

    MonoDeferWithContext(Function<Context, ? extends Mono<? extends T>> supplier) {
        this.supplier = Objects.requireNonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Mono<T> p;
        Context ctx = actual.currentContext();
        try {
            p = Objects.requireNonNull(this.supplier.apply(ctx), "The Mono returned by the supplier is null");
        }
        catch (Throwable e) {
            Operators.error(actual, Operators.onOperatorError(e, ctx));
            return;
        }
        p.subscribe(actual);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        return null;
    }
}

