/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.CompositeArgument;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ScanArgs
implements CompositeArgument {
    private Long count;
    private byte[] match;

    public ScanArgs match(String match) {
        return this.match(match, StandardCharsets.UTF_8);
    }

    public ScanArgs match(String match, Charset charset) {
        LettuceAssert.notNull((Object)match, "Match must not be null");
        LettuceAssert.notNull((Object)charset, "Charset must not be null");
        return this.match(match.getBytes(charset));
    }

    public ScanArgs match(byte[] match) {
        LettuceAssert.notNull((Object)match, "Match must not be null");
        this.match = new byte[match.length];
        System.arraycopy(match, 0, this.match, 0, match.length);
        return this;
    }

    public ScanArgs limit(long count) {
        this.count = count;
        return this;
    }

    @Override
    public <K, V> void build(CommandArgs<K, V> args) {
        if (this.match != null) {
            args.add(CommandKeyword.MATCH).add(this.match);
        }
        if (this.count != null) {
            args.add(CommandKeyword.COUNT).add(this.count);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static ScanArgs limit(long count) {
            return new ScanArgs().limit(count);
        }

        public static ScanArgs matches(String matches) {
            return new ScanArgs().match(matches);
        }

        public static ScanArgs matches(byte[] matches) {
            return new ScanArgs().match(matches);
        }
    }
}

