/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.util.ArrayList;
import java.util.Iterator;
import ml.dmlc.xgboost4j.LabeledPoint;

class DataBatch {
    final long[] rowOffset;
    final float[] weight;
    final float[] label;
    final int[] featureIndex;
    final float[] featureValue;

    DataBatch(long[] rowOffset, float[] weight, float[] label, int[] featureIndex, float[] featureValue) {
        this.rowOffset = rowOffset;
        this.weight = weight;
        this.label = label;
        this.featureIndex = featureIndex;
        this.featureValue = featureValue;
    }

    static class BatchIterator
    implements Iterator<DataBatch> {
        private final Iterator<LabeledPoint> base;
        private final int batchSize;

        BatchIterator(Iterator<LabeledPoint> base, int batchSize) {
            this.base = base;
            this.batchSize = batchSize;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public DataBatch next() {
            int numRows = 0;
            int numElem = 0;
            ArrayList<LabeledPoint> batch = new ArrayList<LabeledPoint>(this.batchSize);
            while (this.base.hasNext() && batch.size() < this.batchSize) {
                LabeledPoint labeledPoint = this.base.next();
                batch.add(labeledPoint);
                numElem += labeledPoint.values().length;
                ++numRows;
            }
            long[] rowOffset = new long[numRows + 1];
            float[] label = new float[numRows];
            int[] featureIndex = new int[numElem];
            float[] featureValue = new float[numElem];
            float[] weight = new float[numRows];
            int offset = 0;
            for (int i = 0; i < batch.size(); ++i) {
                LabeledPoint labeledPoint = (LabeledPoint)batch.get(i);
                rowOffset[i] = offset;
                label[i] = labeledPoint.label();
                weight[i] = labeledPoint.weight();
                if (labeledPoint.indices() != null) {
                    System.arraycopy(labeledPoint.indices(), 0, featureIndex, offset, labeledPoint.indices().length);
                } else {
                    for (int j = 0; j < labeledPoint.values().length; ++j) {
                        featureIndex[offset + j] = j;
                    }
                }
                System.arraycopy(labeledPoint.values(), 0, featureValue, offset, labeledPoint.values().length);
                offset += labeledPoint.values().length;
            }
            rowOffset[batch.size()] = offset;
            return new DataBatch(rowOffset, weight, label, featureIndex, featureValue);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("DataBatch.BatchIterator.remove");
        }
    }
}

