/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.collections;

import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.util.MurmurHash;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class LongToIntHashMap {
    private long[] keys;
    private int[] values;
    private int size = 0;
    private static final int EMPTY_VAL = -1;
    private double maxLoadFactor = 0.5;
    private boolean sorted = false;

    public LongToIntHashMap() {
        this(5);
    }

    public void setLoadFactor(double loadFactor) {
        this.maxLoadFactor = loadFactor;
        this.ensureCapacity(this.values.length);
    }

    public LongToIntHashMap(int initCapacity_) {
        int initCapacity = this.toSize(initCapacity_);
        this.keys = new long[initCapacity];
        this.values = new int[initCapacity];
        Arrays.fill(this.values, -1);
    }

    public String toString() {
        String s = "[";
        for (Entry entry : this.primitiveEntries()) {
            s = s + (s.length() == 1 ? "" : " ");
            s = s + "(" + entry.key + "," + entry.value + ")";
        }
        s = s + "]";
        return s;
    }

    public void toSorted() {
        this.sorted = true;
        long[] newKeys = new long[this.size];
        int[] newValues = new int[this.size];
        ArrayList<Entry> sortedEntries = new ArrayList<Entry>(this.size);
        for (Map.Entry<Long, Integer> e : this.entries()) {
            sortedEntries.add((Entry)e);
        }
        Collections.sort(sortedEntries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return Double.compare(o1.key, o2.key);
            }
        });
        int k = 0;
        for (Entry e : sortedEntries) {
            newKeys[k] = e.getKey();
            newValues[k] = e.getValue();
            ++k;
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private int toSize(int initCapacity_) {
        return Math.max(5, (int)((double)initCapacity_ / this.maxLoadFactor) + 1);
    }

    public void put(Long k, int v) {
        this.checkNotImmutable();
        if ((double)this.size / (double)this.keys.length > this.maxLoadFactor) {
            this.rehash();
        }
        this.putHelp(k, v, this.keys, this.values);
    }

    public void incrementCount(long k, int d) {
        this.checkNotImmutable();
        if (d == 0) {
            return;
        }
        int pos = this.find(k, false);
        if (pos == -1 || pos == -1) {
            this.put(k, d);
        } else {
            int n = pos;
            this.values[n] = this.values[n] + d;
        }
    }

    private void checkNotImmutable() {
        if (this.keys == null) {
            throw new RuntimeException("Cannot change wrapped IntCounter");
        }
        if (this.sorted) {
            throw new RuntimeException("Cannot change sorted IntCounter");
        }
    }

    private void rehash() {
        int length = this.keys.length * 2 + 1;
        this.rehash(length);
    }

    private void rehash(int length) {
        this.checkNotImmutable();
        long[] newKeys = new long[length];
        int[] newValues = new int[length];
        Arrays.fill(newValues, -1);
        this.size = 0;
        for (int i = 0; i < this.keys.length; ++i) {
            long curr = this.keys[i];
            int val = this.values[i];
            if (val == -1) continue;
            this.putHelp(curr, val, newKeys, newValues);
        }
        this.keys = newKeys;
        this.values = newValues;
    }

    private boolean putHelp(long k, int v, long[] keyArray, int[] valueArray) {
        this.checkNotImmutable();
        assert (v >= 0);
        int pos = this.find(k, true, keyArray, valueArray);
        boolean wasEmpty = valueArray[pos] == -1;
        valueArray[pos] = v;
        if (wasEmpty) {
            ++this.size;
            keyArray[pos] = k;
            return true;
        }
        return false;
    }

    private static int getInitialPos(long k, int length) {
        if (length < 0) {
            return (int)k;
        }
        long hash = MurmurHash.hashOneLong(k, 31);
        if (hash < 0L) {
            hash = -hash;
        }
        int pos = (int)(hash % (long)length);
        return pos;
    }

    public int get(long k, int def) {
        int pos = this.find(k, false);
        if (pos == -1) {
            return def;
        }
        return this.values[pos];
    }

    private int find(long k, boolean returnLastEmpty) {
        return this.find(k, returnLastEmpty, this.keys, this.values);
    }

    private int find(long k, boolean returnLastEmpty, long[] keyArray, int[] valueArray) {
        if (keyArray == null) {
            return (int)(k < (long)valueArray.length ? k : -1L);
        }
        if (this.sorted) {
            int pos = Arrays.binarySearch(keyArray, k);
            return pos < 0 ? -1 : pos;
        }
        int[] localValues = valueArray;
        int length = localValues.length;
        int pos = LongToIntHashMap.getInitialPos(k, localValues.length);
        int currVal = localValues[pos];
        long curr = keyArray[pos];
        while (currVal != -1 && curr != k) {
            if (++pos == length) {
                pos = 0;
            }
            currVal = localValues[pos];
            curr = keyArray[pos];
        }
        return returnLastEmpty ? pos : (currVal == -1 ? -1 : pos);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Iterable<Map.Entry<Long, Integer>> entries() {
        return Iterators.able(new EntryIterator());
    }

    public void ensureCapacity(int capacity) {
        this.checkNotImmutable();
        int newSize = this.toSize(capacity);
        if (newSize > this.keys.length) {
            this.rehash(newSize);
        }
    }

    public int size() {
        return this.size;
    }

    public Iterable<Entry> primitiveEntries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return new PrimitiveEntryIterator();
            }
        };
    }

    public Iterable<Long> keySet() {
        return Iterators.able(new KeyIterator());
    }

    public void clear() {
        Arrays.fill(this.values, -1);
        this.size = 0;
    }

    public List<Entry> getObjectsSortedByValue(boolean descending) {
        ArrayList<Entry> l = new ArrayList<Entry>();
        for (Entry entry : this.primitiveEntries()) {
            l.add(entry);
        }
        Collections.sort(l);
        if (descending) {
            Collections.reverse(l);
        }
        return l;
    }

    public LongToIntHashMap copy() {
        LongToIntHashMap ret = new LongToIntHashMap();
        ret.keys = Arrays.copyOf(this.keys, this.keys.length);
        ret.values = Arrays.copyOf(this.values, this.values.length);
        ret.size = this.size;
        ret.sorted = this.sorted;
        ret.maxLoadFactor = this.maxLoadFactor;
        return ret;
    }

    private abstract class MapIterator<E>
    implements Iterator<E> {
        private int next;
        private int end;

        public MapIterator() {
            this.end = LongToIntHashMap.this.keys == null ? LongToIntHashMap.this.size : LongToIntHashMap.this.values.length;
            this.next = -1;
            this.nextIndex();
        }

        @Override
        public boolean hasNext() {
            return this.end > 0 && this.next < this.end;
        }

        int nextIndex() {
            int curr = this.next;
            do {
                ++this.next;
            } while (this.next < this.end && LongToIntHashMap.this.keys != null && LongToIntHashMap.this.values[this.next] == -1);
            return curr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PrimitiveEntryIterator
    extends MapIterator<Entry> {
        private PrimitiveEntryIterator() {
        }

        @Override
        public Entry next() {
            int nextIndex = this.nextIndex();
            return new Entry(LongToIntHashMap.this.keys == null ? (long)nextIndex : LongToIntHashMap.this.keys[nextIndex], LongToIntHashMap.this.values[nextIndex], nextIndex);
        }
    }

    private class KeyIterator
    extends MapIterator<Long> {
        private KeyIterator() {
        }

        @Override
        public Long next() {
            int nextIndex = this.nextIndex();
            return LongToIntHashMap.this.keys == null ? (long)nextIndex : LongToIntHashMap.this.keys[nextIndex];
        }
    }

    private class EntryIterator
    extends MapIterator<Map.Entry<Long, Integer>> {
        private EntryIterator() {
        }

        @Override
        public Entry next() {
            int nextIndex = this.nextIndex();
            return new Entry(LongToIntHashMap.this.keys == null ? (long)nextIndex : LongToIntHashMap.this.keys[nextIndex], LongToIntHashMap.this.values[nextIndex], nextIndex);
        }
    }

    public class Entry
    implements Map.Entry<Long, Integer>,
    Comparable<Entry> {
        private int index;
        public long key;
        public int value;

        public Entry(long key, int value, int index) {
            this.key = key;
            assert (value >= 0);
            this.value = value;
            this.index = index;
        }

        @Override
        public Long getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            this.value = value;
            ((LongToIntHashMap)LongToIntHashMap.this).values[this.index] = value;
            return this.value;
        }

        @Override
        public int compareTo(Entry o) {
            return Double.compare(this.value, o.value);
        }
    }
}

