/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.relation.DownloadSelectedIncompleteMembersAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.data.validation.tests.MultipolygonTest;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationMemberTask;
import org.openstreetmap.josm.gui.dialogs.relation.DownloadRelationTask;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSorter;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class CreateMultipolygonAction
extends JosmAction {
    private final boolean update;
    private static final int MAX_MEMBERS_TO_DOWNLOAD = 100;
    private static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "fence_type", "source");

    public CreateMultipolygonAction(boolean update) {
        super(CreateMultipolygonAction.getName(update), update ? "multipoly_update" : "multipoly_create", CreateMultipolygonAction.getName(update), update ? Shortcut.registerShortcut("tools:multipoly_update", I18n.tr("Tools: {0}", CreateMultipolygonAction.getName(true)), 66, 5009) : Shortcut.registerShortcut("tools:multipoly_create", I18n.tr("Tools: {0}", CreateMultipolygonAction.getName(false)), 66, 5006), true, update ? "multipoly_update" : "multipoly_create", true);
        this.update = update;
    }

    private static String getName(boolean update) {
        return update ? I18n.tr("Update multipolygon", new Object[0]) : I18n.tr("Create multipolygon", new Object[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation multipolygonRelation;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null) {
            new Notification(I18n.tr("No data loaded.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Way> selectedWays = dataSet.getSelectedWays();
        if (selectedWays.isEmpty()) {
            new Notification(I18n.tr("You must select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Relation> selectedRelations = dataSet.getSelectedRelations();
        Relation relation = multipolygonRelation = this.update ? CreateMultipolygonAction.getSelectedMultipolygonRelation(selectedWays, selectedRelations) : null;
        if (this.update && multipolygonRelation == null) {
            return;
        }
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        if (multipolygonRelation != null && editLayer != null && editLayer.isDownloadable()) {
            if (!multipolygonRelation.isNew() && multipolygonRelation.isIncomplete()) {
                MainApplication.worker.submit(new DownloadRelationTask(Collections.singleton(multipolygonRelation), editLayer));
            } else if (multipolygonRelation.hasIncompleteMembers()) {
                SubclassFilteredCollection<IPrimitive, OsmPrimitive> incompleteMembers = Utils.filteredCollection(DownloadSelectedIncompleteMembersAction.buildSetOfIncompleteMembers(Collections.singleton(multipolygonRelation)), OsmPrimitive.class);
                if (incompleteMembers.size() <= 100) {
                    MainApplication.worker.submit(new DownloadRelationMemberTask(multipolygonRelation, incompleteMembers, editLayer));
                } else {
                    MainApplication.worker.submit(new DownloadRelationTask(Collections.singleton(multipolygonRelation), editLayer));
                }
            }
        }
        MainApplication.worker.submit(new CreateUpdateMultipolygonTask(selectedWays, multipolygonRelation));
    }

    private static Relation getSelectedMultipolygonRelation(Collection<Way> selectedWays, Collection<Relation> selectedRelations) {
        Relation candidate = null;
        if (selectedRelations.size() == 1) {
            candidate = selectedRelations.iterator().next();
            if (!candidate.hasTag("type", "multipolygon")) {
                candidate = null;
            }
        } else if (!selectedWays.isEmpty()) {
            for (Way w : selectedWays) {
                for (OsmPrimitive r : w.getReferrers()) {
                    if (r == candidate || r.isDisabled() || !(r instanceof Relation) || !r.hasTag("type", "multipolygon")) continue;
                    if (candidate != null) {
                        return null;
                    }
                    candidate = (Relation)r;
                }
            }
        }
        return candidate;
    }

    public static Pair<Relation, Relation> updateMultipolygonRelation(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        HashSet<Way> ways = new HashSet<Way>(selectedWays);
        ways.addAll(selectedMultipolygonRelation.getMemberPrimitives(Way.class));
        MultipolygonTest mpTest = new MultipolygonTest();
        Relation calculated = mpTest.makeFromWays(ways);
        if (mpTest.getErrors().isEmpty()) {
            return CreateMultipolygonAction.mergeRelationsMembers(selectedMultipolygonRelation, calculated);
        }
        CreateMultipolygonAction.showErrors(mpTest.getErrors());
        calculated.setMembers((List<RelationMember>)null);
        return null;
    }

    private static Pair<Relation, Relation> mergeRelationsMembers(Relation old, Relation calculated) {
        LinkedHashSet<RelationMember> merged = new LinkedHashSet<RelationMember>();
        boolean foundDiff = false;
        int nonWayMember = 0;
        block0: for (RelationMember oldMem : old.getMembers()) {
            if (oldMem.isNode() || oldMem.isRelation()) {
                ++nonWayMember;
                continue;
            }
            for (RelationMember newMem : calculated.getMembers()) {
                if (!newMem.getMember().equals(oldMem.getMember())) continue;
                if (!newMem.getRole().equals(oldMem.getRole())) {
                    foundDiff = true;
                }
                foundDiff |= !merged.add(newMem);
                continue block0;
            }
        }
        if (nonWayMember > 0) {
            foundDiff = true;
            String msg = I18n.trn("Non-Way member removed from multipolygon", "Non-Way members removed from multipolygon", nonWayMember, new Object[0]);
            GuiHelper.runInEDT(() -> new Notification(msg).setIcon(2).show());
        }
        calculated.setMembers((List<RelationMember>)null);
        if (!(foundDiff |= merged.addAll(calculated.getMembers()))) {
            return Pair.create(old, old);
        }
        Relation toModify = new Relation(old);
        toModify.setMembers((List<RelationMember>)new ArrayList<RelationMember>(merged));
        return Pair.create(old, toModify);
    }

    public static Pair<Relation, Relation> createMultipolygonRelation(Collection<Way> selectedWays, boolean showNotif) {
        MultipolygonTest mpTest = new MultipolygonTest();
        Relation calculated = mpTest.makeFromWays(selectedWays);
        calculated.setMembers(RelationSorter.sortMembersByConnectivity(calculated.getMembers()));
        if (mpTest.getErrors().isEmpty()) {
            return Pair.create(null, calculated);
        }
        if (showNotif) {
            CreateMultipolygonAction.showErrors(mpTest.getErrors());
        }
        calculated.setMembers((List<RelationMember>)null);
        return null;
    }

    private static void showErrors(List<TestError> errors) {
        if (!errors.isEmpty()) {
            String errorMessages = errors.stream().map(TestError::getMessage).distinct().collect(Collectors.joining("\n"));
            GuiHelper.runInEDT(() -> new Notification(errorMessages).setIcon(1).show());
        }
    }

    public static Pair<SequenceCommand, Relation> createMultipolygonCommand(Collection<Way> selectedWays, Relation selectedMultipolygonRelation) {
        String commandName;
        Pair<Relation, Relation> rr;
        Pair<Relation, Relation> pair = rr = selectedMultipolygonRelation == null ? CreateMultipolygonAction.createMultipolygonRelation(selectedWays, true) : CreateMultipolygonAction.updateMultipolygonRelation(selectedWays, selectedMultipolygonRelation);
        if (rr == null) {
            return null;
        }
        boolean changedMembers = rr.a != rr.b;
        Relation existingRelation = (Relation)rr.a;
        Relation relation = changedMembers ? (Relation)rr.b : (Relation)rr.a;
        List<Command> list = CreateMultipolygonAction.removeTagsFromWaysIfNeeded(relation);
        if (existingRelation == null) {
            list.add(new AddCommand(selectedWays.iterator().next().getDataSet(), relation));
            commandName = CreateMultipolygonAction.getName(false);
        } else {
            if (changedMembers) {
                if (!relation.getKeys().equals(existingRelation.getKeys())) {
                    list.add(new ChangeCommand(existingRelation, relation));
                } else {
                    list.add(new ChangeMembersCommand(existingRelation, new ArrayList<RelationMember>(relation.getMembers())));
                }
            }
            if (list.isEmpty()) {
                MultipolygonTest mpTest = new MultipolygonTest();
                mpTest.visit(existingRelation);
                if (!mpTest.getErrors().isEmpty()) {
                    CreateMultipolygonAction.showErrors(mpTest.getErrors());
                    return null;
                }
                GuiHelper.runInEDT(() -> new Notification(I18n.tr("Nothing changed", new Object[0])).setDuration(Notification.TIME_SHORT).setIcon(1).show());
                return null;
            }
            commandName = CreateMultipolygonAction.getName(true);
        }
        return Pair.create(new SequenceCommand(commandName, list), relation);
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null || selection.isEmpty()) {
            this.setEnabled(false);
        } else if (this.update) {
            this.setEnabled(CreateMultipolygonAction.getSelectedMultipolygonRelation(ds.getSelectedWays(), ds.getSelectedRelations()) != null);
        } else {
            this.setEnabled(!ds.getSelectedWays().isEmpty());
        }
    }

    public static List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        HashMap<String, String> values = new HashMap<String, String>(relation.getKeys());
        ArrayList<Way> innerWays = new ArrayList<Way>();
        ArrayList<Way> outerWays = new ArrayList<Way>();
        TreeSet<String> conflictingKeys = new TreeSet<String>();
        for (RelationMember m : relation.getMembers()) {
            if (m.hasRole() && "inner".equals(m.getRole()) && m.isWay() && m.getWay().hasKeys()) {
                innerWays.add(m.getWay());
            }
            if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay() || !m.getWay().hasKeys()) continue;
            Iterator way2 = m.getWay();
            outerWays.add((Way)((Object)way2));
            for (String string : ((AbstractPrimitive)((Object)way2)).keySet()) {
                if (!values.containsKey(string)) {
                    values.put(string, ((AbstractPrimitive)((Object)way2)).get(string));
                    continue;
                }
                if (((String)values.get(string)).equals(((AbstractPrimitive)((Object)way2)).get(string))) continue;
                conflictingKeys.add(string);
            }
        }
        if (!Config.getPref().getBoolean("multipoly.alltags", false)) {
            for (RelationMember m : relation.getMembers()) {
                if (!m.hasRole() || !"outer".equals(m.getRole()) || !m.isWay()) continue;
                for (String key : values.keySet()) {
                    if (m.getWay().hasKey(key) || relation.hasKey(key)) continue;
                    conflictingKeys.add(key);
                }
            }
        }
        for (String key : conflictingKeys) {
            values.remove(key);
        }
        for (String linearTag : Config.getPref().getList("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            values.remove(linearTag);
        }
        if ("coastline".equals(values.get("natural"))) {
            values.remove("natural");
        }
        values.put("area", "yes");
        ArrayList<Command> commands = new ArrayList<Command>();
        boolean moveTags = Config.getPref().getBoolean("multipoly.movetags", true);
        for (Map.Entry entry : values.entrySet()) {
            String string = (String)entry.getKey();
            String value = (String)entry.getValue();
            List affectedWays = innerWays.stream().filter(way -> value.equals(way.get(key))).collect(Collectors.toList());
            if (moveTags) {
                for (Way way3 : outerWays) {
                    if (!way3.hasKey(string)) continue;
                    affectedWays.add(way3);
                }
            }
            if (affectedWays.isEmpty()) continue;
            commands.add(new ChangePropertyCommand(affectedWays, string, null));
        }
        values.remove("area");
        if (moveTags && !values.isEmpty()) {
            HashMap<String, String> tagsToAdd = new HashMap<String, String>();
            for (Map.Entry entry : values.entrySet()) {
                String key = (String)entry.getKey();
                if (relation.hasKey(key)) continue;
                if (relation.getDataSet() == null) {
                    relation.put(key, (String)entry.getValue());
                    continue;
                }
                tagsToAdd.put(key, (String)entry.getValue());
            }
            if (!tagsToAdd.isEmpty()) {
                commands.add(new ChangePropertyCommand(Collections.singleton(relation), tagsToAdd));
            }
        }
        return commands;
    }

    private static final class CreateUpdateMultipolygonTask
    implements Runnable {
        private final Collection<Way> selectedWays;
        private final Relation multipolygonRelation;

        private CreateUpdateMultipolygonTask(Collection<Way> selectedWays, Relation multipolygonRelation) {
            this.selectedWays = selectedWays;
            this.multipolygonRelation = multipolygonRelation;
        }

        @Override
        public void run() {
            Pair<SequenceCommand, Relation> commandAndRelation = CreateMultipolygonAction.createMultipolygonCommand(this.selectedWays, this.multipolygonRelation);
            if (commandAndRelation == null) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                Relation relation;
                UndoRedoHandler.getInstance().add((Command)commandAndRelation.a);
                Relation calculatedRel = (Relation)commandAndRelation.b;
                if (calculatedRel.getDataSet() == null) {
                    calculatedRel.setMembers((List<RelationMember>)null);
                }
                if ((relation = (Relation)MainApplication.getLayerManager().getEditDataSet().getPrimitiveById(calculatedRel)) == null || relation.getDataSet() == null) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    MainApplication.getMap().relationListDialog.selectRelation(relation);
                    if (Config.getPref().getBoolean("multipoly.show-relation-editor", false)) {
                        MainApplication.getLayerManager().getEditDataSet().clearSelection(relation);
                        RelationEditor editor = RelationEditor.getEditor(MainApplication.getLayerManager().getEditLayer(), relation, null);
                        editor.setVisible(true);
                    } else {
                        MainApplication.getLayerManager().getEditLayer().setRecentRelation(relation);
                        if (this.multipolygonRelation == null) {
                            MainApplication.getLayerManager().getEditDataSet().setSelected(relation);
                        }
                    }
                });
            });
        }
    }
}

