/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ConflictCollection
implements Iterable<Conflict<? extends OsmPrimitive>> {
    private final List<Conflict<? extends OsmPrimitive>> conflicts = new ArrayList<Conflict<? extends OsmPrimitive>>();
    private final CopyOnWriteArrayList<IConflictListener> listeners = new CopyOnWriteArrayList();

    public void addConflictListener(IConflictListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeConflictListener(IConflictListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConflictAdded() {
        this.listeners.forEach((? super E listener) -> listener.onConflictsAdded(this));
    }

    protected void fireConflictRemoved() {
        this.listeners.forEach((? super E listener) -> listener.onConflictsRemoved(this));
    }

    protected void addConflict(Conflict<?> conflict) {
        if (this.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            throw new IllegalStateException(I18n.tr("Already registered a conflict for primitive ''{0}''.", conflict.getMy().toString()));
        }
        if (!this.conflicts.contains(conflict)) {
            this.conflicts.add(conflict);
        }
    }

    public void add(Conflict<?> conflict) {
        CheckParameterUtil.ensureParameterNotNull(conflict, "conflict");
        this.addConflict(conflict);
        this.fireConflictAdded();
    }

    public void add(Collection<Conflict<?>> otherConflicts) {
        if (otherConflicts == null) {
            return;
        }
        otherConflicts.forEach(this::addConflict);
        this.fireConflictAdded();
    }

    public void add(OsmPrimitive my, OsmPrimitive their) {
        this.addConflict(new Conflict<OsmPrimitive>(my, their));
        this.fireConflictAdded();
    }

    public void remove(Conflict<?> conflict) {
        this.conflicts.remove(conflict);
        this.fireConflictRemoved();
    }

    @Deprecated
    public void remove(OsmPrimitive my) {
        this.removeForMy(my);
    }

    public Conflict<?> getConflictForMy(OsmPrimitive my) {
        return this.conflicts.stream().filter(c -> c.isMatchingMy(my)).findFirst().orElse(null);
    }

    public Conflict<?> getConflictForTheir(OsmPrimitive their) {
        return this.conflicts.stream().filter(c -> c.isMatchingTheir(their)).findFirst().orElse(null);
    }

    public boolean hasConflictForMy(OsmPrimitive my) {
        return this.getConflictForMy(my) != null;
    }

    public boolean hasConflict(Conflict<?> c) {
        return this.hasConflictForMy((OsmPrimitive)c.getMy());
    }

    public boolean hasConflictForTheir(OsmPrimitive their) {
        return this.getConflictForTheir(their) != null;
    }

    public void removeForMy(OsmPrimitive my) {
        if (this.conflicts.removeIf(c -> c.isMatchingMy(my))) {
            this.fireConflictRemoved();
        }
    }

    public void removeForTheir(OsmPrimitive their) {
        if (this.conflicts.removeIf(c -> c.isMatchingTheir(their))) {
            this.fireConflictRemoved();
        }
    }

    public List<Conflict<?>> get() {
        return this.conflicts;
    }

    public int size() {
        return this.conflicts.size();
    }

    public Conflict<?> get(int idx) {
        return this.conflicts.get(idx);
    }

    @Override
    public Iterator<Conflict<?>> iterator() {
        return this.conflicts.iterator();
    }

    public void add(ConflictCollection other) {
        other.conflicts.stream().filter(c -> !this.hasConflict((Conflict<?>)c)).forEach(this::add);
    }

    public Set<OsmPrimitive> getMyConflictParties() {
        return this.conflicts.stream().map(Conflict::getMy).collect(Collectors.toSet());
    }

    public Set<OsmPrimitive> getTheirConflictParties() {
        return this.conflicts.stream().map(Conflict::getTheir).collect(Collectors.toSet());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.conflicts.toString();
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getNodeConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Node);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getWayConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Way);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getRelationConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, c -> c != null && c.getMy() instanceof Relation);
    }

    public int hashCode() {
        return Objects.hash(this.conflicts, this.listeners);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConflictCollection conflicts1 = (ConflictCollection)obj;
        return Objects.equals(this.conflicts, conflicts1.conflicts) && Objects.equals(this.listeners, conflicts1.listeners);
    }
}

