/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.lateral.socket.tcp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCache;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheMonitor;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWait;
import org.apache.commons.jcs3.auxiliary.lateral.LateralCacheNoWaitFacade;
import org.apache.commons.jcs3.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPDiscoveryListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPListener;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.LateralTCPService;
import org.apache.commons.jcs3.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.commons.jcs3.engine.CacheWatchRepairable;
import org.apache.commons.jcs3.engine.ZombieCacheServiceNonLocal;
import org.apache.commons.jcs3.engine.ZombieCacheWatch;
import org.apache.commons.jcs3.engine.behavior.ICacheServiceNonLocal;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryManager;
import org.apache.commons.jcs3.utils.discovery.UDPDiscoveryService;

public class LateralTCPCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private static final Log log = LogManager.getLog(LateralTCPCacheFactory.class);
    private ConcurrentHashMap<String, ICacheServiceNonLocal<?, ?>> csnlInstances;
    private ConcurrentHashMap<String, LateralTCPDiscoveryListener> lTCPDLInstances;
    private LateralCacheMonitor monitor;
    private CacheWatchRepairable lateralWatch;

    public <K, V> LateralCacheNoWaitFacade<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ITCPLateralCacheAttributes lac = (ITCPLateralCacheAttributes)iaca;
        ArrayList<LateralCacheNoWait<K, V>> noWaits = new ArrayList<LateralCacheNoWait<K, V>>();
        if (lac.getTcpServers() != null) {
            StringTokenizer it = new StringTokenizer(lac.getTcpServers(), ",");
            log.debug("Configured for [{0}] servers.", () -> it.countTokens());
            while (it.hasMoreElements()) {
                String server = (String)it.nextElement();
                log.debug("tcp server = {0}", server);
                ITCPLateralCacheAttributes lacC = (ITCPLateralCacheAttributes)lac.clone();
                lacC.setTcpServer(server);
                LateralCacheNoWait<K, V> lateralNoWait = this.createCacheNoWait(lacC, cacheEventLogger, elementSerializer);
                this.addListenerIfNeeded(lacC, cacheMgr);
                this.monitor.addCache(lateralNoWait);
                noWaits.add(lateralNoWait);
            }
        }
        ILateralCacheListener<K, V> listener = this.createListener(lac, cacheMgr);
        LateralCacheNoWait[] lcnwArray = noWaits.toArray(new LateralCacheNoWait[0]);
        LateralCacheNoWaitFacade<K, V> lcnwf = new LateralCacheNoWaitFacade<K, V>(listener, lcnwArray, lac);
        this.createDiscoveryService(lac, lcnwf, cacheMgr, cacheEventLogger, elementSerializer);
        return lcnwf;
    }

    protected <K, V> LateralCacheNoWait<K, V> createCacheNoWait(ITCPLateralCacheAttributes lca, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        ICacheServiceNonLocal<K, V> lateralService = this.getCSNLInstance(lca);
        LateralCache<K, V> cache = new LateralCache<K, V>(lca, lateralService, this.monitor);
        cache.setCacheEventLogger(cacheEventLogger);
        cache.setElementSerializer(elementSerializer);
        log.debug("Created cache for noWait, cache [{0}]", cache);
        LateralCacheNoWait<K, V> lateralNoWait = new LateralCacheNoWait<K, V>(cache);
        lateralNoWait.setCacheEventLogger(cacheEventLogger);
        lateralNoWait.setElementSerializer(elementSerializer);
        log.info("Created LateralCacheNoWait for [{0}] LateralCacheNoWait = [{1}]", lca, lateralNoWait);
        return lateralNoWait;
    }

    @Override
    public void initialize() {
        this.csnlInstances = new ConcurrentHashMap();
        this.lTCPDLInstances = new ConcurrentHashMap();
        this.monitor = new LateralCacheMonitor(this);
        this.monitor.setDaemon(true);
        this.monitor.start();
        this.lateralWatch = new CacheWatchRepairable();
        this.lateralWatch.setCacheWatch(new ZombieCacheWatch());
    }

    @Override
    public void dispose() {
        for (ICacheServiceNonLocal<?, ?> service : this.csnlInstances.values()) {
            try {
                service.dispose("");
            }
            catch (IOException e) {
                log.error("Could not dispose service " + service, e);
            }
        }
        this.csnlInstances.clear();
        this.lTCPDLInstances.clear();
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
    }

    public <K, V> ICacheServiceNonLocal<K, V> getCSNLInstance(ITCPLateralCacheAttributes lca) {
        String key = lca.getTcpServer();
        this.csnlInstances.computeIfPresent(key, (name, service) -> {
            if (service instanceof ZombieCacheServiceNonLocal) {
                log.info("Disposing of zombie service instance for [{0}]", name);
                return null;
            }
            return service;
        });
        ICacheServiceNonLocal service2 = this.csnlInstances.computeIfAbsent(key, name -> {
            log.info("Instance for [{0}] is null, creating", name);
            try {
                log.info("Creating TCP service, lca = {0}", lca);
                return new LateralTCPService(lca);
            }
            catch (IOException ex) {
                log.error("Failure, lateral instance will use zombie service", ex);
                ZombieCacheServiceNonLocal zombieService = new ZombieCacheServiceNonLocal(lca.getZombieQueueMaxSize());
                this.monitor.notifyError();
                return zombieService;
            }
        });
        return service2;
    }

    private LateralTCPDiscoveryListener getDiscoveryListener(ITCPLateralCacheAttributes ilca, ICompositeCacheManager cacheManager) {
        String key = ilca.getUdpDiscoveryAddr() + ":" + ilca.getUdpDiscoveryPort();
        LateralTCPDiscoveryListener ins = this.lTCPDLInstances.computeIfAbsent(key, key1 -> {
            log.info("Created new discovery listener for cacheName {0} for request {1}", key1, ilca.getCacheName());
            return new LateralTCPDiscoveryListener(this.getName(), cacheManager);
        });
        return ins;
    }

    private void addListenerIfNeeded(ITCPLateralCacheAttributes iaca, ICompositeCacheManager cacheMgr) {
        if (iaca.isReceive()) {
            try {
                this.addLateralCacheListener(iaca.getCacheName(), LateralTCPListener.getInstance(iaca, cacheMgr));
            }
            catch (IOException ioe) {
                log.error("Problem creating lateral listener", ioe);
            }
        } else {
            log.debug("Not creating a listener since we are not receiving.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void addLateralCacheListener(String cacheName, ILateralCacheListener<K, V> listener) throws IOException {
        CacheWatchRepairable cacheWatchRepairable = this.lateralWatch;
        synchronized (cacheWatchRepairable) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    private <K, V> ILateralCacheListener<K, V> createListener(ITCPLateralCacheAttributes attr, ICompositeCacheManager cacheMgr) {
        LateralTCPListener listener = null;
        if (attr.isReceive()) {
            log.info("Getting listener for {0}", attr);
            listener = LateralTCPListener.getInstance(attr, cacheMgr);
            cacheMgr.registerShutdownObserver(listener);
        } else {
            log.debug("Not creating a listener since we are not receiving.");
        }
        return listener;
    }

    private synchronized <K, V> UDPDiscoveryService createDiscoveryService(ITCPLateralCacheAttributes lac, LateralCacheNoWaitFacade<K, V> lcnwf, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        UDPDiscoveryService discovery = null;
        if (lac.isUdpDiscoveryEnabled()) {
            LateralTCPDiscoveryListener discoveryListener = this.getDiscoveryListener(lac, cacheMgr);
            discoveryListener.addNoWaitFacade(lac.getCacheName(), lcnwf);
            discovery = UDPDiscoveryManager.getInstance().getService(lac.getUdpDiscoveryAddr(), lac.getUdpDiscoveryPort(), lac.getTcpListenerPort(), cacheMgr);
            discovery.addParticipatingCacheName(lac.getCacheName());
            discovery.addDiscoveryListener(discoveryListener);
            log.info("Registered TCP lateral cache [{0}] with UDPDiscoveryService.", () -> lac.getCacheName());
        }
        return discovery;
    }
}

