/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.tags;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.gui.conflict.tags.MultiValueCellEditor;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverColumnModel;
import org.openstreetmap.josm.gui.conflict.tags.RelationMemberConflictResolverModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;

public class RelationMemberConflictResolverTable
extends JTable
implements MultiValueCellEditor.NavigationListener {
    private SelectNextColumnCellAction selectNextColumnCellAction;
    private SelectPreviousColumnCellAction selectPreviousColumnCellAction;

    public RelationMemberConflictResolverTable(RelationMemberConflictResolverModel model) {
        super(model, new RelationMemberConflictResolverColumnModel());
        this.build();
    }

    protected final void build() {
        this.setAutoResizeMode(4);
        this.setSelectionMode(0);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, false), "selectNextColumnCell");
        this.selectNextColumnCellAction = new SelectNextColumnCellAction();
        this.selectPreviousColumnCellAction = new SelectPreviousColumnCellAction();
        this.getActionMap().put("selectNextColumnCell", this.selectNextColumnCellAction);
        this.getActionMap().put("selectPreviousColumnCell", this.selectPreviousColumnCellAction);
        this.setRowHeight((int)new JosmComboBox().getPreferredSize().getHeight());
    }

    @Override
    public void gotoNextDecision() {
        this.selectNextColumnCellAction.run();
    }

    @Override
    public void gotoPreviousDecision() {
        this.selectPreviousColumnCellAction.run();
    }

    class SelectNextColumnCellAction
    extends AbstractAction {
        SelectNextColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = RelationMemberConflictResolverTable.this.getSelectedColumn();
            int row = RelationMemberConflictResolverTable.this.getSelectedRow();
            if (RelationMemberConflictResolverTable.this.getCellEditor() != null) {
                RelationMemberConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if (col == 2 && row < RelationMemberConflictResolverTable.this.getRowCount() - 1) {
                ++row;
            } else if (row < RelationMemberConflictResolverTable.this.getRowCount() - 1) {
                col = 2;
                ++row;
            }
            RelationMemberConflictResolverTable.this.changeSelection(row, col, false, false);
            RelationMemberConflictResolverTable.this.editCellAt(RelationMemberConflictResolverTable.this.getSelectedRow(), RelationMemberConflictResolverTable.this.getSelectedColumn());
            RelationMemberConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
        }
    }

    class SelectPreviousColumnCellAction
    extends AbstractAction {
        SelectPreviousColumnCellAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.run();
        }

        public void run() {
            int col = RelationMemberConflictResolverTable.this.getSelectedColumn();
            int row = RelationMemberConflictResolverTable.this.getSelectedRow();
            if (RelationMemberConflictResolverTable.this.getCellEditor() != null) {
                RelationMemberConflictResolverTable.this.getCellEditor().stopCellEditing();
            }
            if ((col > 0 || row > 0) && row > 0) {
                col = 2;
                --row;
            }
            RelationMemberConflictResolverTable.this.changeSelection(row, col, false, false);
            RelationMemberConflictResolverTable.this.editCellAt(RelationMemberConflictResolverTable.this.getSelectedRow(), RelationMemberConflictResolverTable.this.getSelectedColumn());
            RelationMemberConflictResolverTable.this.getEditorComponent().requestFocusInWindow();
        }
    }
}

