/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class Highways
extends Test {
    protected static final int WRONG_ROUNDABOUT_HIGHWAY = 2701;
    protected static final int MISSING_PEDESTRIAN_CROSSING = 2702;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_COUNTRY_CODE = 2703;
    protected static final int SOURCE_MAXSPEED_UNKNOWN_CONTEXT = 2704;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_MAXSPEED = 2705;
    protected static final int SOURCE_MAXSPEED_CONTEXT_MISMATCH_VS_HIGHWAY = 2706;
    protected static final int SOURCE_WRONG_LINK = 2707;
    protected static final int DIFFERENT_LAYERS = 2708;
    protected static final String SOURCE_MAXSPEED = "source:maxspeed";
    static final List<String> CLASSIFIED_HIGHWAYS = Arrays.asList("motorway", "motorway_link", "trunk", "trunk_link", "primary", "primary_link", "secondary", "secondary_link", "tertiary", "tertiary_link", "unclassified", "residential", "living_street");
    private static final Set<String> KNOWN_SOURCE_MAXSPEED_CONTEXTS = new HashSet<String>(Arrays.asList("urban", "rural", "zone", "zone10", "zone:10", "zone20", "zone:20", "zone30", "zone:30", "zone40", "zone:40", "zone60", "zone:60", "nsl_single", "nsl_dual", "motorway", "trunk", "living_street", "bicycle_road"));
    private static final Set<String> ISO_COUNTRIES = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
    private boolean leftByPedestrians;
    private boolean leftByCyclists;
    private boolean leftByCars;
    private int pedestrianWays;
    private int cyclistWays;
    private int carsWays;

    public Highways() {
        super(I18n.tr("Highways", new Object[0]), I18n.tr("Performs semantic checks on highways.", new Object[0]));
    }

    @Override
    public void visit(Node n) {
        if (n.isUsable()) {
            if (!(n.hasTag("crossing", "no") || n.hasKey("crossing") && (n.hasTag("highway", "crossing") || n.hasTag("highway", "traffic_signals")) || !n.isReferredByWays(2))) {
                this.testMissingPedestrianCrossing(n);
            }
            if (n.hasKey(SOURCE_MAXSPEED)) {
                this.testSourceMaxspeed(n, false);
            }
            if (n.isReferredByWays(2)) {
                this.testDifferentLayers(n);
            }
        }
    }

    @Override
    public void visit(Way w) {
        if (w.isUsable()) {
            if (w.isClosed() && w.hasTag("highway", CLASSIFIED_HIGHWAYS) && w.hasTag("junction", "circular", "roundabout") && IN_DOWNLOADED_AREA_STRICT.test(w)) {
                this.testWrongRoundabout(w);
            }
            if (w.hasKey(SOURCE_MAXSPEED)) {
                this.testSourceMaxspeed(w, true);
            }
            this.testHighwayLink(w);
        }
    }

    private void testWrongRoundabout(Way w) {
        HashMap<String, List> map = new HashMap<String, List>();
        for (Node n : new HashSet<Node>(w.getNodes())) {
            for (Way h : n.referrers(Way.class)::iterator) {
                String value = h.get("highway");
                if (h == w || value == null) continue;
                boolean link = value.endsWith("_link");
                boolean linkOk = Highways.isHighwayLinkOkay(h);
                if (link && !linkOk) {
                    value = value.replaceAll("_link$", "");
                }
                if (link && linkOk) continue;
                List list = map.computeIfAbsent(value, k -> new ArrayList());
                list.add(h);
            }
        }
        for (String s : CLASSIFIED_HIGHWAYS) {
            List list = (List)map.get(s);
            if (list == null || list.size() < 2) continue;
            Boolean oneway1 = OsmUtils.getOsmBoolean(((Way)list.get(0)).get("oneway"));
            Boolean oneway2 = OsmUtils.getOsmBoolean(((Way)list.get(1)).get("oneway"));
            if (list.size() <= 2 && oneway1 != null && oneway2 != null && oneway1.booleanValue() && oneway2.booleanValue()) continue;
            String value = w.get("highway");
            if (value.equals(s)) break;
            this.errors.add(TestError.builder(this, Severity.WARNING, 2701).message(I18n.tr("Incorrect roundabout (highway: {0} instead of {1})", value, s)).primitives(w).fix(() -> new ChangePropertyCommand(w, "highway", s)).build());
            break;
        }
    }

    public static boolean isHighwayLinkOkay(Way way) {
        String highway = way.get("highway");
        if (!(highway != null && highway.endsWith("_link") && IN_DOWNLOADED_AREA.test(way.getNode(0)) && IN_DOWNLOADED_AREA.test(way.getNode(way.getNodesCount() - 1)))) {
            return true;
        }
        HashSet<OsmPrimitive> referrers = new HashSet<OsmPrimitive>();
        if (way.isClosed()) {
            for (Node n : way.getNodes()) {
                referrers.addAll(n.getReferrers());
            }
        } else {
            referrers.addAll(way.firstNode().getReferrers());
            referrers.addAll(way.lastNode().getReferrers());
        }
        List sameClass = Utils.filteredCollection(referrers, Way.class).stream().filter(otherWay -> !way.equals(otherWay) && otherWay.hasTag("highway", highway, highway.replaceAll("_link$", ""))).collect(Collectors.toList());
        if (sameClass.size() > 1) {
            for (Way w : sameClass) {
                if (!w.hasTag("junction", "circular", "roundabout")) continue;
                return false;
            }
        }
        return !sameClass.isEmpty();
    }

    private void testHighwayLink(Way way) {
        if (!Highways.isHighwayLinkOkay(way)) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 2707).message(I18n.tr("Highway link is not linked to adequate highway/link", new Object[0])).primitives(way).build());
        }
    }

    private void testMissingPedestrianCrossing(Node n) {
        this.leftByPedestrians = false;
        this.leftByCyclists = false;
        this.leftByCars = false;
        this.pedestrianWays = 0;
        this.cyclistWays = 0;
        this.carsWays = 0;
        if (n.hasTag("highway", "crossing") && !n.hasKey("crossing")) {
            return;
        }
        for (Way w : n.getParentWays()) {
            String highway = w.get("highway");
            if (highway == null) continue;
            if ("footway".equals(highway) || "path".equals(highway)) {
                this.handlePedestrianWay(n, w);
                if (w.hasTag("bicycle", "yes", "designated")) {
                    this.handleCyclistWay(n, w);
                }
            } else if ("cycleway".equals(highway)) {
                this.handleCyclistWay(n, w);
                if (w.hasTag("foot", "yes", "designated")) {
                    this.handlePedestrianWay(n, w);
                }
            } else if (CLASSIFIED_HIGHWAYS.contains(highway)) {
                this.handleCarWay(n, w);
            }
            if (!this.leftByPedestrians && !this.leftByCyclists || !this.leftByCars) continue;
            this.errors.add(TestError.builder(this, Severity.OTHER, 2702).message(I18n.tr("Incomplete pedestrian crossing tagging. Required tags are {0} and {1}.", "highway=crossing|traffic_signals", "crossing=*")).primitives(n).build());
            return;
        }
    }

    private void handleCarWay(Node n, Way w) {
        ++this.carsWays;
        if (!w.isFirstLastNode(n) || this.carsWays > 1) {
            this.leftByCars = true;
        }
    }

    private void handleCyclistWay(Node n, Way w) {
        ++this.cyclistWays;
        if (!w.isFirstLastNode(n) || this.cyclistWays > 1) {
            this.leftByCyclists = true;
        }
    }

    private void handlePedestrianWay(Node n, Way w) {
        ++this.pedestrianWays;
        if (!w.isFirstLastNode(n) || this.pedestrianWays > 1) {
            this.leftByPedestrians = true;
        }
    }

    private void testSourceMaxspeed(OsmPrimitive p, boolean testContextHighway) {
        String value = p.get(SOURCE_MAXSPEED);
        if (value.matches("[A-Z]{2}:.+")) {
            String context;
            int index = value.indexOf(58);
            String country = value.substring(0, index);
            if (!ISO_COUNTRIES.contains(country)) {
                TestError.Builder error = TestError.builder(this, Severity.WARNING, 2703).message(I18n.tr("Unknown country code: {0}", country)).primitives(p);
                if ("UK".equals(country)) {
                    this.errors.add(error.fix(() -> new ChangePropertyCommand(p, SOURCE_MAXSPEED, value.replace("UK:", "GB:"))).build());
                } else {
                    this.errors.add(error.build());
                }
            }
            if (!KNOWN_SOURCE_MAXSPEED_CONTEXTS.contains(context = value.substring(index + 1))) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 2704).message(I18n.tr("Unknown source:maxspeed context: {0}", context)).primitives(p).build());
            }
            if (testContextHighway) {
                Logging.trace("TODO: test context highway - https://josm.openstreetmap.de/ticket/9400");
            }
        }
    }

    private void testDifferentLayers(Node connection) {
        if (connection.hasTag("highway", "elevator")) {
            return;
        }
        List<Way> ways = connection.getParentWays();
        ways.removeIf(w -> !w.hasTag("highway") || w.hasTag("highway", "steps") || Highways.isSpecialArea(w));
        if (ways.size() < 2 || ways.stream().noneMatch(w -> w.hasKey("layer"))) {
            return;
        }
        HashMap<String, List> layerCount = new HashMap<String, List>();
        for (Way way : ways) {
            String layer = way.get("layer");
            if (layer == null) {
                layer = "0";
            }
            layerCount.computeIfAbsent(layer, k -> new ArrayList()).add(way);
        }
        if (layerCount.size() == 1) {
            return;
        }
        for (Map.Entry entry : layerCount.entrySet()) {
            if ("0".equals(entry.getKey()) || !Highways.checkLayer(connection, (List)entry.getValue())) continue;
            this.errors.add(TestError.builder(this, Severity.WARNING, 2708).message(I18n.tr("Node connects highways on different layers", new Object[0])).primitives(connection).build());
            return;
        }
    }

    private static boolean isSpecialArea(Way w) {
        return w.hasAreaTags() && OsmUtils.getLayer(w) != null;
    }

    private static boolean checkLayer(Node connection, List<Way> ways) {
        int count = 0;
        for (Way w : ways) {
            if (!w.isFirstLastNode(connection)) {
                return true;
            }
            ++count;
        }
        return count > 1;
    }
}

