/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class AddNodeAction
extends JosmAction {
    private String textLatLon;
    private String textEastNorth;

    public AddNodeAction() {
        super(I18n.tr("Add Node...", new Object[0]), "addnode", I18n.tr("Add a node by entering latitude / longitude or easting / northing.", new Object[0]), Shortcut.registerShortcut("addnode", I18n.tr("Tools: {0}", I18n.tr("Add Node...", new Object[0])), 68, 5005), true);
        this.setHelpId(HelpUtil.ht("/Action/AddNode"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            LatLonDialog dialog = new LatLonDialog((Component)MainApplication.getMainFrame(), I18n.tr("Add Node...", new Object[0]), HelpUtil.ht("/Action/AddNode"));
            if (this.textLatLon != null) {
                dialog.setLatLonText(this.textLatLon);
            }
            if (this.textEastNorth != null) {
                dialog.setEastNorthText(this.textEastNorth);
            }
            dialog.showDialog();
            if (dialog.getValue() != 1) {
                return;
            }
            LatLon coordinates = dialog.getCoordinates();
            if (coordinates == null) {
                return;
            }
            this.textLatLon = dialog.getLatLonText();
            this.textEastNorth = dialog.getEastNorthText();
            Node nnew = new Node(coordinates);
            DataSet ds = this.getLayerManager().getEditDataSet();
            UndoRedoHandler.getInstance().add(new AddCommand(ds, nnew));
            ds.setSelected(nnew);
            MapView mapView = MainApplication.getMap().mapView;
            if (mapView != null && !mapView.getRealBounds().contains(nnew)) {
                AutoScaleAction.zoomTo(Collections.singleton(nnew));
            }
        });
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getEditLayer() != null);
    }
}

