/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;

public final class TileZXY
implements ILatLon {
    private final int zoom;
    private final int x;
    private final int y;

    public TileZXY(int zoom, int x, int y) {
        this.zoom = zoom;
        this.x = x;
        this.y = y;
    }

    public int zoom() {
        return this.zoom;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    @Override
    public double lat() {
        return TileZXY.yToLat(this.y(), this.zoom());
    }

    @Override
    public double lon() {
        return TileZXY.xToLon(this.x(), this.zoom());
    }

    public static Stream<TileZXY> boundsToTiles(double minLat, double minLon, double maxLat, double maxLon, int zoom) {
        return TileZXY.boundsToTiles(minLat, minLon, maxLat, maxLon, zoom, 0);
    }

    public static Stream<TileZXY> boundsToTiles(double minLat, double minLon, double maxLat, double maxLon, int zoom, int expansion) {
        TileZXY upperRight = TileZXY.latLonToTile(maxLat, maxLon, zoom);
        TileZXY lowerLeft = TileZXY.latLonToTile(minLat, minLon, zoom);
        return IntStream.rangeClosed(lowerLeft.x() - expansion, upperRight.x() + expansion).mapToObj(x -> IntStream.rangeClosed(upperRight.y() - expansion, lowerLeft.y() + expansion).mapToObj(y -> new TileZXY(zoom, x, y))).flatMap(stream -> stream);
    }

    public static Bounds tileToBounds(TileZXY tile) {
        return new Bounds(TileZXY.yToLat(tile.y() + 1, tile.zoom()), TileZXY.xToLon(tile.x(), tile.zoom()), TileZXY.yToLat(tile.y(), tile.zoom()), TileZXY.xToLon(tile.x() + 1, tile.zoom()));
    }

    public static double xToLon(int x, int zoom) {
        return (double)x / Math.pow(2.0, zoom) * 360.0 - 180.0;
    }

    public static double yToLat(int y, int zoom) {
        double t = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, zoom);
        return 57.29577951308232 * Math.atan((Math.exp(t) - Math.exp(-t)) / 2.0);
    }

    public static TileZXY latLonToTile(double lat, double lon, int zoom) {
        int xCoord = (int)Math.floor(Math.pow(2.0, zoom) * (180.0 + lon) / 360.0);
        int yCoord = (int)Math.floor(Math.pow(2.0, zoom) * (1.0 - Math.log(Math.tan(Math.toRadians(lat)) + 1.0 / Math.cos(Math.toRadians(lat))) / Math.PI) / 2.0);
        return new TileZXY(zoom, xCoord, yCoord);
    }

    public String toString() {
        return "TileZXY{" + this.zoom + "/" + this.x + "/" + this.y + "}";
    }

    public int hashCode() {
        return Integer.hashCode(this.zoom) + 31 * (Integer.hashCode(this.x) + 31 * Integer.hashCode(this.y));
    }

    public boolean equals(Object obj) {
        if (obj instanceof TileZXY) {
            TileZXY o = (TileZXY)obj;
            return this.zoom == o.zoom && this.x == o.x && this.y == o.y;
        }
        return false;
    }
}

