/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveTask;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.AreaIconElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextElement;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ComputeStyleListWorker
extends RecursiveTask<List<StyledMapRenderer.StyleRecord>>
implements PrimitiveVisitor {
    private static final long serialVersionUID = 1L;
    private final transient List<? extends IPrimitive> input;
    private final transient List<StyledMapRenderer.StyleRecord> output;
    private final transient ElemStyles styles;
    private final int directExecutionTaskSize;
    private final double circum;
    private final NavigatableComponent nc;
    private final boolean drawArea;
    private final boolean drawMultipolygon;
    private final boolean drawRestriction;

    ComputeStyleListWorker(double circum, NavigatableComponent nc, List<? extends IPrimitive> input, List<StyledMapRenderer.StyleRecord> output, int directExecutionTaskSize) {
        this(circum, nc, input, output, directExecutionTaskSize, MapPaintStyles.getStyles());
    }

    ComputeStyleListWorker(double circum, NavigatableComponent nc, List<? extends IPrimitive> input, List<StyledMapRenderer.StyleRecord> output, int directExecutionTaskSize, ElemStyles styles) {
        this.circum = circum;
        this.nc = nc;
        this.input = input;
        this.output = output;
        this.directExecutionTaskSize = directExecutionTaskSize;
        this.styles = styles;
        this.drawArea = circum <= (double)Config.getPref().getInt("mappaint.fillareas", 10000000);
        this.drawMultipolygon = this.drawArea && Config.getPref().getBoolean("mappaint.multipolygon", true);
        this.drawRestriction = Config.getPref().getBoolean("mappaint.restriction", true);
        this.styles.setDrawMultipolygon(this.drawMultipolygon);
    }

    @Override
    protected List<StyledMapRenderer.StyleRecord> compute() {
        if (this.input.size() <= this.directExecutionTaskSize) {
            return this.computeDirectly();
        }
        ArrayList tasks = new ArrayList();
        for (int fromIndex = 0; fromIndex < this.input.size(); fromIndex += this.directExecutionTaskSize) {
            int n = Math.min(fromIndex + this.directExecutionTaskSize, this.input.size());
            tasks.add(new ComputeStyleListWorker(this.circum, this.nc, this.input.subList(fromIndex, n), new ArrayList<StyledMapRenderer.StyleRecord>(this.directExecutionTaskSize), this.directExecutionTaskSize, this.styles).fork());
        }
        for (ForkJoinTask forkJoinTask : tasks) {
            this.output.addAll((Collection)forkJoinTask.join());
        }
        return this.output;
    }

    public List<StyledMapRenderer.StyleRecord> computeDirectly() {
        MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().lock();
        try {
            for (IPrimitive iPrimitive : this.input) {
                this.acceptDrawable(iPrimitive);
            }
            List<StyledMapRenderer.StyleRecord> list = this.output;
            return list;
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("input-size", this.input.size()).put("output-size", this.output.size());
        }
        finally {
            MapCSSStyleSource.STYLE_SOURCE_LOCK.readLock().unlock();
        }
    }

    private void acceptDrawable(IPrimitive osm) {
        try {
            if (osm.isDrawable()) {
                osm.accept(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
            throw BugReport.intercept(e).put("osm", osm);
        }
    }

    @Override
    public void visit(INode n) {
        this.add(n, StyledMapRenderer.computeFlags(n, false));
    }

    @Override
    public void visit(IWay<?> w) {
        this.add(w, StyledMapRenderer.computeFlags(w, true));
    }

    @Override
    public void visit(IRelation<?> r) {
        this.add(r, StyledMapRenderer.computeFlags(r, true));
    }

    public void add(INode osm, int flags) {
        StyleElementList sl = this.styles.get(osm, this.circum, this.nc);
        for (StyleElement s : sl) {
            this.output.add(new StyledMapRenderer.StyleRecord(s, osm, flags));
        }
    }

    public void add(IWay<?> osm, int flags) {
        StyleElementList sl = this.styles.get(osm, this.circum, this.nc);
        for (StyleElement s : sl) {
            if ((!this.drawArea || (flags & 1) != 0) && s instanceof AreaElement) continue;
            this.output.add(new StyledMapRenderer.StyleRecord(s, osm, flags));
        }
    }

    public void add(IRelation<?> osm, int flags) {
        StyleElementList sl = this.styles.get(osm, this.circum, this.nc);
        for (StyleElement s : sl) {
            if (!this.drawAreaElement(flags, s) && (!this.drawMultipolygon || !this.drawArea || !(s instanceof TextElement)) && (!this.drawRestriction || !(s instanceof NodeElement))) continue;
            this.output.add(new StyledMapRenderer.StyleRecord(s, osm, flags));
        }
    }

    private boolean drawAreaElement(int flags, StyleElement s) {
        return this.drawMultipolygon && this.drawArea && (s instanceof AreaElement || s instanceof AreaIconElement) && (flags & 1) == 0;
    }
}

