/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.session.PluginSessionExporter;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;

public class SessionSaveAction
extends DiskAccessAction
implements MapFrameListener,
LayerManager.LayerChangeListener {
    private transient List<Layer> layers;
    private transient Map<Layer, SessionLayerExporter> exporters;
    private transient MultiMap<Layer, Layer> dependencies;
    private static final BooleanProperty SAVE_LOCAL_FILES_PROPERTY = new BooleanProperty("session.savelocal", true);
    private static final BooleanProperty SAVE_PLUGIN_INFORMATION_PROPERTY = new BooleanProperty("session.saveplugins", false);
    private static final String TOOLTIP_DEFAULT;
    protected transient FileFilter joz = new ExtensionFileFilter("joz", "joz", I18n.tr("Session file (archive) (*.joz)", new Object[0]));
    protected transient FileFilter jos = new ExtensionFileFilter("jos", "jos", I18n.tr("Session file (*.jos)", new Object[0]));
    private File removeFileOnSuccess;
    private static String tooltip;
    static File sessionFile;
    static boolean isZipSessionFile;
    private static boolean pluginData;
    static List<WeakReference<Layer>> layersInSessionFile;
    private static final SessionSaveAction instance;

    public static SessionSaveAction getInstance() {
        return instance;
    }

    public SessionSaveAction() {
        this(true, false);
        this.updateEnabledState();
    }

    protected SessionSaveAction(boolean toolbar, boolean installAdapters) {
        this(I18n.tr("Save Session", new Object[0]), "session", TOOLTIP_DEFAULT, Shortcut.registerShortcut("system:savesession", I18n.tr("File: {0}", I18n.tr("Save Session...", new Object[0])), 83, 5008), toolbar, "save-session", installAdapters);
        this.setHelpId(HelpUtil.ht("/Action/SessionSave"));
    }

    protected SessionSaveAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register, String toolbarId, boolean installAdapters) {
        super(name, iconName, tooltip, shortcut, register, toolbarId, installAdapters);
        this.addListeners();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.saveSession(false, false);
        }
        catch (UserCancelException exception) {
            Logging.trace(exception);
        }
    }

    @Override
    public void destroy() {
        this.removeListeners();
        super.destroy();
    }

    public boolean saveSession(boolean saveAs, boolean forceSaveAll) throws UserCancelException {
        List missingLayers;
        List<Layer> layersOut;
        if (!this.isEnabled()) {
            return false;
        }
        this.removeFileOnSuccess = null;
        SessionSaveAsDialog dlg = new SessionSaveAsDialog();
        if (saveAs) {
            dlg.showDialog();
            if (dlg.getValue() != 1) {
                throw new UserCancelException();
            }
        }
        boolean zipRequired = (layersOut = this.layers.stream().filter(layer -> this.exporters.get(layer) != null && this.exporters.get(layer).shallExport()).collect(Collectors.toList())).stream().map(l -> this.exporters.get(l)).anyMatch(ex -> ex != null && ex.requiresZip()) || SessionSaveAction.pluginsWantToSave();
        saveAs = !this.doGetFile(saveAs, zipRequired);
        String fn = sessionFile.getName();
        if (!(saveAs || layersInSessionFile == null || (missingLayers = layersInSessionFile.stream().map(Reference::get).filter(Objects::nonNull).filter(l -> !layersOut.contains(l)).map(Layer::getName).collect(Collectors.toList())).isEmpty() || ConditionalOptionPaneUtil.showConfirmationDialog("savesession_layerremoved", null, new JLabel("<html>" + I18n.trn("The following layer has been removed since the session was last saved:", "The following layers have been removed since the session was last saved:", missingLayers.size(), new Object[0]) + "<ul><li>" + String.join((CharSequence)"<li>", missingLayers) + "</ul><br>" + I18n.tr("You are about to overwrite the session file \"{0}\". Would you like to proceed?", fn)), I18n.tr("Layers removed", new Object[0]), 2, 2, 0))) {
            throw new UserCancelException();
        }
        SessionSaveAction.setCurrentLayers(layersOut);
        SessionSaveAction.updateSessionFile(fn);
        Stream<Layer> layersToSaveStream = layersOut.stream().filter(layer -> layer.isSavable() && layer instanceof AbstractModifiableLayer && ((AbstractModifiableLayer)layer).requiresSaveToFile() && this.exporters.get(layer) != null && !this.exporters.get(layer).requiresZip());
        boolean success = true;
        if (forceSaveAll || Boolean.TRUE.equals(SAVE_LOCAL_FILES_PROPERTY.get())) {
            if (layersToSaveStream.map(layer -> SaveAction.getInstance().doSave((Layer)layer, true)).collect(Collectors.toList()).contains(false)) {
                new Notification(I18n.tr("Not all local files referenced by the session file could be saved.<br>Make sure you save them before closing JOSM.", new Object[0])).setIcon(2).setDuration(Notification.TIME_LONG).show();
                success = false;
            }
        } else if (layersToSaveStream.anyMatch(l -> true)) {
            new Notification(I18n.tr("Not all local files referenced by the session file are saved yet.<br>Make sure you save them before closing JOSM.", new Object[0])).setIcon(1).setDuration(Notification.TIME_LONG).show();
        }
        int active = -1;
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        if (activeLayer != null) {
            active = layersOut.indexOf(activeLayer);
        }
        EnumSet<SessionWriter.SessionWriterFlags> flags = EnumSet.noneOf(SessionWriter.SessionWriterFlags.class);
        if (pluginData || Boolean.TRUE.equals(SAVE_PLUGIN_INFORMATION_PROPERTY.get()) && SessionSaveAction.pluginsWantToSave()) {
            flags.add(SessionWriter.SessionWriterFlags.SAVE_PLUGIN_INFORMATION);
        }
        if (isZipSessionFile) {
            flags.add(SessionWriter.SessionWriterFlags.IS_ZIP);
        }
        SessionWriter sw = new SessionWriter(layersOut, active, this.exporters, this.dependencies, flags.toArray(new SessionWriter.SessionWriterFlags[0]));
        try {
            Notification savingNotification = SessionSaveAction.showSavingNotification(sessionFile.getName());
            sw.write(sessionFile);
            SaveActionBase.addToFileOpenHistory(sessionFile);
            if (this.removeFileOnSuccess != null) {
                PreferencesUtils.removeFromList(Config.getPref(), "file-open.history", this.removeFileOnSuccess.getCanonicalPath());
                Files.deleteIfExists(this.removeFileOnSuccess.toPath());
                this.removeFileOnSuccess = null;
            }
            SessionSaveAction.showSavedNotification(savingNotification, sessionFile.getName());
        }
        catch (SecurityException ex2) {
            Logging.error(ex2);
            if (this.removeFileOnSuccess != null) {
                String path = this.removeFileOnSuccess.getPath();
                GuiHelper.runInEDT(() -> {
                    Notification notification = new Notification(I18n.tr("Could not delete file: {0}<br>{1}", path, ex2.getMessage()));
                    notification.setIcon(2);
                    notification.show();
                });
            }
            throw new JosmRuntimeException(ex2);
        }
        catch (IOException ex3) {
            Logging.error(ex3);
            HelpAwareOptionPane.showMessageDialogInEDT(MainApplication.getMainFrame(), I18n.tr("<html>Could not save session file ''{0}''.<br>Error is:<br>{1}</html>", sessionFile.getName(), Utils.escapeReservedCharactersHTML(ex3.getMessage())), I18n.tr("IO Error", new Object[0]), 0, null);
            success = false;
        }
        return success;
    }

    protected boolean doGetFile(boolean saveAs, boolean zipRequired) throws UserCancelException {
        if (!saveAs && sessionFile != null) {
            if (isZipSessionFile || !zipRequired) {
                return true;
            }
            Logging.info("Converting *.jos to *.joz because a new layer has been added that requires zip format");
            String oldPath = sessionFile.getAbsolutePath();
            int i = oldPath.lastIndexOf(46);
            File jozFile = new File(i < 0 ? oldPath : oldPath.substring(0, i) + ".joz");
            if (!jozFile.exists()) {
                this.removeFileOnSuccess = sessionFile;
                SessionSaveAction.setCurrentSession(jozFile, true);
                return true;
            }
            Logging.warn("Asking user to choose a new location for the *.joz file because it already exists");
        }
        this.doGetFileChooser(zipRequired);
        return false;
    }

    protected void doGetFileChooser(boolean zipRequired) throws UserCancelException {
        AbstractFileChooser fc = zipRequired ? SessionSaveAction.createAndOpenFileChooser(false, false, I18n.tr("Save Session", new Object[0]), this.joz, 0, "lastDirectory") : SessionSaveAction.createAndOpenFileChooser(false, false, I18n.tr("Save Session", new Object[0]), Arrays.asList(this.jos, this.joz), this.jos, 0, "lastDirectory");
        if (fc == null) {
            throw new UserCancelException();
        }
        File f = fc.getSelectedFile();
        FileFilter ff = fc.getFileFilter();
        boolean zip = zipRequired || this.joz.equals(ff) ? true : (this.jos.equals(ff) ? false : Utils.hasExtension(f.getName(), "joz"));
        SessionSaveAction.setCurrentSession(f, zip);
    }

    protected void addListeners() {
        MainApplication.addMapFrameListener(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
    }

    protected void removeListeners() {
        MainApplication.removeMapFrameListener(this);
        MainApplication.getLayerManager().removeLayerChangeListener(this);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(MainApplication.isDisplayingMapView());
    }

    @Override
    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.updateEnabledState();
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.isLastLayer()) {
            SessionSaveAction.setCurrentSession(null, false);
        }
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    private static void updateSessionFile(String fileName) throws UserCancelException {
        if (fileName.indexOf(46) == -1 && !SaveActionBase.confirmOverwrite(sessionFile = new File(sessionFile.getPath() + (isZipSessionFile ? ".joz" : ".jos")))) {
            throw new UserCancelException();
        }
    }

    @Deprecated
    public static void setCurrentSession(File file, boolean zip, List<Layer> layers) {
        if (zip) {
            SessionSaveAction.setCurrentSession(file, layers, SessionWriter.SessionWriterFlags.IS_ZIP);
        } else {
            SessionSaveAction.setCurrentSession(file, layers, new SessionWriter.SessionWriterFlags[0]);
        }
    }

    public static void setCurrentSession(File file, List<Layer> layers, SessionWriter.SessionWriterFlags ... flags) {
        EnumSet<SessionWriter.SessionWriterFlags> flagSet = EnumSet.noneOf(SessionWriter.SessionWriterFlags.class);
        flagSet.addAll(Arrays.asList(flags));
        SessionSaveAction.setCurrentSession(file, layers, flagSet);
    }

    public static void setCurrentSession(File file, List<Layer> layers, Set<SessionWriter.SessionWriterFlags> flags) {
        SessionSaveAction.setCurrentLayers(layers);
        SessionSaveAction.setCurrentSession(file, flags.contains((Object)SessionWriter.SessionWriterFlags.IS_ZIP));
        pluginData = flags.contains((Object)SessionWriter.SessionWriterFlags.SAVE_PLUGIN_INFORMATION);
    }

    public static void setCurrentSession(File file, boolean zip) {
        sessionFile = file;
        isZipSessionFile = zip;
        tooltip = file == null ? TOOLTIP_DEFAULT : I18n.tr("Save the current session file \"{0}\".", file.getName());
        SessionSaveAction.getInstance().setTooltip(tooltip);
    }

    public static void setCurrentLayers(List<Layer> layers) {
        layersInSessionFile = layers.stream().filter(AbstractModifiableLayer.class::isInstance).map(WeakReference::new).collect(Collectors.toList());
    }

    public static String getTooltip() {
        return tooltip;
    }

    private static boolean pluginsWantToSave() {
        for (PluginSessionExporter exporter : PluginHandler.load(PluginSessionExporter.class)) {
            if (!exporter.requiresSaving()) continue;
            return true;
        }
        return false;
    }

    static {
        tooltip = TOOLTIP_DEFAULT = I18n.tr("Save the current session.", new Object[0]);
        instance = new SessionSaveAction();
    }

    public class SessionSaveAsDialog
    extends ExtendedDialog {
        public SessionSaveAsDialog() {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Save Session", new Object[0]), I18n.tr("Save As", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.configureContextsensitiveHelp("Action/SessionSaveAs", true);
            this.initialize();
            this.setButtonIcons("save_as", "cancel");
            this.setDefaultButton(1);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(MainApplication.getMainFrame(), new Dimension(450, 450)));
            this.setContent(this.build(), false);
        }

        public final void initialize() {
            SessionSaveAction.this.layers = new ArrayList<Layer>(SessionSaveAction.this.getLayerManager().getLayers());
            SessionSaveAction.this.exporters = new HashMap();
            SessionSaveAction.this.dependencies = new MultiMap();
            HashSet<Layer> noExporter = new HashSet<Layer>();
            for (Layer layer : SessionSaveAction.this.layers) {
                SessionLayerExporter exporter = null;
                try {
                    exporter = SessionWriter.getSessionLayerExporter(layer);
                }
                catch (IllegalArgumentException | JosmRuntimeException e) {
                    Logging.error(e);
                }
                if (exporter != null) {
                    SessionSaveAction.this.exporters.put(layer, exporter);
                    Collection<Layer> deps = exporter.getDependencies();
                    if (deps != null) {
                        SessionSaveAction.this.dependencies.putAll(layer, deps);
                        continue;
                    }
                    SessionSaveAction.this.dependencies.putVoid(layer);
                    continue;
                }
                noExporter.add(layer);
                SessionSaveAction.this.exporters.put(layer, null);
            }
            int numNoExporter = 0;
            while (numNoExporter != noExporter.size()) {
                numNoExporter = noExporter.size();
                this.updateExporters(noExporter);
            }
        }

        private void updateExporters(Collection<Layer> noExporter) {
            for (Layer layer : SessionSaveAction.this.layers) {
                if (noExporter.contains(layer)) continue;
                for (Layer depLayer : SessionSaveAction.this.dependencies.get(layer)) {
                    if (!noExporter.contains(depLayer)) continue;
                    noExporter.add(layer);
                    SessionSaveAction.this.exporters.put(layer, null);
                    return;
                }
            }
        }

        protected final Component build() {
            JPanel op = new JPanel(new GridBagLayout());
            JPanel ip = new JPanel(new GridBagLayout());
            for (Layer layer : SessionSaveAction.this.layers) {
                Component exportPanel;
                SessionLayerExporter exporter = (SessionLayerExporter)SessionSaveAction.this.exporters.get(layer);
                if (exporter == null) {
                    if (!SessionSaveAction.this.exporters.containsKey(layer)) {
                        throw new AssertionError();
                    }
                    exportPanel = this.getDisabledExportPanel(layer);
                } else {
                    exportPanel = exporter.getExportPanel();
                }
                if (exportPanel == null) continue;
                JPanel wrapper = new JPanel(new GridBagLayout());
                wrapper.setBorder(BorderFactory.createEtchedBorder(0));
                wrapper.add(exportPanel, GBC.std().fill(2));
                ip.add((Component)wrapper, GBC.eol().fill(2).insets(2, 2, 4, 2));
            }
            ip.add(GBC.glue(0, 1), GBC.eol().fill(3));
            JScrollPane sp = new JScrollPane(ip);
            sp.setBorder(BorderFactory.createEmptyBorder());
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)sp, GBC.eol().fill());
            JTabbedPane tabs = new JTabbedPane();
            tabs.addTab(I18n.tr("Layers", new Object[0]), p);
            op.add((Component)tabs, GBC.eol().fill());
            JCheckBox chkSaveLocal = new JCheckBox(I18n.tr("Save all local files to disk", new Object[0]), (boolean)SAVE_LOCAL_FILES_PROPERTY.get());
            chkSaveLocal.addChangeListener(l -> SAVE_LOCAL_FILES_PROPERTY.put(chkSaveLocal.isSelected()));
            op.add((Component)chkSaveLocal, GBC.eol());
            if (SessionSaveAction.pluginsWantToSave()) {
                JCheckBox chkSavePlugins = new JCheckBox(I18n.tr("Save plugin information to disk", new Object[0]), (boolean)SAVE_PLUGIN_INFORMATION_PROPERTY.get());
                chkSavePlugins.addChangeListener(l -> SAVE_PLUGIN_INFORMATION_PROPERTY.put(chkSavePlugins.isSelected()));
                chkSavePlugins.setToolTipText(I18n.tr("Plugins may have additional information that can be saved", new Object[0]));
                op.add((Component)chkSavePlugins, GBC.eol());
            }
            return op;
        }

        protected final Component getDisabledExportPanel(Layer layer) {
            JPanel p = new JPanel(new GridBagLayout());
            JCheckBox include = new JCheckBox();
            include.setEnabled(false);
            JLabel lbl = new JLabel(layer.getName(), layer.getIcon(), 10);
            lbl.setToolTipText(I18n.tr("No exporter for this layer", new Object[0]));
            lbl.setLabelFor(include);
            lbl.setEnabled(false);
            p.add((Component)include, GBC.std());
            p.add((Component)lbl, GBC.std());
            p.add(GBC.glue(1, 0), GBC.std().fill(2));
            return p;
        }
    }
}

