/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;
import org.openstreetmap.josm.tools.Utils;

public final class CertificateAmendment {
    private static final EmbeddedCertAmend[] CERT_AMEND = new EmbeddedCertAmend[0];
    private static final NativeCertAmend[] PLATFORM_CERT_AMEND = new NativeCertAmend[]{new NativeCertAmend(Arrays.asList("Government of Netherlands G3", "Staat der Nederlanden Root CA - G3"), "Staat_der_Nederlanden_Root_CA_-_G3.crt", "3c4fb0b95ab8b30032f432b86f535fe172c185d0fd39865837cf36187fa6f428", "https://roottest-g3.pkioverheid.nl"), new NativeCertAmend(Collections.singleton("Certigna"), "Certigna.crt", "e3b6a2db2ed7ce48842f7ac53241c7b71d54144bfb40c11f3f1d0b42f5eea12d", "https://www.certigna.fr"), new NativeCertAmend(Collections.singleton("CA Disig Root R2"), "CA_Disig_Root_R2.pem", "e23d4a036d7b70e9f595b1422079d2b91edfbb1fb651a0633eaa8a9dc5f80703", "https://eidas.disig.sk"), new NativeCertAmend(Arrays.asList("TW Government Root Certification Authority", "Government Root Certification Authority"), "Taiwan_GRCA.pem", "7600295eefe85b9e1fd624db76062aaaae59818a54d2774cd4c0b2c01131e1b3", "https://grca.nat.gov.tw"), new NativeCertAmend(Collections.singleton("MicroSec e-Szigno Root CA 2009"), "Microsec_e-Szigno_Root_CA_2009.pem", "3c5f81fea5fab82c64bfa2eaecafcde8e077fc8620a7cae537163df36edbf378", "https://e-szigno.hu"), new NativeCertAmend(Collections.singleton("AC RAIZ FNMT-RCM"), "AC_RAIZ_FNMT-RCM.pem", "ebc5570c29018c4d67b1aa127baf12f703b4611ebc17b7dab5573894179b93fa", "https://www.sede.fnmt.gob.es")};

    private CertificateAmendment() {
    }

    public static void addMissingCertificates() throws IOException, GeneralSecurityException {
        if (!Config.getPref().getBoolean("tls.add-missing-certificates", true)) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        Path cacertsPath = Paths.get(Utils.getSystemProperty("java.home"), "lib", "security", "cacerts");
        try (InputStream is = Files.newInputStream(cacertsPath, new OpenOption[0]);){
            keyStore.load(is, "changeit".toCharArray());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to load keystore", e);
            return;
        }
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        boolean certificateAdded = false;
        for (EmbeddedCertAmend embeddedCertAmend : CERT_AMEND) {
            try (CachedFile certCF = new CachedFile(embeddedCertAmend.url);){
                X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certCF.getByteContent()));
                if (!CertificateAmendment.checkAndAddCertificate(md, cert, embeddedCertAmend, keyStore)) continue;
                certificateAdded = true;
            }
        }
        try {
            for (CertAmend certAmend : PLATFORM_CERT_AMEND) {
                X509Certificate cert = PlatformManager.getPlatform().getX509Certificate((NativeCertAmend)certAmend);
                if (!CertificateAmendment.checkAndAddCertificate(md, cert, certAmend, keyStore)) continue;
                certificateAdded = true;
            }
        }
        catch (IOException | IllegalStateException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Logging.error(e);
        }
        if (certificateAdded) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(keyStore);
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, tmf.getTrustManagers(), null);
            SSLContext.setDefault(sslContext);
        }
    }

    private static boolean checkAndAddCertificate(MessageDigest md, X509Certificate cert, CertAmend certAmend, KeyStore keyStore) throws CertificateEncodingException, KeyStoreException, InvalidAlgorithmParameterException {
        if (cert != null) {
            String sha256 = Utils.toHexString(md.digest(cert.getEncoded()));
            if (!certAmend.sha256.equals(sha256)) {
                throw new IllegalStateException(I18n.tr("Error adding certificate {0} - certificate fingerprint mismatch. Expected {1}, was {2}", certAmend, certAmend.sha256, sha256));
            }
            if (CertificateAmendment.certificateIsMissing(keyStore, cert)) {
                if (Logging.isDebugEnabled()) {
                    Logging.debug("Adding certificate for TLS connections: " + cert.getSubjectX500Principal().getName());
                }
                String alias = "josm:" + certAmend.filename;
                keyStore.setCertificateEntry(alias, cert);
                return true;
            }
        }
        return false;
    }

    private static boolean certificateIsMissing(KeyStore keyStore, X509Certificate crt) throws KeyStoreException, InvalidAlgorithmParameterException {
        PKIXParameters params = new PKIXParameters(keyStore);
        return params.getTrustAnchors().stream().map(TrustAnchor::getTrustedCert).noneMatch(c -> Objects.equals(crt.getSubjectX500Principal().getName(), c.getSubjectX500Principal().getName()));
    }

    public static class EmbeddedCertAmend
    extends CertAmend {
        private final String url;

        EmbeddedCertAmend(String url, String filename, String sha256) {
            super(filename, sha256);
            this.url = Objects.requireNonNull(url);
        }

        public final String getUrl() {
            return this.url;
        }

        public String toString() {
            return this.url;
        }
    }

    public static class CertAmend {
        private final String filename;
        private final String sha256;

        protected CertAmend(String filename, String sha256) {
            this.filename = Objects.requireNonNull(filename);
            this.sha256 = Objects.requireNonNull(sha256);
        }

        public final String getFilename() {
            return this.filename;
        }

        public final String getSha256() {
            return this.sha256;
        }
    }

    public static class NativeCertAmend
    extends CertAmend {
        private final Collection<String> aliases;
        private final String httpsWebSite;

        NativeCertAmend(Collection<String> aliases, String filename, String sha256, String httpsWebSite) {
            super(filename, sha256);
            this.aliases = Objects.requireNonNull(aliases);
            this.httpsWebSite = Objects.requireNonNull(httpsWebSite);
        }

        public final Collection<String> getNativeAliases() {
            return this.aliases;
        }

        public String getWebSite() {
            return this.httpsWebSite;
        }

        public String toString() {
            return String.join((CharSequence)" / ", this.aliases);
        }
    }
}

