/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.search;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ActionParameter;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ParameterizedAction;
import org.openstreetmap.josm.actions.search.InView;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmData;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchMode;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.SearchDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.ToolbarPreferences;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SearchAction
extends JosmAction
implements ParameterizedAction {
    public static final int DEFAULT_SEARCH_HISTORY_SIZE = 15;
    public static final int MAX_LENGTH_SEARCH_EXPRESSION_DISPLAY = 100;
    private static final String SEARCH_EXPRESSION = "searchExpression";
    private static AutoCompComboBoxModel<SearchSetting> model = new AutoCompComboBoxModel();
    private static JosmComboBoxModel.Preferences prefs = model.prefs(SearchSetting::readFromString, SearchSetting::writeToString);
    private static volatile SearchSetting lastSearch;

    public static Collection<SearchSetting> getSearchHistory() {
        return model.asCollection();
    }

    public static void saveToHistory(SearchSetting s) {
        model.addTopElement(s);
        prefs.save("search.history");
    }

    public static List<String> getSearchExpressionHistory() {
        return prefs.asStringList();
    }

    public SearchAction() {
        super(I18n.tr("Search...", new Object[0]), "dialogs/search", I18n.tr("Search for objects", new Object[0]), Shortcut.registerShortcut("system:find", I18n.tr("Edit: {0}", I18n.tr("Search...", new Object[0])), 70, 5006), true);
        this.setHelpId(HelpUtil.ht("/Action/Search"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        SearchAction.search();
    }

    @Override
    public void actionPerformed(ActionEvent e, Map<String, Object> parameters) {
        if (parameters.get(SEARCH_EXPRESSION) == null) {
            this.actionPerformed(e);
        } else {
            SearchAction.searchWithoutHistory((SearchSetting)parameters.get(SEARCH_EXPRESSION));
        }
    }

    public static SearchSetting showSearchDialog(SearchSetting initialValues) {
        SearchDialog dialog;
        if (initialValues == null) {
            initialValues = new SearchSetting();
        }
        if ((dialog = new SearchDialog(initialValues, model, ExpertToggleAction.isExpert())).showDialog().getValue() != 1) {
            return null;
        }
        SearchSetting searchSettings = dialog.getSearchSettings();
        if (dialog.isAddOnToolbar()) {
            ToolbarPreferences.ActionDefinition aDef = new ToolbarPreferences.ActionDefinition(MainApplication.getMenu().search);
            aDef.getParameters().put(SEARCH_EXPRESSION, searchSettings);
            aDef.setName(Utils.shortenString(searchSettings.text, 100));
            ToolbarPreferences.ActionParser actionParser = new ToolbarPreferences.ActionParser(null);
            String res = actionParser.saveAction(aDef);
            MainApplication.getToolbar().addCustomButton(res, -1, false);
        }
        return searchSettings;
    }

    public static void search() {
        SearchAction.loadPrefs();
        SearchSetting se = SearchAction.showSearchDialog(lastSearch);
        if (se != null) {
            SearchAction.searchWithHistory(se);
        }
    }

    private static void loadPrefs() {
        prefs.load("search.history");
    }

    public static void searchWithHistory(SearchSetting s) {
        SearchAction.saveToHistory(s);
        lastSearch = new SearchSetting(s);
        SearchAction.searchStateless(s);
    }

    public static void searchWithoutHistory(SearchSetting s) {
        lastSearch = new SearchSetting(s);
        SearchAction.searchStateless(s);
    }

    public static void search(String search, SearchMode mode) {
        SearchSetting searchSetting = new SearchSetting();
        searchSetting.text = search;
        searchSetting.mode = mode;
        SearchAction.searchStateless(searchSetting);
    }

    public static void searchStateless(SearchSetting s) {
        SearchTask.newSearchTask(s, new SelectSearchReceiver()).run();
    }

    public static Collection<IPrimitive> searchAndReturn(String search, SearchMode mode) {
        SearchSetting searchSetting = new SearchSetting();
        searchSetting.text = search;
        searchSetting.mode = mode;
        CapturingSearchReceiver receiver = new CapturingSearchReceiver();
        SearchTask.newSearchTask(searchSetting, receiver).run();
        return receiver.result;
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveData() != null);
    }

    @Override
    public List<ActionParameter<?>> getActionParameters() {
        return Collections.singletonList(new SearchSettingsActionParameter(SEARCH_EXPRESSION));
    }

    static {
        SearchAction.loadPrefs();
        SearchCompiler.addMatchFactory(new SearchCompiler.SimpleMatchFactory(){

            @Override
            public Collection<String> getKeywords() {
                return Arrays.asList("inview", "allinview");
            }

            @Override
            public SearchCompiler.Match get(String keyword, boolean caseSensitive, boolean regexSearch, PushbackTokenizer tokenizer) throws SearchParseError {
                switch (keyword) {
                    case "inview": {
                        return new InView(false);
                    }
                    case "allinview": {
                        return new InView(true);
                    }
                }
                throw new IllegalStateException("Not expecting keyword " + keyword);
            }
        });
        model.setSize(Config.getPref().getInt("search.history-size", 15));
    }

    private static class SelectSearchReceiver
    implements SearchReceiver {
        private SelectSearchReceiver() {
        }

        @Override
        public void receiveSearchResult(OsmData<?, ?, ?, ?> ds, Collection<IPrimitive> result, int foundMatches, SearchSetting setting, Component parent) {
            ds.setSelected(result);
            MapFrame map = MainApplication.getMap();
            if (foundMatches == 0) {
                String text = Utils.shortenString(setting.text, 100);
                String msg = setting.mode == SearchMode.replace ? I18n.tr("No match found for ''{0}''", text) : (setting.mode == SearchMode.add ? I18n.tr("Nothing added to selection by searching for ''{0}''", text) : (setting.mode == SearchMode.remove ? I18n.tr("Nothing removed from selection by searching for ''{0}''", text) : (setting.mode == SearchMode.in_selection ? I18n.tr("Nothing found in selection by searching for ''{0}''", text) : null)));
                if (map != null) {
                    map.statusLine.setHelpText(msg);
                }
                if (!GraphicsEnvironment.isHeadless()) {
                    new Notification(msg).show();
                }
            } else {
                map.statusLine.setHelpText(I18n.tr("Found {0} matches", foundMatches));
            }
        }
    }

    static final class SearchTask
    extends PleaseWaitRunnable {
        private final OsmData<?, ?, ?, ?> ds;
        private final SearchSetting setting;
        private final Collection<IPrimitive> selection;
        private final Predicate<IPrimitive> predicate;
        private boolean canceled;
        private int foundMatches;
        private final SearchReceiver resultReceiver;

        private SearchTask(OsmData<?, ?, ?, ?> ds, SearchSetting setting, Collection<IPrimitive> selection, Predicate<IPrimitive> predicate, SearchReceiver resultReceiver) {
            super(I18n.tr("Searching", new Object[0]));
            this.ds = ds;
            this.setting = setting;
            this.selection = selection;
            this.predicate = predicate;
            this.resultReceiver = resultReceiver;
        }

        static SearchTask newSearchTask(SearchSetting setting, SearchReceiver resultReceiver) {
            OsmData<?, ?, ?, ?> ds = MainApplication.getLayerManager().getActiveData();
            if (ds == null) {
                throw new IllegalStateException("No active dataset");
            }
            return SearchTask.newSearchTask(setting, ds, resultReceiver);
        }

        private static SearchTask newSearchTask(SearchSetting setting, OsmData<?, ?, ?, ?> ds, SearchReceiver resultReceiver) {
            HashSet<IPrimitive> selection = new HashSet<IPrimitive>(ds.getAllSelected());
            return new SearchTask(ds, setting, selection, IPrimitive::isSelected, resultReceiver);
        }

        @Override
        protected void cancel() {
            this.canceled = true;
        }

        @Override
        protected void realRun() {
            try {
                this.foundMatches = 0;
                SearchCompiler.Match matcher = SearchCompiler.compile(this.setting);
                if (this.setting.mode == SearchMode.replace) {
                    this.selection.clear();
                } else if (this.setting.mode == SearchMode.in_selection) {
                    this.foundMatches = this.selection.size();
                }
                Collection<Object> all = this.setting.allElements ? this.ds.allPrimitives() : this.ds.getPrimitives(p -> p.isSelectable());
                ProgressMonitor subMonitor = this.getProgressMonitor().createSubTaskMonitor(all.size(), false);
                subMonitor.beginTask(I18n.trn("Searching in {0} object", "Searching in {0} objects", all.size(), all.size()));
                for (IPrimitive iPrimitive : all) {
                    if (this.canceled) {
                        return;
                    }
                    if (this.setting.mode == SearchMode.replace) {
                        if (matcher.match(iPrimitive)) {
                            this.selection.add(iPrimitive);
                            ++this.foundMatches;
                        }
                    } else if (this.setting.mode == SearchMode.add && !this.predicate.test(iPrimitive) && matcher.match(iPrimitive)) {
                        this.selection.add(iPrimitive);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.remove && this.predicate.test(iPrimitive) && matcher.match(iPrimitive)) {
                        this.selection.remove(iPrimitive);
                        ++this.foundMatches;
                    } else if (this.setting.mode == SearchMode.in_selection && this.predicate.test(iPrimitive) && !matcher.match(iPrimitive)) {
                        this.selection.remove(iPrimitive);
                        --this.foundMatches;
                    }
                    subMonitor.worked(1);
                }
                subMonitor.finishTask();
            }
            catch (SearchParseError e) {
                Logging.debug(e);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }

        @Override
        protected void finish() {
            if (this.canceled) {
                return;
            }
            this.resultReceiver.receiveSearchResult(this.ds, this.selection, this.foundMatches, this.setting, this.getProgressMonitor().getWindowParent());
        }
    }

    @FunctionalInterface
    static interface SearchReceiver {
        public void receiveSearchResult(OsmData<?, ?, ?, ?> var1, Collection<IPrimitive> var2, int var3, SearchSetting var4, Component var5);
    }

    private static final class CapturingSearchReceiver
    implements SearchReceiver {
        private Collection<IPrimitive> result;

        private CapturingSearchReceiver() {
        }

        @Override
        public void receiveSearchResult(OsmData<?, ?, ?, ?> ds, Collection<IPrimitive> result, int foundMatches, SearchSetting setting, Component parent) {
            this.result = result;
        }
    }

    public static class SearchSettingsActionParameter
    extends ActionParameter<SearchSetting> {
        public SearchSettingsActionParameter(String name) {
            super(name);
        }

        @Override
        public Class<SearchSetting> getType() {
            return SearchSetting.class;
        }

        @Override
        public SearchSetting readFromString(String s) {
            return SearchSetting.readFromString(s);
        }

        @Override
        public String writeToString(SearchSetting value) {
            if (value == null) {
                return "";
            }
            return value.writeToString();
        }
    }
}

