/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class CommonSettingsPanel
extends JPanel {
    private final JosmComboBox<String> sharpen;
    private final JSlider tilesZoom = new JSlider(-2, 2, 0);

    public CommonSettingsPanel() {
        super(new GridBagLayout());
        this.sharpen = new JosmComboBox<String>(new String[]{I18n.tr("None", new Object[0]), I18n.tr("Soft", new Object[0]), I18n.tr("Strong", new Object[0])});
        this.add(new JLabel(I18n.tr("Sharpen (requires layer re-add): ", new Object[0])));
        this.add(GBC.glue(5, 0), GBC.std().fill(2));
        this.add(this.sharpen, GBC.eol().fill(2));
        this.tilesZoom.setPaintLabels(true);
        this.tilesZoom.setMajorTickSpacing(2);
        this.tilesZoom.setMinorTickSpacing(1);
        this.tilesZoom.setPaintTicks(true);
        this.add(new JLabel(I18n.tr("Tiles zoom offset:", new Object[0])));
        this.add(GBC.glue(5, 0), GBC.std());
        this.add((Component)this.tilesZoom, GBC.eol());
    }

    public void loadSettings() {
        this.sharpen.setSelectedIndex(Utils.clamp(ImageryLayer.PROP_SHARPEN_LEVEL.get(), 0, 2));
        this.tilesZoom.setValue(AbstractTileSourceLayer.ZOOM_OFFSET.get());
    }

    public boolean saveSettings() {
        ImageryLayer.PROP_SHARPEN_LEVEL.put(this.sharpen.getSelectedIndex());
        boolean restartRequired = false;
        if (!AbstractTileSourceLayer.ZOOM_OFFSET.get().equals(this.tilesZoom.getValue())) {
            AbstractTileSourceLayer.ZOOM_OFFSET.put(this.tilesZoom.getValue());
            restartRequired = true;
        }
        return restartRequired;
    }
}

