/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.ChangesetCellRenderer;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.io.DownloadOpenChangesetsTask;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetManagementPanel
extends JPanel
implements ItemListener,
ChangesetCacheListener {
    static final String SELECTED_CHANGESET_PROP = ChangesetManagementPanel.class.getName() + ".selectedChangeset";
    static final String CLOSE_CHANGESET_AFTER_UPLOAD = ChangesetManagementPanel.class.getName() + ".closeChangesetAfterUpload";
    private JosmComboBox<Changeset> cbOpenChangesets;
    private JosmComboBoxModel<Changeset> model;
    private JCheckBox cbCloseAfterUpload;
    private JButton btnClose;

    public ChangesetManagementPanel() {
        this.build();
    }

    public void initLifeCycle() {
        this.refreshChangesets();
    }

    public JosmComboBoxModel<Changeset> getModel() {
        return this.model;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(I18n.tr("Please select a changeset:", new Object[0])));
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        gc.fill = 2;
        gc.anchor = 18;
        gc.insets = new Insets(3, 3, 3, 3);
        gc.gridwidth = 3;
        this.add((Component)new JMultilineLabel(I18n.tr("Please select which changeset the data shall be uploaded to and whether to close that changeset after the next upload.", new Object[0])), gc);
        gc.gridwidth = 1;
        ++gc.gridy;
        this.model = new JosmComboBoxModel();
        this.cbOpenChangesets = new JosmComboBox<Changeset>(this.model);
        this.cbOpenChangesets.setToolTipText(I18n.tr("Select a changeset", new Object[0]));
        this.cbOpenChangesets.setRenderer(new ChangesetCellRenderer());
        Dimension d = this.cbOpenChangesets.getPreferredSize();
        d.width = 200;
        this.cbOpenChangesets.setPreferredSize(d);
        d.width = 100;
        this.cbOpenChangesets.setMinimumSize(d);
        this.add(this.cbOpenChangesets, gc);
        int h = this.cbOpenChangesets.getPreferredSize().height;
        Dimension prefSize = new Dimension(h, h);
        ++gc.gridx;
        gc.weightx = 0.0;
        JButton btnRefresh = new JButton(new RefreshAction());
        btnRefresh.setPreferredSize(prefSize);
        btnRefresh.setMinimumSize(prefSize);
        this.add((Component)btnRefresh, gc);
        ++gc.gridx;
        CloseChangesetAction closeChangesetAction = new CloseChangesetAction();
        this.btnClose = new JButton(closeChangesetAction);
        this.btnClose.setPreferredSize(prefSize);
        this.btnClose.setMinimumSize(prefSize);
        this.add((Component)this.btnClose, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.gridwidth = 3;
        gc.weightx = 1.0;
        this.cbCloseAfterUpload = new JCheckBox(I18n.tr("Close changeset after upload", new Object[0]));
        this.cbCloseAfterUpload.setToolTipText(I18n.tr("Select to close the changeset after the next upload", new Object[0]));
        this.add((Component)this.cbCloseAfterUpload, gc);
        this.cbOpenChangesets.addItemListener(this);
        this.cbOpenChangesets.addItemListener(closeChangesetAction);
        this.cbCloseAfterUpload.setSelected(Config.getPref().getBoolean("upload.changeset.close", true));
        this.cbCloseAfterUpload.addItemListener(new CloseAfterUploadItemStateListener());
        ChangesetCache.getInstance().addChangesetCacheListener(this);
    }

    public void setSelectedChangesetForNextUpload(Changeset cs) {
        this.model.setSelectedItem(cs);
    }

    public Changeset getSelectedChangeset() {
        return Optional.ofNullable((Changeset)this.model.getSelectedItem()).orElse(new Changeset());
    }

    public boolean isCloseChangesetAfterUpload() {
        return this.cbCloseAfterUpload.isSelected();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.firePropertyChange(SELECTED_CHANGESET_PROP, null, this.model.getSelectedItem());
    }

    protected void refreshChangesets() {
        try {
            ChangesetCache.getInstance().refreshChangesetsFromServer();
        }
        catch (OsmTransferException e) {
            return;
        }
    }

    private void refreshCombo() {
        Changeset selected = (Changeset)this.cbOpenChangesets.getSelectedItem();
        this.model.removeAllElements();
        this.model.addElement(new Changeset());
        this.model.addAllElements(ChangesetCache.getInstance().getOpenChangesetsForCurrentUser());
        this.cbOpenChangesets.setSelectedItem(selected != null && this.model.getIndexOf(selected) != -1 ? selected : this.model.getElementAt(0));
    }

    @Override
    public void changesetCacheUpdated(ChangesetCacheEvent event) {
        SwingUtilities.invokeLater(() -> this.refreshCombo());
    }

    class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            this.putValue("ShortDescription", I18n.tr("Load the list of your open changesets from the server", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainApplication.worker.submit(new DownloadOpenChangesetsTask(ChangesetManagementPanel.this));
        }
    }

    class CloseChangesetAction
    extends AbstractAction
    implements ItemListener {
        CloseChangesetAction() {
            new ImageProvider("closechangeset").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", I18n.tr("Close the currently selected open changeset", new Object[0]));
            this.refreshEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Changeset cs = (Changeset)ChangesetManagementPanel.this.cbOpenChangesets.getSelectedItem();
            if (cs == null) {
                return;
            }
            MainApplication.worker.submit(new CloseChangesetTask(Collections.singletonList(cs)));
        }

        protected void refreshEnabledState() {
            this.setEnabled(!ChangesetManagementPanel.this.getSelectedChangeset().isNew());
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.refreshEnabledState();
        }
    }

    class CloseAfterUploadItemStateListener
    implements ItemListener {
        CloseAfterUploadItemStateListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getItemSelectable() != ChangesetManagementPanel.this.cbCloseAfterUpload) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    ChangesetManagementPanel.this.firePropertyChange(CLOSE_CHANGESET_AFTER_UPLOAD, false, true);
                    Config.getPref().putBoolean("upload.changeset.close", true);
                    break;
                }
                case 2: {
                    ChangesetManagementPanel.this.firePropertyChange(CLOSE_CHANGESET_AFTER_UPLOAD, true, false);
                    Config.getPref().putBoolean("upload.changeset.close", false);
                    break;
                }
            }
        }
    }
}

