/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.IntStream;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.QuadTiling;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class QuadBuckets<T extends IQuadBucketType>
implements Collection<T> {
    private static final boolean CONSISTENCY_TESTING = false;
    private static final byte NW_INDEX = 1;
    private static final byte NE_INDEX = 3;
    private static final byte SE_INDEX = 2;
    private static final byte SW_INDEX = 0;
    private static final int MAX_OBJECTS_PER_NODE = 48;
    private QBLevel<T> root;
    private QBLevel<T> searchCache;
    private int size;
    private Collection<T> invalidBBoxPrimitives;

    static void abort(String s) {
        throw new AssertionError((Object)s);
    }

    public QuadBuckets() {
        this.clear();
    }

    @Override
    public final void clear() {
        this.root = new QBLevel();
        this.invalidBBoxPrimitives = new LinkedHashSet<T>();
        this.searchCache = null;
        this.size = 0;
    }

    @Override
    public boolean add(T n) {
        if (n.getBBox().isValid()) {
            this.root.add(n);
        } else {
            this.invalidBBoxPrimitives.add(n);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        for (IQuadBucketType o : this) {
            if (objects.contains(o) || this.remove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return objects.stream().map(this::remove).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public boolean addAll(Collection<? extends T> objects) {
        return objects.stream().map(this::add).reduce(false, (a, b) -> a != false || b != false);
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return objects.stream().allMatch(this::contains);
    }

    @Override
    public boolean remove(Object o) {
        IQuadBucketType t = (IQuadBucketType)o;
        this.searchCache = null;
        QBLevel<IQuadBucketType> bucket = this.root.findBucket(t.getBBox());
        boolean removed = bucket.removeContent(t);
        if (!removed) {
            removed = this.invalidBBoxPrimitives.remove(o);
        }
        if (removed) {
            --this.size;
        }
        return removed;
    }

    @Override
    public boolean contains(Object o) {
        IQuadBucketType t = (IQuadBucketType)o;
        if (!t.getBBox().isValid()) {
            return this.invalidBBoxPrimitives.contains(o);
        }
        QBLevel<T> bucket = this.root.findBucket(t.getBBox());
        return bucket != null && ((QBLevel)bucket).content != null && ((QBLevel)bucket).content.contains(t);
    }

    public List<T> toList() {
        return new ArrayList(this);
    }

    @Override
    public Object[] toArray() {
        return this.stream().toArray();
    }

    @Override
    public <A> A[] toArray(A[] template) {
        return this.toList().toArray(template);
    }

    @Override
    public Iterator<T> iterator() {
        return new QuadBucketIterator(this);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public List<T> search(BBox searchBbox) {
        ArrayList ret = new ArrayList();
        if (searchBbox == null || !searchBbox.isValid()) {
            return ret;
        }
        if (this.searchCache == null) {
            this.searchCache = this.root;
        }
        while (this.searchCache != null && !this.searchCache.bounds(searchBbox)) {
            this.searchCache = ((QBLevel)this.searchCache).parent;
        }
        if (this.searchCache == null) {
            this.searchCache = this.root;
            Logging.info("bbox: " + searchBbox + " is out of the world");
        }
        QBLevel tmp = ((QBLevel)this.searchCache).parent;
        ((QBLevel)this.searchCache).search(this, searchBbox, ret);
        while (tmp != null) {
            tmp.searchContents(searchBbox, ret);
            tmp = tmp.parent;
        }
        return ret;
    }

    static class QBLevel<T extends IQuadBucketType>
    extends BBox {
        private final byte level;
        private final byte index;
        private final long quad;
        private final QBLevel<T> parent;
        private boolean isLeaf = true;
        private List<T> content;
        private QBLevel<T> nw;
        private QBLevel<T> ne;
        private QBLevel<T> sw;
        private QBLevel<T> se;

        private QBLevel<T> getChild(byte index) {
            switch (index) {
                case 3: {
                    if (this.ne == null) {
                        this.ne = new QBLevel<T>(this, index);
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.nw == null) {
                        this.nw = new QBLevel<T>(this, index);
                    }
                    return this.nw;
                }
                case 2: {
                    if (this.se == null) {
                        this.se = new QBLevel<T>(this, index);
                    }
                    return this.se;
                }
                case 0: {
                    if (this.sw == null) {
                        this.sw = new QBLevel<T>(this, index);
                    }
                    return this.sw;
                }
            }
            return null;
        }

        private QBLevel<T>[] getChildren() {
            return new QBLevel[]{this.sw, this.nw, this.se, this.ne};
        }

        @Override
        public String toString() {
            return super.toString() + '[' + this.level + "]: ";
        }

        QBLevel() {
            super(-180.0, 90.0, 180.0, -90.0);
            this.level = 0;
            this.index = 0;
            this.quad = 0L;
            this.parent = null;
        }

        QBLevel(QBLevel<T> parent, byte index) {
            this.parent = parent;
            this.level = (byte)(parent.level + 1);
            this.index = index;
            int shift = (24 - this.level) * 2;
            long quadpart = (long)index << shift;
            this.quad = parent.quad | quadpart;
            LatLon bottomLeft = QuadTiling.tile2LatLon(this.quad);
            this.xmin = bottomLeft.lon();
            this.ymin = bottomLeft.lat();
            this.xmax = this.xmin + parent.width() / 2.0;
            this.ymax = this.ymin + parent.height() / 2.0;
        }

        QBLevel<T> findBucket(BBox bbox) {
            if (!this.hasChildren()) {
                return this;
            }
            byte idx = bbox.getIndex(this.level);
            if (idx == -1) {
                return this;
            }
            QBLevel<T> child = this.getChild(idx);
            if (child == null) {
                return this;
            }
            return child.findBucket(bbox);
        }

        boolean removeContent(T o) {
            if (this.content == null) {
                return false;
            }
            boolean ret = this.content.remove(o);
            if (this.content.isEmpty()) {
                this.content = null;
            }
            if (this.canRemove()) {
                this.removeFromParent();
            }
            return ret;
        }

        void doSplit() {
            List<T> tmpcontent = this.content;
            this.content = null;
            for (IQuadBucketType o : tmpcontent) {
                byte idx = o.getBBox().getIndex(this.level);
                if (idx == -1) {
                    this.doAddContent(o);
                    continue;
                }
                QBLevel<IQuadBucketType> child = this.getChild(idx);
                if (child == null) continue;
                child.doAdd(o);
            }
            this.isLeaf = false;
        }

        boolean doAddContent(T o) {
            if (this.content == null) {
                this.content = new ArrayList<T>();
            }
            return this.content.add(o);
        }

        boolean matches(T o, BBox searchBbox) {
            return o.getBBox().intersects(searchBbox);
        }

        private void searchContents(BBox searchBbox, List<T> result) {
            if (this.content == null) {
                return;
            }
            for (IQuadBucketType o : this.content) {
                if (!this.matches(o, searchBbox)) continue;
                result.add(o);
            }
        }

        boolean isLeaf() {
            return this.isLeaf;
        }

        boolean hasChildren() {
            return this.nw != null || this.ne != null || this.sw != null || this.se != null;
        }

        QBLevel<T> findNextSibling() {
            return this.parent == null ? null : this.parent.firstSiblingOf(this);
        }

        boolean hasContent() {
            return this.content != null;
        }

        QBLevel<T> nextSibling() {
            QBLevel<T> next = this;
            QBLevel<T> sibling = next.findNextSibling();
            while (sibling == null && (next = next.parent) != null) {
                sibling = next.findNextSibling();
            }
            return sibling;
        }

        QBLevel<T> firstChild() {
            if (this.sw != null) {
                return this.sw;
            }
            if (this.nw != null) {
                return this.nw;
            }
            if (this.se != null) {
                return this.se;
            }
            return this.ne;
        }

        QBLevel<T> firstSiblingOf(QBLevel<T> child) {
            switch (child.index) {
                case 0: {
                    if (this.nw != null) {
                        return this.nw;
                    }
                    if (this.se != null) {
                        return this.se;
                    }
                    return this.ne;
                }
                case 1: {
                    if (this.se != null) {
                        return this.se;
                    }
                    return this.ne;
                }
                case 2: {
                    return this.ne;
                }
            }
            return null;
        }

        QBLevel<T> nextNode() {
            if (!this.hasChildren()) {
                return this.nextSibling();
            }
            return this.firstChild();
        }

        QBLevel<T> nextContentNode() {
            QBLevel<T> next = this.nextNode();
            if (next == null) {
                return next;
            }
            if (next.hasContent()) {
                return next;
            }
            return next.nextContentNode();
        }

        void doAdd(T o) {
            this.doAddContent(o);
            if (this.level < 24 && this.isLeaf() && this.content.size() > 48) {
                this.doSplit();
            }
        }

        void add(T o) {
            this.findBucket(o.getBBox()).doAdd(o);
        }

        private void search(QuadBuckets<T> buckets, BBox searchBbox, List<T> result) {
            if (!this.intersects(searchBbox)) {
                return;
            }
            if (this.bounds(searchBbox)) {
                ((QuadBuckets)buckets).searchCache = this;
            }
            if (this.hasContent()) {
                this.searchContents(searchBbox, result);
            }
            if (this.nw != null) {
                super.search(buckets, searchBbox, result);
            }
            if (this.ne != null) {
                super.search(buckets, searchBbox, result);
            }
            if (this.se != null) {
                super.search(buckets, searchBbox, result);
            }
            if (this.sw != null) {
                super.search(buckets, searchBbox, result);
            }
        }

        public String quads() {
            return Long.toHexString(this.quad);
        }

        int indexOf(QBLevel<T> findThis) {
            QBLevel[] children = this.getChildren();
            return IntStream.range(0, 4).filter(i -> children[i] == findThis).findFirst().orElse(-1);
        }

        void removeFromParent() {
            if (this.parent == null) {
                return;
            }
            if (!this.canRemove()) {
                QuadBuckets.abort("attempt to remove non-empty child: " + this.content + ' ' + Arrays.toString(this.getChildren()));
            }
            if (this.parent.nw == this) {
                this.parent.nw = null;
            } else if (this.parent.ne == this) {
                this.parent.ne = null;
            } else if (this.parent.sw == this) {
                this.parent.sw = null;
            } else if (this.parent.se == this) {
                this.parent.se = null;
            }
            if (this.parent.canRemove()) {
                this.parent.removeFromParent();
            }
        }

        boolean canRemove() {
            return Utils.isEmpty(this.content) && !this.hasChildren();
        }
    }

    class QuadBucketIterator
    implements Iterator<T> {
        private QBLevel<T> currentNode;
        private int contentIndex;
        private final Iterator<T> invalidBBoxIterator;
        boolean fromInvalidBBoxPrimitives;
        QuadBuckets<T> qb;

        final QBLevel<T> nextContentNode(QBLevel<T> q) {
            if (q == null) {
                return null;
            }
            QBLevel orig = q;
            QBLevel next = q.nextContentNode();
            if (orig == next) {
                QuadBuckets.abort("got same leaf back leaf: " + q.isLeaf());
            }
            return next;
        }

        QuadBucketIterator(QuadBuckets<T> qb) {
            this.invalidBBoxIterator = QuadBuckets.this.invalidBBoxPrimitives.iterator();
            this.currentNode = !qb.root.hasChildren() || qb.root.hasContent() ? qb.root : this.nextContentNode(qb.root);
            this.qb = qb;
        }

        @Override
        public boolean hasNext() {
            if (this.peek() == null) {
                this.fromInvalidBBoxPrimitives = true;
                return this.invalidBBoxIterator.hasNext();
            }
            return true;
        }

        T peek() {
            if (this.currentNode == null) {
                return null;
            }
            while (this.currentNode.content == null || this.contentIndex >= this.currentNode.content.size()) {
                this.contentIndex = 0;
                this.currentNode = this.nextContentNode(this.currentNode);
                if (this.currentNode != null) continue;
            }
            if (this.currentNode == null || this.currentNode.content == null) {
                return null;
            }
            return (IQuadBucketType)this.currentNode.content.get(this.contentIndex);
        }

        @Override
        public T next() {
            if (this.fromInvalidBBoxPrimitives) {
                return (IQuadBucketType)this.invalidBBoxIterator.next();
            }
            Object ret = this.peek();
            if (ret == null) {
                throw new NoSuchElementException();
            }
            ++this.contentIndex;
            return ret;
        }

        @Override
        public void remove() {
            if (this.fromInvalidBBoxPrimitives) {
                this.invalidBBoxIterator.remove();
                this.qb.size--;
            } else {
                --this.contentIndex;
                Object object = this.peek();
                if (this.currentNode.removeContent(object)) {
                    this.qb.size--;
                }
            }
        }
    }
}

