/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.io.IOException;
import java.net.UnknownHostException;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheElementSerialized;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.net.HostNameUtil;
import org.apache.commons.jcs3.utils.serialization.SerializationConversionUtil;

public abstract class AbstractRemoteCacheListener<K, V>
implements IRemoteCacheListener<K, V> {
    private static final Log log = LogManager.getLog(AbstractRemoteCacheListener.class);
    private static String localHostName = null;
    private final ICompositeCacheManager cacheMgr;
    private final IRemoteCacheAttributes irca;
    private long listenerId = 0L;
    private final IElementSerializer elementSerializer;

    public AbstractRemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr, IElementSerializer elementSerializer) {
        this.irca = irca;
        this.cacheMgr = cacheMgr;
        this.elementSerializer = elementSerializer;
    }

    @Override
    public void setListenerId(long id) throws IOException {
        this.listenerId = id;
        log.info("set listenerId = [{0}]", id);
    }

    @Override
    public long getListenerId() throws IOException {
        log.debug("get listenerId = [{0}]", this.listenerId);
        return this.listenerId;
    }

    @Override
    public RemoteType getRemoteType() throws IOException {
        log.debug("getRemoteType = [{0}]", () -> this.irca.getRemoteType());
        return this.irca.getRemoteType();
    }

    @Override
    public void handlePut(ICacheElement<K, V> cb) throws IOException {
        if (this.irca.getRemoveUponRemotePut()) {
            log.debug("PUTTING ELEMENT FROM REMOTE, (  invalidating ) ");
            this.handleRemove(cb.getCacheName(), cb.getKey());
        } else {
            log.debug("PUTTING ELEMENT FROM REMOTE, ( updating ) ");
            log.debug("cb = {0}", cb);
            if (cb instanceof ICacheElementSerialized) {
                log.debug("Object needs to be deserialized.");
                try {
                    cb = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)cb, this.elementSerializer);
                    log.debug("Deserialized result = {0}", cb);
                }
                catch (IOException e) {
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    log.error("Received a serialized version of a class that we don't know about.", e);
                }
            }
            this.getCacheManager().getCache(cb.getCacheName()).localUpdate(cb);
        }
    }

    @Override
    public void handleRemove(String cacheName, K key) throws IOException {
        log.debug("handleRemove> cacheName={0}, key={1}", cacheName, key);
        this.getCacheManager().getCache(cacheName).localRemove(key);
    }

    @Override
    public void handleRemoveAll(String cacheName) throws IOException {
        log.debug("handleRemoveAll> cacheName={0}", cacheName);
        this.getCacheManager().getCache(cacheName).localRemoveAll();
    }

    @Override
    public void handleDispose(String cacheName) throws IOException {
        log.debug("handleDispose> cacheName={0}", cacheName);
    }

    protected ICompositeCacheManager getCacheManager() {
        return this.cacheMgr;
    }

    @Override
    public synchronized String getLocalHostAddress() throws IOException {
        if (localHostName == null) {
            try {
                localHostName = HostNameUtil.getLocalHostAddress();
            }
            catch (UnknownHostException uhe) {
                localHostName = "unknown";
            }
        }
        return localHostName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n AbstractRemoteCacheListener: ").append("\n RemoteHost = ").append(this.irca.getRemoteLocation()).append("\n ListenerId = ").append(this.listenerId);
        return buf.toString();
    }
}

