/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BadParseException;
import lpg.runtime.BadParseSymFileException;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.NotDeterministicParseTableException;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import lpg.runtime.Stacks;
import lpg.runtime.TokenStream;
import lpg.runtime.UnavailableParserInformationException;

public class DeterministicParser
extends Stacks {
    private boolean taking_actions = false;
    private int markerKind = 0;
    private Monitor monitor;
    private int START_STATE;
    private int NUM_RULES;
    private int NT_OFFSET;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int ERROR_SYMBOL;
    private int lastToken;
    private int currentAction;
    private IntTuple action = null;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;

    private int lookahead(int act, int token) {
        return (act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, this.tokStream.getKind(token))) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.getNext(token)) : act;
    }

    private int tAction(int act, int sym) {
        return (act = this.prs.tAction(act, sym)) > this.LA_STATE_OFFSET ? this.lookahead(act, this.tokStream.peek()) : act;
    }

    private int tAction(int act, int[] sym, int index) {
        act = this.prs.tAction(act, sym[index]);
        while (act > this.LA_STATE_OFFSET) {
            index = (index + 1) % sym.length;
            act = this.prs.lookAhead(act - this.LA_STATE_OFFSET, sym[index]);
        }
        return act;
    }

    private final void processReductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    public final int getCurrentRule() {
        if (this.taking_actions) {
            return this.currentAction;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getFirstToken() {
        if (this.taking_actions) {
            return this.getToken(1);
        }
        throw new UnavailableParserInformationException();
    }

    public final int getFirstToken(int i) {
        if (this.taking_actions) {
            return this.getToken(i);
        }
        throw new UnavailableParserInformationException();
    }

    public final int getLastToken() {
        if (this.taking_actions) {
            return this.lastToken;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getLastToken(int i) {
        if (this.taking_actions) {
            return i >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(i + 1));
        }
        throw new UnavailableParserInformationException();
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void reset() {
        this.taking_actions = false;
        this.markerKind = 0;
        if (this.action != null) {
            this.action.reset();
        }
    }

    public void reset(Monitor monitor, TokenStream tokStream) {
        this.monitor = monitor;
        this.tokStream = tokStream;
        this.reset();
    }

    public void reset(TokenStream tokStream) {
        this.reset(null, tokStream);
    }

    public void reset(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(monitor, tokStream);
        this.prs = prs;
        this.ra = ra;
        this.START_STATE = prs.getStartState();
        this.NUM_RULES = prs.getNumRules();
        this.NT_OFFSET = prs.getNtOffset();
        this.LA_STATE_OFFSET = prs.getLaStateOffset();
        this.EOFT_SYMBOL = prs.getEoftSymbol();
        this.ERROR_SYMBOL = prs.getErrorSymbol();
        this.ACCEPT_ACTION = prs.getAcceptAction();
        this.ERROR_ACTION = prs.getErrorAction();
        if (!prs.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (prs.getBacktrack()) {
            throw new NotDeterministicParseTableException();
        }
    }

    public void reset(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(null, tokStream, prs, ra);
    }

    public DeterministicParser() {
    }

    public DeterministicParser(TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(null, tokStream, prs, ra);
    }

    public DeterministicParser(Monitor monitor, TokenStream tokStream, ParseTable prs, RuleAction ra) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(monitor, tokStream, prs, ra);
    }

    public Object parse() throws BadParseException {
        return this.parseEntry(0);
    }

    public Object parseEntry(int marker_kind) throws BadParseException {
        int current_kind;
        int curtok;
        this.taking_actions = true;
        this.tokStream.reset();
        this.lastToken = this.tokStream.getPrevious(this.tokStream.peek());
        if (marker_kind == 0) {
            curtok = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(curtok);
        } else {
            curtok = this.lastToken;
            current_kind = marker_kind;
        }
        this.reallocateStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                this.taking_actions = false;
                return null;
            }
            try {
                this.stateStack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException e2) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = this.currentAction;
            }
            this.locationStack[this.stateStackTop] = curtok;
            this.currentAction = this.tAction(this.currentAction, current_kind);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.processReductions();
                continue;
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.lastToken = curtok;
                curtok = this.tokStream.getToken();
                current_kind = this.tokStream.getKind(curtok);
                this.currentAction -= this.ERROR_ACTION;
                this.processReductions();
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.lastToken = curtok;
            curtok = this.tokStream.getToken();
            current_kind = this.tokStream.getKind(curtok);
        }
        this.taking_actions = false;
        if (this.currentAction == this.ERROR_ACTION) {
            throw new BadParseException(curtok);
        }
        return this.parseStack[marker_kind == 0 ? 0 : 1];
    }

    public void resetParser() {
        this.resetParserEntry(0);
    }

    public void resetParserEntry(int marker_kind) {
        this.markerKind = marker_kind;
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        if (this.action == null) {
            this.action = new IntTuple(0x100000);
        } else {
            this.action.reset();
        }
        this.taking_actions = false;
        if (marker_kind != 0) {
            int[] sym = new int[]{this.markerKind};
            this.parse(sym, 0);
        }
    }

    private boolean recoverableState(int state) {
        int k = this.prs.asi(state);
        while (this.prs.asr(k) != 0) {
            if (this.prs.asr(k) == this.ERROR_SYMBOL) {
                return true;
            }
            ++k;
        }
        return false;
    }

    public void errorReset() {
        int gate;
        int n = gate = this.markerKind == 0 ? 0 : 1;
        while (this.stateStackTop >= gate && !this.recoverableState(this.stateStack[this.stateStackTop])) {
            --this.stateStackTop;
        }
        if (this.stateStackTop < gate) {
            this.resetParserEntry(this.markerKind);
        }
    }

    public int parse(int[] sym, int index) {
        int save_action_length = this.action.size();
        int pos = this.stateStackTop;
        int location_top = this.stateStackTop - 1;
        this.currentAction = this.tAction(this.stateStack[this.stateStackTop], sym, index);
        while (this.currentAction <= this.NUM_RULES) {
            this.action.add(this.currentAction);
            do {
                int state = (location_top -= this.prs.rhs(this.currentAction) - 1) > pos ? this.locationStack[location_top] : this.stateStack[location_top];
                this.currentAction = this.prs.ntAction(state, this.prs.lhs(this.currentAction));
            } while (this.currentAction <= this.NUM_RULES);
            pos = pos < location_top ? pos : location_top;
            try {
                this.locationStack[location_top + 1] = this.currentAction;
            }
            catch (IndexOutOfBoundsException e2) {
                this.reallocateStacks();
                this.locationStack[location_top + 1] = this.currentAction;
            }
            this.currentAction = this.tAction(this.currentAction, sym, index);
        }
        if (this.currentAction > this.ERROR_ACTION || this.currentAction < this.ACCEPT_ACTION) {
            this.action.add(this.currentAction);
            this.stateStackTop = location_top + 1;
            for (int i = pos + 1; i <= this.stateStackTop; ++i) {
                this.stateStack[i] = this.locationStack[i];
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.currentAction -= this.ERROR_ACTION;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
                } while (this.currentAction <= this.NUM_RULES);
            }
            try {
                this.stateStack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException e3) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = this.currentAction;
            }
        } else if (this.currentAction == this.ERROR_ACTION) {
            this.action.reset(save_action_length);
        }
        return this.currentAction;
    }

    public Object parseActions() throws BadParseException {
        this.taking_actions = true;
        this.tokStream.reset();
        this.lastToken = this.tokStream.getPrevious(this.tokStream.peek());
        int curtok = this.markerKind == 0 ? this.tokStream.getToken() : this.lastToken;
        try {
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            for (int i = 0; i < this.action.size(); ++i) {
                if (this.monitor != null && this.monitor.isCancelled()) {
                    this.taking_actions = false;
                    return null;
                }
                this.stateStack[++this.stateStackTop] = this.currentAction;
                this.locationStack[this.stateStackTop] = curtok;
                this.currentAction = this.action.get(i);
                if (this.currentAction <= this.NUM_RULES) {
                    --this.stateStackTop;
                    this.processReductions();
                    continue;
                }
                this.lastToken = curtok;
                curtok = this.tokStream.getToken();
                if (this.currentAction <= this.ERROR_ACTION) continue;
                this.currentAction -= this.ERROR_ACTION;
                this.processReductions();
            }
        }
        catch (Throwable e2) {
            this.taking_actions = false;
            throw new BadParseException(curtok);
        }
        this.taking_actions = false;
        this.action = null;
        return this.parseStack[this.markerKind == 0 ? 0 : 1];
    }
}

