/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.WhirlpoolDigest;
import shared.uncaughtexception;

public class CryptHashes {
    public static byte[] GetMd5(byte[] inputData) {
        MD5Digest d = new MD5Digest();
        byte[] result = new byte[d.getDigestSize()];
        d.update(inputData, 0, inputData.length);
        d.doFinal(result, 0);
        return result;
    }

    public static byte[] GetHash(byte[] inputData, Hashtype type) {
        ByteArrayInputStream in = new ByteArrayInputStream(inputData);
        byte[] result = CryptHashes.GetHash(in, type);
        return result;
    }

    public static byte[] GetHash(String filename, Hashtype type) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            byte[] result = CryptHashes.GetHash(in, type);
            in.close();
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e2) {
            throw new uncaughtexception("Problem opening/closing input file for hash.");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    public static byte[] GetHash(InputStream in, Hashtype type) {
        ExtendedDigest d;
        switch (type) {
            case md5: {
                MD5Digest d4 = new MD5Digest();
                d = d4;
                break;
            }
            case whirlpool: {
                WhirlpoolDigest d3 = new WhirlpoolDigest();
                d = d3;
                break;
            }
            case sha1: {
                SHA1Digest d2 = new SHA1Digest();
                d = d2;
                break;
            }
            default: {
                throw new uncaughtexception("Unhandled hash type in GetHash.");
            }
        }
        byte[] result = new byte[d.getDigestSize()];
        int read = 0;
        byte[] buffer = new byte[1024];
        while (read != -1) {
            try {
                read = in.read(buffer);
            }
            catch (Exception e2) {
                throw new uncaughtexception("Problem reading from stream for hash.");
            }
            if (read <= 0) continue;
            d.update(buffer, 0, read);
        }
        d.doFinal(result, 0);
        return result;
    }

    public static byte[] GetWhirlpool(String filename) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(filename);
            byte[] result = CryptHashes.GetWhirlpool(in);
            in.close();
            byte[] byArray = result;
            return byArray;
        }
        catch (Exception e2) {
            throw new uncaughtexception("Problem opening/closing input file for Whirlpool hash.");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e3) {}
        }
    }

    public static byte[] GetWhirlpool(InputStream in) {
        WhirlpoolDigest d = new WhirlpoolDigest();
        byte[] result = new byte[d.getDigestSize()];
        int read = 0;
        byte[] buffer = new byte[1024];
        while (read != -1) {
            try {
                read = in.read(buffer);
            }
            catch (Exception e2) {
                throw new uncaughtexception("Problem reading from stream for Whirlpool hash.");
            }
            if (read <= 0) continue;
            d.update(buffer, 0, read);
        }
        d.doFinal(result, 0);
        return result;
    }

    public static byte[] GetWhirlpool(byte[] inputData) {
        WhirlpoolDigest d = new WhirlpoolDigest();
        byte[] result = new byte[d.getDigestSize()];
        d.update(inputData, 0, inputData.length);
        d.doFinal(result, 0);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Hashtype {
        md5,
        sha1,
        whirlpool;

    }
}

