/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import auto.AllGames;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import prpobjects.Urustring;
import prpobjects.uruobj;
import pythondec.pycfile;
import shared.ByteArrayBytestream;
import shared.FileUtils;
import shared.Format;
import shared.IBytestream;
import shared.b;
import shared.m;
import uru.Bytedeque;
import uru.UruCrypt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class pakfile
extends uruobj {
    private int objectcount;
    public ArrayList<IndexEntry> indices = new ArrayList();
    public ArrayList<PythonObject> objects = new ArrayList();
    int pythonversion;

    public void packPakFile(String inputFolder) {
        File inputDir = new File(inputFolder);
        File[] files = inputDir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File curfile = files[i];
            String curfilename = curfile.getName();
            if (!curfilename.endsWith(".pyc")) continue;
            String internalName = curfilename.substring(0, curfilename.length() - 5);
        }
    }

    public PythonObject findByFilename(String filename) {
        for (int i = 0; i < this.indices.size(); ++i) {
            if (!this.indices.get((int)i).objectname.toString().equals(filename)) continue;
            return this.objects.get(i);
        }
        return null;
    }

    public List<pycfile> extractPakFile(boolean prependPYCHeader) {
        ArrayList<pycfile> r = new ArrayList<pycfile>();
        for (int i = 0; i < this.indices.size(); ++i) {
            byte[] rawdata = this.objects.get((int)i).rawCompiledPythonObjectData;
            String name = this.indices.get((int)i).objectname.toString();
            if (prependPYCHeader) {
                byte[] header = null;
                if (this.pythonversion == 22) {
                    header = new byte[]{45, -19, 13, 10, 0, 0, 0, 0};
                } else if (this.pythonversion == 23) {
                    header = new byte[]{59, -14, 13, 10, 0, 0, 0, 0};
                } else {
                    m.err("unhandled python version in extractPakFile");
                }
                rawdata = b.appendBytes(header, rawdata);
            }
            ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(rawdata);
            pycfile pyc = new pycfile(c);
            pyc.filename = name;
            r.add(pyc);
        }
        return r;
    }

    public void extractPakFile(boolean prependPYCHeader, String outfolder) {
        for (int i = 0; i < this.indices.size(); ++i) {
            String filename;
            byte[] rawdata = this.objects.get((int)i).rawCompiledPythonObjectData;
            String name = this.indices.get((int)i).objectname.toString();
            if (prependPYCHeader) {
                byte[] header = null;
                if (this.pythonversion == 22) {
                    header = new byte[]{45, -19, 13, 10, 0, 0, 0, 0};
                } else if (this.pythonversion == 23) {
                    header = new byte[]{59, -14, 13, 10, 0, 0, 0, 0};
                } else {
                    m.err("unhandled python version in extractPakFile");
                }
                rawdata = b.appendBytes(header, rawdata);
            }
            filename = (filename = outfolder + "/" + name).endsWith(".py") ? filename + "c" : filename + ".pyc";
            FileUtils.WriteFile(filename, rawdata, true, true);
        }
    }

    public static pakfile create(String filename, AllGames.GameConversionSub g) {
        pakfile r = new pakfile(filename, g.g, true);
        return r;
    }

    public pakfile(String f, AllGames.GameInfo g, boolean readPythonObjects) {
        this(new File(f), g, readPythonObjects);
    }

    public pakfile(File f, AllGames.GameInfo g, boolean readPythonObjects) {
        int i;
        this.pythonversion = g.PythonVersion;
        byte[] data = UruCrypt.DecryptAny(f.getAbsolutePath(), g);
        ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(data);
        this.objectcount = ((IBytestream)c).readInt();
        for (i = 0; i < this.objectcount; ++i) {
            this.indices.add(new IndexEntry(c, g.game.readversion));
        }
        if (readPythonObjects) {
            for (i = 0; i < this.objectcount; ++i) {
                int offset = this.indices.get((int)i).offset;
                IBytestream c2 = ((IBytestream)c).Fork(offset);
                this.objects.add(new PythonObject(c2, g.game.readversion));
            }
        }
    }

    public byte[] compileEncrypted(Format format) {
        byte[] unencbs = this.compileAlone(format);
        return UruCrypt.EncryptAny(unencbs, format);
    }

    @Override
    public void compile(Bytedeque c) {
        byte[] bs;
        int i;
        if (this.indices.size() != this.objects.size()) {
            m.throwUncaughtException("unexpected");
        }
        int offset = 0;
        offset += 4;
        for (i = 0; i < this.indices.size(); ++i) {
            IndexEntry ind = this.indices.get(i);
            bs = ind.compileAlone(c.format);
            offset += bs.length;
        }
        for (i = 0; i < this.objects.size(); ++i) {
            this.indices.get((int)i).offset = offset;
            PythonObject obj = this.objects.get(i);
            bs = obj.compileAlone(c.format);
            offset += bs.length;
        }
        c.writeInt(this.indices.size());
        for (i = 0; i < this.indices.size(); ++i) {
            this.indices.get(i).compile(c);
        }
        for (i = 0; i < this.objects.size(); ++i) {
            this.objects.get(i).compile(c);
        }
    }

    public void remove(int idx) {
        this.indices.remove(idx);
        this.objects.remove(idx);
    }

    public static class PythonObject
    extends uruobj {
        int objectsize;
        public byte[] rawCompiledPythonObjectData;

        public PythonObject(IBytestream c, int readversion) {
            this.objectsize = c.readInt();
            if (this.objectsize + c.getAbsoluteOffset() > c.getFilelength()) {
                this.objectsize -= 4;
            }
            this.rawCompiledPythonObjectData = c.readBytes(this.objectsize);
        }

        public void compile(Bytedeque c) {
            c.writeInt(this.rawCompiledPythonObjectData.length);
            c.writeBytes(this.rawCompiledPythonObjectData);
        }

        private PythonObject() {
        }

        public static PythonObject create(byte[] rawCompiledHeaderlessPythonObjectData) {
            int length;
            PythonObject result = new PythonObject();
            result.objectsize = length = rawCompiledHeaderlessPythonObjectData.length;
            result.rawCompiledPythonObjectData = rawCompiledHeaderlessPythonObjectData;
            return result;
        }
    }

    public static class IndexEntry
    extends uruobj {
        public Urustring objectname;
        public int offset;

        public IndexEntry(IBytestream c, int readversion) {
            this.objectname = new Urustring(c, readversion);
            this.offset = c.readInt();
        }

        public void compile(Bytedeque c) {
            this.objectname.compile(c);
            c.writeInt(this.offset);
        }
    }
}

