/*
 * Decompiled with CFR 0.152.
 */
package shared;

import classfiles.classfile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import shared.ByteArrayBytestream;
import shared.FileUtils;
import shared.GetResource;
import shared.Pair;
import shared.b;
import shared.m;
import shared.uncaughtexception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class translation {
    private static final String sep = "{->}";
    private static final String defaultlanguage = "en";
    private static final boolean updateEvenWhenNewLanguageIsSameAsPrevious = true;
    private static String curlanguage = "en";
    private static boolean enabled = false;
    private static String pathToStringFiles = null;
    private static boolean doRecordMissingTranslations = true;
    private static LinkedHashSet<String> missingTranslations = new LinkedHashSet();
    private static HashSet<String> allstrings;
    private static Map<String, String> translator;
    private static WeakHashMap<Component, String> defaults;
    private static WeakHashMap<Component, String> resourcecomponents;
    private static WeakHashMap<Container, String> guiforms;

    public static void registerGUIForm(Container c) {
        if (!enabled) {
            return;
        }
        guiforms.put(c, null);
        translation.traverseGuiForm(c, null);
    }

    public static void registerResourceString(String path, JTextComponent textbox) {
        if (!enabled) {
            return;
        }
        resourcecomponents.put(textbox, path);
        translation.traverseResource(textbox);
    }

    public static void enable(String pathToStringFiles2) {
        if (pathToStringFiles2.endsWith("/")) {
            pathToStringFiles2 = pathToStringFiles2.substring(0, pathToStringFiles2.length() - 1);
        }
        pathToStringFiles = pathToStringFiles2;
        enabled = true;
    }

    public static void disable() {
        enabled = false;
    }

    public static String getCurLanguage() {
        return curlanguage;
    }

    public static String getDefaultLanguage() {
        return defaultlanguage;
    }

    public static void test() {
    }

    public static void testCurrentLanguage() {
        translation.testLanguage(curlanguage);
    }

    public static void testLanguage(String language) {
        Vector<Pair<String, String>> lang = new Vector<Pair<String, String>>();
        translation.loadLanguage(language, null, lang);
        LinkedHashSet<String> strings = translation.getAllLiteralStrings();
        for (Pair<String, String> t : lang) {
            if (strings.contains(t.left)) continue;
            m.warn("Translation key is not a string literal(may not be a problem): ", (String)t.left);
        }
        for (Pair<String, String> t : lang) {
            if (!((String)t.right).equals("") || ((String)t.left).equals("")) continue;
            m.warn("Right hand side is empty: ", (String)t.left);
        }
        for (Pair<String, String> t : lang) {
            int freq = 0;
            for (Pair<String, String> s : lang) {
                if (!((String)t.left).equals(s.left)) continue;
                ++freq;
            }
            if (freq <= true) continue;
            m.warn("Key is present more than once: ", (String)t.left);
        }
        m.status("Done testing language!");
    }

    public static void setLanguage(String language) {
        if (!enabled) {
            return;
        }
        String prevlanguage = curlanguage;
        curlanguage = language;
        translator = Collections.synchronizedMap(new HashMap());
        translation.loadLanguage(language, translator, null);
        for (Container c : guiforms.keySet()) {
            translation.traverseGuiForm(c, null);
        }
        ((m.stateclass)m.state.curstate).translate = true;
        GetResource.enableTranslations = true;
        for (Component textbox : resourcecomponents.keySet()) {
            translation.traverseResource(textbox);
        }
    }

    private static void traverseResource(Component c) {
        if (c instanceof JTextComponent) {
            JTextComponent tc = (JTextComponent)c;
            tc.setText(GetResource.getResourceAsString(resourcecomponents.get(tc)));
            if (tc instanceof JTextArea) {
                final JTextComponent textbox2 = tc;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ((JTextArea)textbox2).scrollRectToVisible(new Rectangle(0, 0, 1, 1));
                    }
                });
            }
        }
    }

    private static void loadLanguage(String language, Map<String, String> trans, Vector<Pair<String, String>> output) {
        boolean asresource = true;
        String langFile = asresource ? GetResource.getResourceAsString(pathToStringFiles + "/" + language + ".txt") : FileUtils.ReadFileAsString(FileUtils.GetInitialWorkingDirectory() + "/" + language + ".txt");
        langFile = langFile.replace("\r", "");
        String[] lines = langFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int index = line.indexOf(sep);
            if (index == -1 && (line.startsWith("//") || line.equals(""))) continue;
            String left = line.substring(0, index);
            String right = line.substring(index + sep.length());
            if (left.length() == 0 || right.length() == 0) {
                throw new uncaughtexception("Invalid language file at line " + Integer.toString(i + 1));
            }
            if (trans != null) {
                trans.put(left, right);
            }
            if (output == null) continue;
            output.add(new Pair<String, String>(left, right));
        }
    }

    public static void recordMissingTranslations() {
        doRecordMissingTranslations = true;
        missingTranslations = new LinkedHashSet();
    }

    public static void saveMissingTranslations() {
        allstrings = translation.getAllLiteralStrings();
        StringBuilder result = new StringBuilder();
        StringBuilder result2 = new StringBuilder();
        for (String str : missingTranslations) {
            if (!allstrings.contains(str)) continue;
            result.append(str + sep + "\n");
            result2.append(str + sep + str + "\n");
        }
        byte[] resultdata = b.StringToBytes(result.toString());
        byte[] result2data = b.StringToBytes(result2.toString());
        FileUtils.WriteFile(FileUtils.GetInitialWorkingDirectory() + "/DrizzleNeededTranslations.txt", resultdata);
        FileUtils.WriteFile(FileUtils.GetInitialWorkingDirectory() + "/DrizzleNeededTranslationsB.txt", result2data);
    }

    public static String translate(String ... strs) {
        StringBuilder result = new StringBuilder();
        for (String str : strs) {
            result.append(translation.translate(str));
        }
        return result.toString();
    }

    public static String translate(String str) {
        if (!enabled) {
            return str;
        }
        String result = null;
        if (translator != null) {
            result = translator.get(str);
            if (result == null) {
                boolean didnthave;
                if (curlanguage.equals(defaultlanguage) || !doRecordMissingTranslations || str == null || str.equals("") || (didnthave = missingTranslations.add(str))) {
                    // empty if block
                }
                result = str;
            }
        } else {
            result = str;
        }
        return result;
    }

    public static void printStringsForAllGuiForms() {
        LinkedHashSet<String> vals = new LinkedHashSet<String>();
        translation.getAllCurrentGuiStrings(vals);
        StringBuilder output = new StringBuilder();
        for (String s : vals) {
            output.append(s + sep + "\n");
        }
        FileUtils.WriteFile(FileUtils.GetInitialWorkingDirectory() + "/drizzleGuiformsStrings.txt", b.StringToBytes(output.toString()));
    }

    private static void getAllCurrentGuiStrings(LinkedHashSet<String> vals) {
        for (Container form : guiforms.keySet()) {
            translation.traverseGuiForm(form, vals);
        }
    }

    public static LinkedHashSet<String> getAllLiteralStrings() {
        LinkedHashSet<String> vals = new LinkedHashSet<String>();
        String[] ignorePackages = new String[]{"/org/bouncycastle", "/org/apache", "/org/mortbay", "/javax", "/ie/wombat", "/SevenZip", "/automation/fileLists"};
        for (String res : GetResource.listAllResources()) {
            boolean skip = false;
            for (String ig : ignorePackages) {
                if (!res.startsWith(ig)) continue;
                skip = true;
            }
            if (skip || !res.endsWith(".class")) continue;
            ByteArrayBytestream c = ByteArrayBytestream.createFromByteArray(GetResource.getResourceAsByteArray(res));
            classfile cf = new classfile(c);
            for (String s : cf.getAllConstantStrings()) {
                if (s.contains("\n") || s.contains("\r") || s.contains(sep)) continue;
                vals.add(s);
            }
        }
        return vals;
    }

    public static void saveCurrentStrings() {
        LinkedHashSet<String> vals = translation.getAllLiteralStrings();
        StringBuilder result = new StringBuilder();
        for (String val : vals) {
            if (val.equals("")) continue;
            result.append(val + sep + "\n");
        }
        String result2 = result.toString();
        FileUtils.WriteFile(FileUtils.GetInitialWorkingDirectory() + "/drizzle.allstrings.txt", b.StringToBytes(result2));
    }

    private static void traverseGuiForm(Container c, Set vals) {
        Container frame;
        for (Component child : c.getComponents()) {
            if (!(child instanceof Container)) continue;
            translation.traverseGuiForm((Container)child, vals);
        }
        if (c instanceof JComponent) {
            JComponent c2 = (JComponent)c;
            Boolean trans = (Boolean)c2.getClientProperty("trans");
            if (trans == null) {
                trans = true;
            }
            if (!trans.booleanValue()) {
                return;
            }
        }
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            String def = defaults.get(c);
            if (def == null) {
                def = label.getText();
                defaults.put(c, def);
            }
            label.setText(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
        } else if (c instanceof JButton) {
            JButton button = (JButton)c;
            String def = defaults.get(c);
            if (def == null) {
                def = button.getText();
                defaults.put(c, def);
            }
            button.setText(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
        } else if (c instanceof JPanel) {
            JPanel panel = (JPanel)c;
            Border border = panel.getBorder();
            if (border instanceof TitledBorder) {
                TitledBorder tborder = (TitledBorder)border;
                String def = defaults.get(c);
                if (def == null) {
                    def = tborder.getTitle();
                    defaults.put(c, def);
                }
                tborder.setTitle(translation.translate(def));
                if (vals != null) {
                    vals.add(def);
                }
            }
        } else if (c instanceof JCheckBox) {
            JCheckBox checkbox = (JCheckBox)c;
            String def = defaults.get(c);
            if (def == null) {
                def = checkbox.getText();
                defaults.put(c, def);
            }
            checkbox.setText(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
        } else if (c instanceof JRadioButton) {
            JRadioButton radiobutton = (JRadioButton)c;
            String def = defaults.get(c);
            if (def == null) {
                def = radiobutton.getText();
                defaults.put(c, def);
            }
            radiobutton.setText(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
        } else if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            for (int i = 0; i < tabs.getTabCount(); ++i) {
                Component tab = tabs.getComponentAt(i);
                JComponent ptab = (JComponent)tab;
                String def = defaults.get(tab);
                if (def == null) {
                    def = tabs.getTitleAt(i);
                    defaults.put(tab, def);
                }
                tabs.setTitleAt(i, translation.translate(def));
                if (vals == null) continue;
                vals.add(def);
            }
        } else if (c instanceof JDialog) {
            frame = (JDialog)c;
            String def = defaults.get(c);
            if (def == null) {
                def = ((Dialog)frame).getTitle();
                defaults.put(c, def);
            }
            ((Dialog)frame).setTitle(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
            c.repaint();
        } else if (c instanceof JFrame) {
            frame = (JFrame)c;
            String def = defaults.get(c);
            if (def == null) {
                def = ((Frame)frame).getTitle();
                defaults.put(c, def);
            }
            ((Frame)frame).setTitle(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
            c.repaint();
        } else if (c instanceof JFileChooser) {
            frame = (JFileChooser)c;
            String def = defaults.get(c);
            if (def == null) {
                def = ((JFileChooser)frame).getDialogTitle();
                defaults.put(c, def);
            }
            ((JFileChooser)frame).setDialogTitle(translation.translate(def));
            if (vals != null) {
                vals.add(def);
            }
            c.repaint();
        }
    }

    static {
        defaults = new WeakHashMap();
        resourcecomponents = new WeakHashMap();
        guiforms = new WeakHashMap();
    }
}

