/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractHandler
extends AbstractLifeCycle
implements Handler {
    private Server _server;

    protected void doStart() throws Exception {
        Log.debug("starting {}", this);
    }

    protected void doStop() throws Exception {
        Log.debug("stopping {}", this);
    }

    public String toString() {
        StringBuilder b2 = new StringBuilder();
        String s = super.toString();
        b2.append(s, s.lastIndexOf(46) + 1, s.length());
        ContextHandler.Context ctx = ContextHandler.getCurrentContext();
        if (ctx != null && ctx.getContextPath() != null && !(this instanceof ContextHandler)) {
            b2.append('@');
            b2.append(ctx.getContextPath());
        }
        return b2.toString();
    }

    public void setServer(Server server) {
        Server old_server = this._server;
        if (old_server != null && old_server != server) {
            old_server.getContainer().removeBean(this);
        }
        this._server = server;
        if (this._server != null && this._server != old_server) {
            this._server.getContainer().addBean(this);
        }
    }

    public Server getServer() {
        return this._server;
    }

    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        if (this._server != null) {
            this._server.getContainer().removeBean(this);
        }
    }

    public String dump() {
        StringBuilder b2 = new StringBuilder();
        this.dump(b2, "");
        return b2.toString();
    }

    protected void dump(StringBuilder b2, String indent) {
        b2.append(this.toString());
        b2.append(this.isStarted() ? " started" : " STOPPED");
        b2.append('\n');
    }
}

