/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.SchemaCommand;
import org.h2.command.dml.Query;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.TableView;

public class CreateView
extends SchemaCommand {
    private Query select;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean recursive;

    public CreateView(Session session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public void setRecursive(boolean bl) {
        this.recursive = bl;
    }

    public void setSelect(Query query) {
        this.select = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update() {
        TableView tableView;
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.viewName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90038, this.viewName);
        }
        int n = this.getObjectId();
        String string = this.select == null ? this.selectSQL : this.select.getSQL();
        Session session = database.getSystemSession();
        try {
            Schema schema = this.session.getDatabase().getSchema(this.session.getCurrentSchemaName());
            session.setCurrentSchema(schema);
            tableView = new TableView(this.getSchema(), n, this.viewName, string, null, this.columnNames, session, this.recursive);
        }
        finally {
            session.setCurrentSchema(database.getSchema("PUBLIC"));
        }
        tableView.setComment(this.comment);
        try {
            tableView.recompileQuery(this.session);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        database.addSchemaObject(this.session, tableView);
        return 0;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setSelectSQL(String string) {
        this.selectSQL = string;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    public void setComment(String string) {
        this.comment = string;
    }
}

