//
//  CLHorizontalMonthView.m
//  DateLine
//
//  Created by Alex Clarke on 10/05/05.
//  Copyright 2005 CocoaLab. All rights reserved.
//

#import "CLHorizontalMonthView.h"
#import "CLDateElement.h"
#import "NSBezierPath+CLExtensions.h"
#import "NSColor+CLExtensions.h"


@implementation CLHorizontalMonthView

//Draw the graphics view
- (void)drawRect:(NSRect)rect
{	
	NSRect myBounds = [self bounds];
	
	//Some useful attributes
	double left = NSMinX(myBounds);
	double right = NSMaxX(myBounds);
	//double top = NSMaxY(myBounds);
	//double bottom = NSMinY(myBounds);
	double vCentre = NSMidY(myBounds);
	//double hCentre = NSMidX(myBounds);
	double width = myBounds.size.width;
				
	/* Draw elements */
	//Draw from left to right
	NSArray * graphicsArray = [self graphics];
	int g = [graphicsArray count];
	float d = width/g; //column width
	int i = 0; //column iterator 
	NSEnumerator *graphicsEnumerator = [graphicsArray objectEnumerator];
	id graphic;
	while (graphic = [graphicsEnumerator nextObject])
	{
		float yOffset = vCentre;
		float xOffset = 12 + left + (d*i); //left align
		[graphic setYLoc:yOffset];
		[graphic setXLoc:xOffset];
		[graphic drawInView:self];	//draw the element!
		i++;
	}
		
	//draw a line across the middle of the view
	NSBezierPath *midLine = [NSBezierPath bezierPath];
	[midLine moveToPoint:NSMakePoint(left+3, vCentre)];
	[midLine lineToPoint:NSMakePoint(right-(width/i)+22, vCentre)];
	[midLine setLineCapStyle:NSButtLineCapStyle];
	[midLine setLineJoinStyle:NSRoundLineJoinStyle];
	[[self lineColor] set];
	[midLine setLineWidth:0.3];
	[midLine stroke];
	
	// Draw a selection around items in the current selection.
	// Selection should be handled by the graphic, but this is a
	// shortcut simply for display.
	 
	NSIndexSet *currentSelectionIndexes = [self selectionIndexes];
	if (currentSelectionIndexes != nil)
	{
		NSBezierPath *selectionPath = [NSBezierPath bezierPath];
		unsigned int index = [currentSelectionIndexes firstIndex];
		while (index != NSNotFound)
		{
			graphic = [graphicsArray objectAtIndex:index];
			NSRect graphicDrawingBounds = [graphic drawingBounds];
			if (NSIntersectsRect(rect, graphicDrawingBounds))
			{
				[selectionPath appendBezierPath: [NSBezierPath bezierPathWithRoundRectInRect: graphicDrawingBounds radius:6]];
			}
			index = [currentSelectionIndexes indexGreaterThanIndex:index];
		}
		//Draw the selection rect
		NSColor * selectionColor = [NSColor colorWithCalibratedRed:0.0 green:0.2 blue:0.8 alpha:0.0];
		[selectionColor set];
		[selectionPath setLineWidth:0.5];
		[selectionPath fill];
	}
}

-(void)mouseEntered:(NSEvent *)event
{
	//NSLog(@"mouse entered");
}

- (void)mouseDown:(NSEvent *)event
{
	[super mouseDown:event];
	
	/* Fairly simple just to illustrate the point */
	NSNotificationCenter * centre = [NSNotificationCenter defaultCenter];

	// find out if we hit anything
	NSPoint p = [self convertPoint:[event locationInWindow] fromView:nil];
	NSEnumerator *gEnum = [[self graphics] reverseObjectEnumerator];
	id aGraphic;
	while (aGraphic = [gEnum nextObject])
	{
		if ([aGraphic hitTest:p isSelected:NO])
		{
			break;
		}
	}
	
	// if no graphic hit, then if extending selection do nothing
	// else set selection to nil
	if (aGraphic == nil)
	{
		if (!([event modifierFlags] & NSShiftKeyMask))
		{
			[selectionIndexesContainer setValue:nil forKeyPath:selectionIndexesKeyPath];
		}
		return;
	}
	
	// graphic hit
	// if not extending selection (Shift key down) then set
	// selection to this graphic
	// if extending selection, then:
	// - if graphic in selection remove it
	// - if not in selection add it
	NSIndexSet *selection = nil;
	unsigned int graphicIndex = [[self graphics] indexOfObject:aGraphic];
	
	if (!([event modifierFlags] & NSShiftKeyMask))
	{
		selection = [NSIndexSet indexSetWithIndex:graphicIndex];
		if ([event clickCount] == 2) //If it's a double click
		{
			NSCalendarDate * aDate = [aGraphic valueForKey:@"date"];
			[centre postNotificationName:@"selectDayNotification" object:aDate];
			return;
		}		
	}
	else
	{
		if ([[self selectionIndexes] containsIndex:graphicIndex])
		{
			selection = [[[self selectionIndexes] mutableCopy] autorelease];
			[(NSMutableIndexSet *)selection removeIndex:graphicIndex];
		}
		else
		{
			selection = [[[self selectionIndexes] mutableCopy] autorelease];
			[(NSMutableIndexSet *)selection addIndex:graphicIndex];
		}
	}
	[selectionIndexesContainer setValue:selection forKeyPath:selectionIndexesKeyPath];
}

+ (Class)class
{
	return [super class];
}

-(BOOL)isOpaque
{
	return NO;
}

-(void) dealloc
{
	[super dealloc];	
}

#pragma mark Accessors

- (NSColor *)lineColor {
	return [[lineColor retain] autorelease];
}

- (void)setLineColor:(NSColor *)value {
	if (lineColor != value) {
		[lineColor release];
		lineColor = [value copy];
		[self setNeedsDisplay:YES];
	}
}

@end
