//
//  AlertPanelUp.m
//  BwanaDik
//
//  Created by John Schilling on 11/28/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "AlertPanelUp.h"
#import "NSStringExtras.h"

#define DEFAULT_AUTOCLOSE_SECS      300.0
#define DEFAULT_ANIME_SPEED         1.250

@implementation AlertPanelUp

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)init
{
    if( ![super init] ) return nil;
    _lastAppPath = [[NSMutableString alloc] init];
    _alertOpen = NO;
    return self;
}

- (void)awakeFromNib
{

}

- (BOOL)windowShouldClose:(id)sender
{
    [self killAlert];
    return YES;
}

- (void)dealloc
{
    [_lastAppPath release];
    _lastAppPath = nil;
    [super dealloc];
}





- (void)runAlertPanelWithWANAddress:(NSString *)WANAddress 
                         LANAddress:(NSString *)LANAddress 
                             status:(BDConnectionState)status 
                          autoClose:(BOOL)autoClose
{
    _alertOpen = YES;

    [_alertPanelImageView setImage:[NSImage imageNamed:@"Alert1.tif"]];

    if (WANAddress && [WANAddress isValidAddress]) {
        [_alertPanelExternalIPField setStringValue:WANAddress];
    } else {
        if (status == BDBusyServer) {
            [_alertPanelExternalIPField setStringValue:@"Unknown (busy)"];
        } else {
            [_alertPanelExternalIPField setStringValue:@"Unknown"];
        }
    }
    
    if (LANAddress && [LANAddress isValidAddress]) {
        [_alertPanelLocalIPField setStringValue:LANAddress];
    } else {
        [_alertPanelLocalIPField setStringValue:@"Unknown"];
    }
    
    [self setLastApplicationPath];
    [NSApp activateIgnoringOtherApps:YES];
    [[self window] center];
    [[self window] makeKeyAndOrderFront:self];
    [[self window] display];
    
    if (autoClose) [self startCloseTimer];
    [self startAnimeTimer];
}

- (void)killAlert
{
    if (!_alertOpen) return;
    _alertOpen = NO;

    [self stopCloseTimer];
    [self stopAnimeTimer];
    [[self window] close];
    [self returnFocusToLastApplication];
}


- (void)startCloseTimer
{
    [self stopCloseTimer];
    
    NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval:(float)DEFAULT_AUTOCLOSE_SECS
                            target:self 
                            selector:@selector(closeTimerFired:) 
                            userInfo:nil 
                            repeats:NO];
    if (timer) _closeTimer = [timer retain];
}

- (void)stopCloseTimer
{
    if (_closeTimer) [_closeTimer invalidate];
    if (_closeTimer) [_closeTimer release];
    _closeTimer = nil;
}

- (void)closeTimerFired:(NSTimer *)timer
{
    [self killAlert];
}


- (void)startAnimeTimer
{
    [self stopAnimeTimer];
    
    NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval:(float)DEFAULT_ANIME_SPEED
                            target:self 
                            selector:@selector(animeTimerFired:) 
                            userInfo:nil 
                            repeats:YES];
    if (timer) _animeTimer = [timer retain];
}

- (void)stopAnimeTimer
{
    if (_animeTimer) [_animeTimer invalidate];
    if (_animeTimer) [_animeTimer release];
    _animeTimer  = nil;
    _animeSwitch = YES;
}

- (void)animeTimerFired:(NSTimer *)timer
{
    _animeSwitch = !_animeSwitch;
    [_alertPanelImageView setImage:[NSImage imageNamed:[NSString stringWithFormat:@"Alert%d.tif", _animeSwitch]]];
}






- (void)setLastApplicationPath
{
    NSDictionary *appDict = [[NSWorkspace sharedWorkspace] activeApplication];
    if (appDict == nil) {
        _lastAppPath = nil;
        return;
    }
    NSString *myPath = [[NSBundle mainBundle] bundlePath];
    NSString *appPath = [appDict objectForKey:@"NSApplicationPath"];
    if (![myPath isEqualToString:appPath]) {
        [_lastAppPath setString: appPath];
    }
}

- (void)returnFocusToLastApplication
{
    if (_lastAppPath == nil || ([_lastAppPath length] < 1)) return;
    NSArray *activeApps = [[NSWorkspace sharedWorkspace] launchedApplications];
    
    NSEnumerator *appsEnum = [activeApps objectEnumerator];
    id anApp;
    while (anApp = [appsEnum nextObject]) {
        NSString *appPath = [anApp objectForKey:@"NSApplicationPath"];
        NSString *appName = [anApp objectForKey:@"NSApplicationName"];
        if ([appPath isEqualToString:_lastAppPath] && ![appName isEqualToString:@"Finder"]) {
            [[NSWorkspace sharedWorkspace] launchApplication: _lastAppPath];
        }
    }
    [_lastAppPath setString:@""];
}


@end
