/*
	AppHack - An Application Bundle Editor and Application Theme Tool for Mac OS X

    Copyright (C) 2004-2006 	Sveinbjorn Thordarson <sveinbjornt@simnet.is>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#import "NibList.h"


@implementation NibList


- init
{
    self = [super init];
	nibs = [[NSMutableDictionary dictionaryWithCapacity: 255] retain];
    return self;
}

- initWithResourcesPath: (NSString*)path 
{
	int isDir, i, j;
	NSMutableDictionary	*entry;
	NSMutableArray		*items = [[NSMutableArray alloc] initWithCapacity: 255];
	NSMutableDictionary *lprojEntry;
	NSMutableArray		*lprojItems;
	NSString			*itemPath;

	self = [self init];
	resourcesPath = path;
	
	[nibs setObject: @"Nibs" forKey: @"Name"];
	[nibs setObject: resourcesPath forKey: @"Path"];
	[nibs setObject: items forKey: @"Items"];
	

	NSString *file;
	NSDirectoryEnumerator *enumerator = [[NSFileManager defaultManager] enumeratorAtPath: resourcesPath];

	while (file = [enumerator nextObject]) 
	{
		if ([[file pathExtension] isEqualToString:@"lproj"])
		{
			[enumerator skipDescendents];
            entry = [NSMutableDictionary dictionaryWithCapacity: 3];
			[entry setObject: [NSString stringWithFormat: @"%@/%@", resourcesPath, file] forKey: @"Path"];
			[entry setObject: [file lastPathComponent] forKey: @"Name"];
			[items addObject: entry];
		}
		else if ([[file pathExtension] isEqualToString:@"nib"])
		{
			[enumerator skipDescendents];
            entry = [NSMutableDictionary dictionaryWithCapacity: 3];
			[entry setObject: [NSString stringWithFormat: @"%@/%@", resourcesPath, file] forKey: @"Path"];
			[entry setObject: [file lastPathComponent] forKey: @"Name"];
			[items addObject: entry];
		}
		else
			[enumerator skipDescendents];
	}
	
	//set nibs within lprojs
	for (i = 0; i < [items count]; i++)
	{
		//NSLog([[items objectAtIndex: i] objectForKey: @"Path"]);
		NSString *lprojPath = [[items objectAtIndex: i] objectForKey: @"Path"];
		if (![lprojPath hasSuffix: @"lproj"])
			continue;
		NSArray *lprojSubPaths = [[NSFileManager defaultManager] directoryContentsAtPath: lprojPath];
		NSMutableArray	*lprojSubItems = [NSMutableArray arrayWithCapacity: 255];
		
		for (j = 0; j < [lprojSubPaths count]; j++)
		{
			if ([[lprojSubPaths objectAtIndex: j] hasSuffix: @"nib"])//if it has nib extension, we add it as subitem of lproj
			{
				NSMutableDictionary *subItem = [NSMutableDictionary dictionaryWithCapacity: 3];
				[subItem setObject: [NSString stringWithFormat: @"%@/%@", lprojPath, [lprojSubPaths objectAtIndex: j]] forKey: @"Path"];
				[subItem setObject: [[lprojSubPaths objectAtIndex: j] lastPathComponent] forKey: @"Name"];
				//NSLog(@"Adding %@ to %@", [lprojSubPaths objectAtIndex: j], [[items objectAtIndex: i] objectForKey: @"Path"]);
				[lprojSubItems addObject: subItem];
			}
		}
		//add the array of lproj subitems to the lproj item
		[[items objectAtIndex: i] setObject: lprojSubItems forKey: @"Items"];
	}
	
	return self;
}
	

- (NSString *)resourcesPath
{
	return resourcesPath;
}

- (void)setResourcesPath: (NSString *)path
{
	resourcesPath = path;
}

- (int)outlineView:(NSOutlineView *)outlineView numberOfChildrenOfItem:(id)item 
{
    return (item == nil) ? 1 : [[item objectForKey:@"Items"] count];
}

- (BOOL)outlineView:(NSOutlineView *)outlineView isItemExpandable:(id)item
{
	if ([item objectForKey: @"Items"] != NULL)
		return YES;

	return NO;
}

- (id)outlineView:(NSOutlineView *)outlineView child:(int)index ofItem:(id)item
{
	return (item == nil) ? nibs: [[item objectForKey: @"Items"] objectAtIndex: index];
}

- (id)outlineView:(NSOutlineView *)outlineView objectValueForTableColumn:(NSTableColumn *)tableColumn byItem:(id)item
{
	return (item == nil) ? @"bleh" : (id)[item objectForKey: @"Name"];
}





- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
	return([nibs count]);
}


@end
