/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import java.util.Optional;
import org.gradle.api.Describable;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.worker.MultiRequestClient;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.workers.internal.ActionExecutionSpecFactory;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;
import org.gradle.workers.internal.IsolatedParametersActionExecutionSpec;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.TransportableActionExecutionSpec;

class WorkerDaemonClient
implements Stoppable,
Describable {
    public static final String DISABLE_EXPIRATION_PROPERTY_KEY = "org.gradle.workers.internal.disable-daemons-expiration";
    private final DaemonForkOptions forkOptions;
    private final MultiRequestClient<TransportableActionExecutionSpec, DefaultWorkResult> workerClient;
    private final WorkerProcess workerProcess;
    private final LogLevel logLevel;
    private final ActionExecutionSpecFactory actionExecutionSpecFactory;
    private int uses;
    private boolean cannotBeExpired = Boolean.getBoolean("org.gradle.workers.internal.disable-daemons-expiration");

    public WorkerDaemonClient(DaemonForkOptions forkOptions, MultiRequestClient<TransportableActionExecutionSpec, DefaultWorkResult> workerClient, WorkerProcess workerProcess, LogLevel logLevel, ActionExecutionSpecFactory actionExecutionSpecFactory) {
        this.forkOptions = forkOptions;
        this.workerClient = workerClient;
        this.workerProcess = workerProcess;
        this.logLevel = logLevel;
        this.actionExecutionSpecFactory = actionExecutionSpecFactory;
    }

    public DefaultWorkResult execute(IsolatedParametersActionExecutionSpec<?> spec) {
        ++this.uses;
        return (DefaultWorkResult)this.workerClient.run((Object)this.actionExecutionSpecFactory.newTransportableSpec(spec));
    }

    public boolean isCompatibleWith(DaemonForkOptions required) {
        return this.forkOptions.isCompatibleWith(required);
    }

    JvmMemoryStatus getJvmMemoryStatus() {
        return this.workerProcess.getJvmMemoryStatus();
    }

    public void stop() {
        this.workerClient.stop();
    }

    DaemonForkOptions getForkOptions() {
        return this.forkOptions;
    }

    public int getUses() {
        return this.uses;
    }

    public KeepAliveMode getKeepAliveMode() {
        return this.forkOptions.getKeepAliveMode();
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public boolean isFailed() {
        return this.workerProcess.getExecResult().map(execResult -> execResult.getExitValue() != 0).orElse(false);
    }

    public Optional<Integer> getExitCode() {
        return this.workerProcess.getExecResult().map(ExecResult::getExitValue);
    }

    public boolean isNotExpirable() {
        return this.cannotBeExpired;
    }

    public String getDisplayName() {
        return this.workerProcess.getDisplayName();
    }

    public String toString() {
        return "WorkerDaemonClient{ log level=" + this.logLevel + ", use count=" + this.uses + ", has failed=" + this.isFailed() + ", can be expired=" + !this.cannotBeExpired + ", workerProcess=" + this.workerProcess + ", forkOptions=" + this.forkOptions + '}';
    }
}

