/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x9;

import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.bouncycastle.asn1.x9.X962NamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;

public class ECNamedCurveTable {
    public static X9ECParameters getByName(String name) {
        X9ECParameters ecP = X962NamedCurves.getByName(name);
        if (ecP == null) {
            ecP = SECNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = TeleTrusTNamedCurves.getByName(name);
        }
        if (ecP == null) {
            ecP = NISTNamedCurves.getByName(name);
        }
        return ecP;
    }

    public static ASN1ObjectIdentifier getOID(String name) {
        ASN1ObjectIdentifier oid = X962NamedCurves.getOID(name);
        if (oid == null) {
            oid = SECNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = TeleTrusTNamedCurves.getOID(name);
        }
        if (oid == null) {
            oid = NISTNamedCurves.getOID(name);
        }
        return oid;
    }

    public static X9ECParameters getByOID(ASN1ObjectIdentifier oid) {
        X9ECParameters ecP = X962NamedCurves.getByOID(oid);
        if (ecP == null) {
            ecP = SECNamedCurves.getByOID(oid);
        }
        if (ecP == null) {
            ecP = TeleTrusTNamedCurves.getByOID(oid);
        }
        return ecP;
    }

    public static Enumeration getNames() {
        Vector v = new Vector();
        ECNamedCurveTable.addEnumeration(v, X962NamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, SECNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, NISTNamedCurves.getNames());
        ECNamedCurveTable.addEnumeration(v, TeleTrusTNamedCurves.getNames());
        return v.elements();
    }

    private static void addEnumeration(Vector v, Enumeration e) {
        while (e.hasMoreElements()) {
            v.addElement(e.nextElement());
        }
    }
}

