/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet.structures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.internal.spreadsheet.structures.Cell;
import org.xmind.ui.internal.spreadsheet.structures.Chart;
import org.xmind.ui.internal.spreadsheet.structures.ColumnHead;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements Comparable<Column> {
    private Chart ownedChart;
    private ColumnHead head;
    private List<Cell> cells = new ArrayList<Cell>();
    private int prefCellWidth = -1;
    private Integer left = null;
    private Integer width = null;

    public Column(Chart ownedChart, ColumnHead head) {
        Assert.isNotNull((Object)((Object)ownedChart));
        Assert.isNotNull((Object)head);
        this.ownedChart = ownedChart;
        this.head = head;
    }

    public Chart getOwnedChart() {
        return this.ownedChart;
    }

    public ColumnHead getHead() {
        return this.head;
    }

    void addCell(Cell cell) {
        this.cells.add(cell);
    }

    void removeCell(Cell cell) {
        this.cells.remove((Object)cell);
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    @Override
    public int compareTo(Column o) {
        return this.getOwnedChart().getPrefColumnOrder().compareColumns(this.getHead(), o.getHead());
    }

    public int getPrefCellWidth() {
        if (this.prefCellWidth < 0) {
            this.prefCellWidth = this.calcPrefCellWidth();
        }
        return this.prefCellWidth;
    }

    private int calcPrefCellWidth() {
        int w = this.head.getPrefSize().width;
        for (Cell cell : this.cells) {
            w = Math.max(w, cell.getPrefContentSize().width);
        }
        return w;
    }

    public int getPrefWidth() {
        return Math.max(this.head.getPrefSize().width, this.getPrefCellWidth());
    }

    public Cell getPreviousCell(Cell cell) {
        int index = this.getCellIndex(cell);
        if (index > 0) {
            return this.cells.get(index - 1);
        }
        return null;
    }

    public Cell getNextCell(Cell cell) {
        int index = this.getCellIndex(cell);
        if (index < this.cells.size() - 1) {
            return this.cells.get(index + 1);
        }
        return null;
    }

    public int getCellIndex(Cell cell) {
        return this.cells.indexOf((Object)cell);
    }

    public int getLeft() {
        this.ensurePosition();
        return this.left;
    }

    public int getWidth() {
        this.ensurePosition();
        return this.width;
    }

    public int getRight() {
        return this.getLeft() + this.getWidth();
    }

    private void ensurePosition() {
        int w;
        int x;
        if (this.left != null && this.width != null) {
            return;
        }
        int lineWidth = this.getOwnedChart().getLineWidth();
        int index = this.getOwnedChart().getColumnIndex(this);
        IInsertion ins = (IInsertion)MindMapUtils.getCache((IPart)this.getOwnedChart().getTitle(), (String)"org.xmind.ui.spreadsheet.cache.columnInsertion");
        if (index == 0) {
            x = this.getOwnedChart().getTitle().getFigure().getBounds().x + lineWidth + this.getOwnedChart().getRowHeadWidth() + lineWidth + this.getOwnedChart().getMinorSpacing();
        } else {
            Column prev = this.getOwnedChart().getColumn(index - 1);
            x = prev.getRight() + lineWidth;
        }
        if (ins != null && ins.getIndex() == index) {
            x += ins.getSize().width + this.getOwnedChart().getMinorSpacing() + lineWidth;
        }
        this.left = x;
        int numCols = this.getOwnedChart().getNumColumns();
        if (index == numCols - 1) {
            int right = this.getOwnedChart().getTitle().getFigure().getBounds().right();
            if (ins != null && ins.getIndex() == numCols) {
                right -= ins.getSize().width + this.getOwnedChart().getMinorSpacing() + lineWidth;
            }
            w = right - lineWidth - this.left;
        } else {
            int headWidth = this.head.getPrefSize().width;
            w = Math.max(headWidth, this.getPrefCellWidth()) + this.getOwnedChart().getMinorSpacing();
        }
        this.width = w;
    }

    public String toString() {
        return this.getHead().toString();
    }
}

